/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import java.io.IOException;
import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.apache.storm.shade.org.jboss.netty.buffer.ChannelBuffers;

enum ControlMessage {
    CLOSE_MESSAGE(-100),
    EOB_MESSAGE(-201),
    OK_RESPONSE(-200),
    FAILURE_RESPONSE(-400),
    SASL_TOKEN_MESSAGE_REQUEST(-202),
    SASL_COMPLETE_REQUEST(-203);

    private short code;

    private ControlMessage(short code) {
        this.code = code;
    }

    static ControlMessage mkMessage(short encoded) {
        for (ControlMessage cm : ControlMessage.values()) {
            if (encoded != cm.code) continue;
            return cm;
        }
        return null;
    }

    int encodeLength() {
        return 2;
    }

    ChannelBuffer buffer() throws IOException {
        ChannelBufferOutputStream bout = new ChannelBufferOutputStream(ChannelBuffers.directBuffer(this.encodeLength()));
        this.write(bout);
        bout.close();
        return bout.buffer();
    }

    void write(ChannelBufferOutputStream bout) throws IOException {
        bout.writeShort(this.code);
    }
}

