/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import backtype.storm.messaging.IConnection;
import backtype.storm.messaging.IContext;
import backtype.storm.messaging.netty.Client;
import backtype.storm.messaging.netty.NettyRenameThreadFactory;
import backtype.storm.messaging.netty.Server;
import backtype.storm.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.storm.shade.org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.apache.storm.shade.org.jboss.netty.util.HashedWheelTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context
implements IContext {
    private static final Logger LOG = LoggerFactory.getLogger(Context.class);
    private Map storm_conf;
    private Map<String, IConnection> connections;
    private NioClientSocketChannelFactory clientChannelFactory;
    private HashedWheelTimer clientScheduleService;

    @Override
    public void prepare(Map storm_conf) {
        this.storm_conf = storm_conf;
        this.connections = new HashMap<String, IConnection>();
        int maxWorkers = Utils.getInt(storm_conf.get("storm.messaging.netty.client_worker_threads"));
        NettyRenameThreadFactory bossFactory = new NettyRenameThreadFactory("client-boss");
        NettyRenameThreadFactory workerFactory = new NettyRenameThreadFactory("client-worker");
        this.clientChannelFactory = maxWorkers > 0 ? new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), Executors.newCachedThreadPool(workerFactory), maxWorkers) : new NioClientSocketChannelFactory(Executors.newCachedThreadPool(bossFactory), Executors.newCachedThreadPool(workerFactory));
        this.clientScheduleService = new HashedWheelTimer(new NettyRenameThreadFactory("client-schedule-service"));
    }

    @Override
    public synchronized IConnection bind(String storm_id, int port) {
        Server server = new Server(this.storm_conf, port);
        this.connections.put(this.key(storm_id, port), server);
        return server;
    }

    @Override
    public synchronized IConnection connect(String storm_id, String host, int port) {
        IConnection connection = this.connections.get(this.key(host, port));
        if (connection != null) {
            return connection;
        }
        Client client = new Client(this.storm_conf, this.clientChannelFactory, this.clientScheduleService, host, port, this);
        this.connections.put(this.key(host, port), client);
        return client;
    }

    synchronized void removeClient(String host, int port) {
        this.connections.remove(this.key(host, port));
    }

    @Override
    public synchronized void term() {
        this.clientScheduleService.stop();
        for (IConnection conn : this.connections.values()) {
            conn.close();
        }
        this.connections = null;
        this.clientChannelFactory.releaseExternalResources();
    }

    private String key(String host, int port) {
        return String.format("%s:%d", host, port);
    }
}

