/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.messaging.netty;

import backtype.storm.messaging.ConnectionWithStatus;
import backtype.storm.messaging.TaskMessage;
import backtype.storm.messaging.netty.Context;
import backtype.storm.messaging.netty.MessageBatch;
import backtype.storm.messaging.netty.MessageBuffer;
import backtype.storm.messaging.netty.StormClientPipelineFactory;
import backtype.storm.metric.api.IStatefulObject;
import backtype.storm.utils.StormBoundedExponentialBackoffRetry;
import backtype.storm.utils.Utils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.shade.com.google.common.base.Preconditions;
import org.apache.storm.shade.org.jboss.netty.bootstrap.ClientBootstrap;
import org.apache.storm.shade.org.jboss.netty.channel.Channel;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelFactory;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelFuture;
import org.apache.storm.shade.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.storm.shade.org.jboss.netty.util.HashedWheelTimer;
import org.apache.storm.shade.org.jboss.netty.util.Timeout;
import org.apache.storm.shade.org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
extends ConnectionWithStatus
implements IStatefulObject {
    private static final long PENDING_MESSAGES_FLUSH_TIMEOUT_MS = 600000L;
    private static final long PENDING_MESSAGES_FLUSH_INTERVAL_MS = 1000L;
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private static final String PREFIX = "Netty-Client-";
    private static final long NO_DELAY_MS = 0L;
    private final Map stormConf;
    private final StormBoundedExponentialBackoffRetry retryPolicy;
    private final ClientBootstrap bootstrap;
    private final InetSocketAddress dstAddress;
    protected final String dstAddressPrefixedName;
    private final AtomicReference<Channel> channelRef = new AtomicReference();
    private final AtomicInteger totalConnectionAttempts = new AtomicInteger(0);
    private final AtomicInteger connectionAttempts = new AtomicInteger(0);
    private final AtomicInteger messagesSent = new AtomicInteger(0);
    private final AtomicInteger messagesLost = new AtomicInteger(0);
    private final AtomicLong pendingMessages = new AtomicLong(0L);
    private volatile boolean closing = false;
    private final Context context;
    private final HashedWheelTimer scheduler;
    private final MessageBuffer batcher;
    private final Object writeLock = new Object();

    Client(Map stormConf, ChannelFactory factory2, HashedWheelTimer scheduler, String host, int port, Context context2) {
        this.stormConf = stormConf;
        this.closing = false;
        this.scheduler = scheduler;
        this.context = context2;
        int bufferSize = Utils.getInt(stormConf.get("storm.messaging.netty.buffer_size"));
        LOG.info("creating Netty Client, connecting to {}:{}, bufferSize: {}", new Object[]{host, port, bufferSize});
        int messageBatchSize = Utils.getInt(stormConf.get("storm.messaging.netty.transfer.batch.size"), 262144);
        int maxReconnectionAttempts = Utils.getInt(stormConf.get("storm.messaging.netty.max_retries"));
        int minWaitMs = Utils.getInt(stormConf.get("storm.messaging.netty.min_wait_ms"));
        int maxWaitMs = Utils.getInt(stormConf.get("storm.messaging.netty.max_wait_ms"));
        this.retryPolicy = new StormBoundedExponentialBackoffRetry(minWaitMs, maxWaitMs, maxReconnectionAttempts);
        this.bootstrap = this.createClientBootstrap(factory2, bufferSize);
        this.dstAddress = new InetSocketAddress(host, port);
        this.dstAddressPrefixedName = this.prefixedName(this.dstAddress);
        this.scheduleConnect(0L);
        this.batcher = new MessageBuffer(messageBatchSize);
    }

    private ClientBootstrap createClientBootstrap(ChannelFactory factory2, int bufferSize) {
        ClientBootstrap bootstrap = new ClientBootstrap(factory2);
        bootstrap.setOption("tcpNoDelay", true);
        bootstrap.setOption("sendBufferSize", bufferSize);
        bootstrap.setOption("keepAlive", true);
        bootstrap.setPipelineFactory(new StormClientPipelineFactory(this));
        return bootstrap;
    }

    private String prefixedName(InetSocketAddress dstAddress) {
        if (null != dstAddress) {
            return PREFIX + dstAddress.toString();
        }
        return "";
    }

    private void scheduleConnect(long delayMs) {
        this.scheduler.newTimeout(new Connect(this.dstAddress), delayMs, TimeUnit.MILLISECONDS);
    }

    private boolean reconnectingAllowed() {
        return !this.closing;
    }

    private boolean connectionEstablished(Channel channel) {
        return channel != null && channel.isConnected();
    }

    @Override
    public ConnectionWithStatus.Status status() {
        if (this.closing) {
            return ConnectionWithStatus.Status.Closed;
        }
        if (!this.connectionEstablished(this.channelRef.get())) {
            return ConnectionWithStatus.Status.Connecting;
        }
        return ConnectionWithStatus.Status.Ready;
    }

    @Override
    public Iterator<TaskMessage> recv(int flags, int clientId) {
        throw new UnsupportedOperationException("Client connection should not receive any messages");
    }

    @Override
    public void send(int taskId, byte[] payload) {
        TaskMessage msg = new TaskMessage(taskId, payload);
        ArrayList<TaskMessage> wrapper = new ArrayList<TaskMessage>(1);
        wrapper.add(msg);
        this.send(wrapper.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Iterator<TaskMessage> msgs) {
        if (this.closing) {
            int numMessages = this.iteratorSize(msgs);
            LOG.error("discarding {} messages because the Netty client to {} is being closed", (Object)numMessages, (Object)this.dstAddressPrefixedName);
            return;
        }
        if (!this.hasMessages(msgs)) {
            return;
        }
        Channel channel = this.getConnectedChannel();
        if (channel == null) {
            this.dropMessages(msgs);
            return;
        }
        Object object = this.writeLock;
        synchronized (object) {
            while (msgs.hasNext()) {
                TaskMessage message = msgs.next();
                MessageBatch full = this.batcher.add(message);
                if (full == null) continue;
                this.flushMessages(channel, full);
            }
        }
        if (channel.isWritable()) {
            object = this.writeLock;
            synchronized (object) {
                MessageBatch batch = this.batcher.drain();
                if (batch != null) {
                    this.flushMessages(channel, batch);
                }
            }
        }
    }

    private Channel getConnectedChannel() {
        Channel channel = this.channelRef.get();
        if (this.connectionEstablished(channel)) {
            return channel;
        }
        boolean reconnectScheduled = this.closeChannelAndReconnect(channel);
        if (reconnectScheduled) {
            LOG.error("connection to {} is unavailable", (Object)this.dstAddressPrefixedName);
        }
        return null;
    }

    private boolean hasMessages(Iterator<TaskMessage> msgs) {
        return msgs != null && msgs.hasNext();
    }

    private void dropMessages(Iterator<TaskMessage> msgs) {
        int msgCount = this.iteratorSize(msgs);
        this.messagesLost.getAndAdd(msgCount);
    }

    private int iteratorSize(Iterator<TaskMessage> msgs) {
        int size = 0;
        if (msgs != null) {
            while (msgs.hasNext()) {
                ++size;
                msgs.next();
            }
        }
        return size;
    }

    private void flushMessages(Channel channel, final MessageBatch batch) {
        if (null == batch || batch.isEmpty()) {
            return;
        }
        final int numMessages = batch.size();
        LOG.debug("writing {} messages to channel {}", (Object)batch.size(), (Object)channel.toString());
        this.pendingMessages.addAndGet(numMessages);
        ChannelFuture future = channel.write(batch);
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                Client.this.pendingMessages.addAndGet(0 - numMessages);
                if (future.isSuccess()) {
                    LOG.debug("sent {} messages to {}", (Object)numMessages, (Object)Client.this.dstAddressPrefixedName);
                    Client.this.messagesSent.getAndAdd(batch.size());
                } else {
                    LOG.error("failed to send {} messages to {}: {}", new Object[]{numMessages, Client.this.dstAddressPrefixedName, future.getCause()});
                    Client.this.closeChannelAndReconnect(future.getChannel());
                    Client.this.messagesLost.getAndAdd(numMessages);
                }
            }
        });
    }

    private boolean closeChannelAndReconnect(Channel channel) {
        if (channel != null) {
            channel.close();
            if (this.channelRef.compareAndSet(channel, null)) {
                this.scheduleConnect(0L);
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (!this.closing) {
            LOG.info("closing Netty Client {}", (Object)this.dstAddressPrefixedName);
            this.context.removeClient(this.dstAddress.getHostName(), this.dstAddress.getPort());
            this.closing = true;
            this.waitForPendingMessagesToBeSent();
            this.closeChannel();
        }
    }

    private void waitForPendingMessagesToBeSent() {
        LOG.info("waiting up to {} ms to send {} pending messages to {}", new Object[]{600000L, this.pendingMessages.get(), this.dstAddressPrefixedName});
        long totalPendingMsgs = this.pendingMessages.get();
        long startMs = System.currentTimeMillis();
        while (this.pendingMessages.get() != 0L) {
            try {
                long deltaMs = System.currentTimeMillis() - startMs;
                if (deltaMs > 600000L) {
                    LOG.error("failed to send all pending messages to {} within timeout, {} of {} messages were not sent", new Object[]{this.dstAddressPrefixedName, this.pendingMessages.get(), totalPendingMsgs});
                    break;
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private void closeChannel() {
        Channel channel = this.channelRef.get();
        if (channel != null) {
            channel.close();
            LOG.debug("channel to {} closed", (Object)this.dstAddressPrefixedName);
        }
    }

    @Override
    public Object getState() {
        LOG.info("Getting metrics for client connection to {}", (Object)this.dstAddressPrefixedName);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("reconnects", this.totalConnectionAttempts.getAndSet(0));
        ret.put("sent", this.messagesSent.getAndSet(0));
        ret.put("pending", this.pendingMessages.get());
        ret.put("lostOnSend", this.messagesLost.getAndSet(0));
        ret.put("dest", this.dstAddress.toString());
        String src = this.srcAddressName();
        if (src != null) {
            ret.put("src", src);
        }
        return ret;
    }

    public Map getStormConf() {
        return this.stormConf;
    }

    private String srcAddressName() {
        SocketAddress address;
        String name = null;
        Channel channel = this.channelRef.get();
        if (channel != null && (address = channel.getLocalAddress()) != null) {
            name = address.toString();
        }
        return name;
    }

    public String toString() {
        return String.format("Netty client for connecting to %s", this.dstAddressPrefixedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInterestChanged(Channel channel) {
        if (channel.isWritable()) {
            Object object = this.writeLock;
            synchronized (object) {
                MessageBatch pending = this.batcher.drain();
                this.flushMessages(channel, pending);
            }
        }
    }

    private class Connect
    implements TimerTask {
        private final InetSocketAddress address;

        public Connect(InetSocketAddress address) {
            this.address = address;
        }

        private void reschedule(Throwable t) {
            String baseMsg = String.format("connection attempt %s to %s failed", Client.this.connectionAttempts, Client.this.dstAddressPrefixedName);
            String failureMsg = t == null ? baseMsg : baseMsg + ": " + t.toString();
            LOG.error(failureMsg);
            long nextDelayMs = Client.this.retryPolicy.getSleepTimeMs(Client.this.connectionAttempts.get(), 0L);
            Client.this.scheduleConnect(nextDelayMs);
        }

        @Override
        public void run(Timeout timeout) throws Exception {
            if (!Client.this.reconnectingAllowed()) {
                Client.this.close();
                throw new RuntimeException("Giving up to scheduleConnect to " + Client.this.dstAddressPrefixedName + " after " + Client.this.connectionAttempts + " failed attempts. " + Client.this.messagesLost.get() + " messages were lost");
            }
            final int connectionAttempt = Client.this.connectionAttempts.getAndIncrement();
            Client.this.totalConnectionAttempts.getAndIncrement();
            LOG.debug("connecting to {} [attempt {}]", (Object)this.address.toString(), (Object)connectionAttempt);
            ChannelFuture future = Client.this.bootstrap.connect(this.address);
            future.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    Channel newChannel = future.getChannel();
                    if (future.isSuccess() && Client.this.connectionEstablished(newChannel)) {
                        boolean setChannel = Client.this.channelRef.compareAndSet(null, newChannel);
                        Preconditions.checkState(setChannel);
                        LOG.debug("successfully connected to {}, {} [attempt {}]", new Object[]{Connect.this.address.toString(), newChannel.toString(), connectionAttempt});
                        if (Client.this.messagesLost.get() > 0) {
                            LOG.warn("Re-connection to {} was successful but {} messages has been lost so far", (Object)Connect.this.address.toString(), (Object)Client.this.messagesLost.get());
                        }
                    } else {
                        Throwable cause = future.getCause();
                        Connect.this.reschedule(cause);
                        if (newChannel != null) {
                            newChannel.close();
                        }
                    }
                }
            });
        }
    }
}

