/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.grouping;

import backtype.storm.generated.GlobalStreamId;
import backtype.storm.grouping.CustomStreamGrouping;
import backtype.storm.task.WorkerTopologyContext;
import backtype.storm.tuple.Fields;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.storm.shade.com.google.common.hash.HashFunction;
import org.apache.storm.shade.com.google.common.hash.Hashing;

public class PartialKeyGrouping
implements CustomStreamGrouping,
Serializable {
    private static final long serialVersionUID = -447379837314000353L;
    private List<Integer> targetTasks;
    private long[] targetTaskStats;
    private HashFunction h1 = Hashing.murmur3_128(13);
    private HashFunction h2 = Hashing.murmur3_128(17);
    private Fields fields = null;
    private Fields outFields = null;

    public PartialKeyGrouping() {
    }

    public PartialKeyGrouping(Fields fields2) {
        this.fields = fields2;
    }

    @Override
    public void prepare(WorkerTopologyContext context2, GlobalStreamId stream, List<Integer> targetTasks) {
        this.targetTasks = targetTasks;
        this.targetTaskStats = new long[this.targetTasks.size()];
        if (this.fields != null) {
            this.outFields = context2.getComponentOutputFields(stream);
        }
    }

    @Override
    public List<Integer> chooseTasks(int taskId, List<Object> values) {
        ArrayList<Integer> boltIds = new ArrayList<Integer>(1);
        if (values.size() > 0) {
            byte[] raw = null;
            if (this.fields != null) {
                List<Object> selectedFields = this.outFields.select(this.fields, values);
                ByteBuffer out = ByteBuffer.allocate(selectedFields.size() * 4);
                for (Object o : selectedFields) {
                    if (o instanceof List) {
                        out.putInt(Arrays.deepHashCode(((List)o).toArray()));
                        continue;
                    }
                    if (o instanceof Object[]) {
                        out.putInt(Arrays.deepHashCode((Object[])o));
                        continue;
                    }
                    if (o instanceof byte[]) {
                        out.putInt(Arrays.hashCode((byte[])o));
                        continue;
                    }
                    if (o instanceof short[]) {
                        out.putInt(Arrays.hashCode((short[])o));
                        continue;
                    }
                    if (o instanceof int[]) {
                        out.putInt(Arrays.hashCode((int[])o));
                        continue;
                    }
                    if (o instanceof long[]) {
                        out.putInt(Arrays.hashCode((long[])o));
                        continue;
                    }
                    if (o instanceof char[]) {
                        out.putInt(Arrays.hashCode((char[])o));
                        continue;
                    }
                    if (o instanceof float[]) {
                        out.putInt(Arrays.hashCode((float[])o));
                        continue;
                    }
                    if (o instanceof double[]) {
                        out.putInt(Arrays.hashCode((double[])o));
                        continue;
                    }
                    if (o instanceof boolean[]) {
                        out.putInt(Arrays.hashCode((boolean[])o));
                        continue;
                    }
                    if (o != null) {
                        out.putInt(o.hashCode());
                        continue;
                    }
                    out.putInt(0);
                }
                raw = out.array();
            } else {
                raw = values.get(0).toString().getBytes();
            }
            int firstChoice = (int)(Math.abs(this.h1.hashBytes(raw).asLong()) % (long)this.targetTasks.size());
            int secondChoice = (int)(Math.abs(this.h2.hashBytes(raw).asLong()) % (long)this.targetTasks.size());
            int selected = this.targetTaskStats[firstChoice] > this.targetTaskStats[secondChoice] ? secondChoice : firstChoice;
            boltIds.add(this.targetTasks.get(selected));
            int n = selected;
            this.targetTaskStats[n] = this.targetTaskStats[n] + 1L;
        }
        return boltIds;
    }
}

