/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.drpc;

import backtype.storm.task.TopologyContext;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseBasicBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.Map;
import java.util.Random;

public class PrepareRequest
extends BaseBasicBolt {
    public static final String ARGS_STREAM = "default";
    public static final String RETURN_STREAM = "ret";
    public static final String ID_STREAM = "id";
    Random rand;

    @Override
    public void prepare(Map map, TopologyContext context2) {
        this.rand = new Random();
    }

    @Override
    public void execute(Tuple tuple2, BasicOutputCollector collector) {
        String args = tuple2.getString(0);
        String returnInfo = tuple2.getString(1);
        long requestId = this.rand.nextLong();
        collector.emit(ARGS_STREAM, new Values(requestId, args));
        collector.emit(RETURN_STREAM, new Values(requestId, returnInfo));
        collector.emit(ID_STREAM, new Values(requestId));
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declareStream(ARGS_STREAM, new Fields("request", "args"));
        declarer.declareStream(RETURN_STREAM, new Fields("request", "return"));
        declarer.declareStream(ID_STREAM, new Fields("request"));
    }
}

