/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.drpc;

import backtype.storm.coordination.CoordinatedBolt;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.BasicBoltExecutor;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Tuple;
import backtype.storm.utils.KeyedRoundRobinQueue;
import java.util.HashMap;
import java.util.Map;

public class KeyedFairBolt
implements IRichBolt,
CoordinatedBolt.FinishedCallback {
    IRichBolt _delegate;
    KeyedRoundRobinQueue<Tuple> _rrQueue;
    Thread _executor;
    CoordinatedBolt.FinishedCallback _callback;

    public KeyedFairBolt(IRichBolt delegate) {
        this._delegate = delegate;
    }

    public KeyedFairBolt(IBasicBolt delegate) {
        this(new BasicBoltExecutor(delegate));
    }

    @Override
    public void prepare(Map stormConf, TopologyContext context2, OutputCollector collector) {
        if (this._delegate instanceof CoordinatedBolt.FinishedCallback) {
            this._callback = (CoordinatedBolt.FinishedCallback)((Object)this._delegate);
        }
        this._delegate.prepare(stormConf, context2, collector);
        this._rrQueue = new KeyedRoundRobinQueue();
        this._executor = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        KeyedFairBolt.this._delegate.execute(KeyedFairBolt.this._rrQueue.take());
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        this._executor.setDaemon(true);
        this._executor.start();
    }

    @Override
    public void execute(Tuple input) {
        Object key = input.getValue(0);
        this._rrQueue.add(key, input);
    }

    @Override
    public void cleanup() {
        this._executor.interrupt();
        this._delegate.cleanup();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this._delegate.declareOutputFields(declarer);
    }

    @Override
    public void finishedId(Object id) {
        if (this._callback != null) {
            this._callback.finishedId(id);
        }
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return new HashMap<String, Object>();
    }
}

