/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.drpc;

import backtype.storm.generated.AuthorizationException;
import backtype.storm.generated.DRPCRequest;
import backtype.storm.generated.DistributedRPCInvocations;
import backtype.storm.security.auth.ThriftClient;
import backtype.storm.security.auth.ThriftConnectionType;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.thrift7.TException;
import org.apache.thrift7.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRPCInvocationsClient
extends ThriftClient
implements DistributedRPCInvocations.Iface {
    public static Logger LOG = LoggerFactory.getLogger(DRPCInvocationsClient.class);
    private final AtomicReference<DistributedRPCInvocations.Client> client = new AtomicReference();
    private String host;
    private int port;

    public DRPCInvocationsClient(Map conf, String host, int port) throws TTransportException {
        super(conf, ThriftConnectionType.DRPC_INVOCATIONS, host, port, null);
        this.host = host;
        this.port = port;
        this.client.set(new DistributedRPCInvocations.Client(this._protocol));
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void reconnectClient() throws TException {
        if (this.client.get() == null) {
            this.reconnect();
            this.client.set(new DistributedRPCInvocations.Client(this._protocol));
        }
    }

    public boolean isConnected() {
        return this.client.get() != null;
    }

    @Override
    public void result(String id, String result2) throws TException, AuthorizationException {
        DistributedRPCInvocations.Client c = this.client.get();
        try {
            if (c == null) {
                throw new TException("Client is not connected...");
            }
            c.result(id, result2);
        }
        catch (AuthorizationException aze) {
            throw aze;
        }
        catch (TException e) {
            this.client.compareAndSet(c, null);
            throw e;
        }
    }

    @Override
    public DRPCRequest fetchRequest(String func) throws TException, AuthorizationException {
        DistributedRPCInvocations.Client c = this.client.get();
        try {
            if (c == null) {
                throw new TException("Client is not connected...");
            }
            return c.fetchRequest(func);
        }
        catch (AuthorizationException aze) {
            throw aze;
        }
        catch (TException e) {
            this.client.compareAndSet(c, null);
            throw e;
        }
    }

    @Override
    public void failRequest(String id) throws TException, AuthorizationException {
        DistributedRPCInvocations.Client c = this.client.get();
        try {
            if (c == null) {
                throw new TException("Client is not connected...");
            }
            c.failRequest(id);
        }
        catch (AuthorizationException aze) {
            throw aze;
        }
        catch (TException e) {
            this.client.compareAndSet(c, null);
            throw e;
        }
    }

    public DistributedRPCInvocations.Client getClient() {
        return this.client.get();
    }
}

