/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.coordination;

import backtype.storm.Constants;
import backtype.storm.generated.GlobalStreamId;
import backtype.storm.task.IOutputCollector;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.FailedException;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import backtype.storm.utils.TimeCacheMap;
import backtype.storm.utils.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatedBolt
implements IRichBolt {
    public static Logger LOG = LoggerFactory.getLogger(CoordinatedBolt.class);
    private Map<String, SourceArgs> _sourceArgs;
    private IdStreamSpec _idStreamSpec;
    private IRichBolt _delegate;
    private Integer _numSourceReports;
    private List<Integer> _countOutTasks = new ArrayList<Integer>();
    private OutputCollector _collector;
    private TimeCacheMap<Object, TrackingInfo> _tracked;

    public CoordinatedBolt(IRichBolt delegate) {
        this(delegate, null, null);
    }

    public CoordinatedBolt(IRichBolt delegate, String sourceComponent, SourceArgs sourceArgs, IdStreamSpec idStreamSpec) {
        this(delegate, CoordinatedBolt.singleSourceArgs(sourceComponent, sourceArgs), idStreamSpec);
    }

    public CoordinatedBolt(IRichBolt delegate, Map<String, SourceArgs> sourceArgs, IdStreamSpec idStreamSpec) {
        this._sourceArgs = sourceArgs;
        if (this._sourceArgs == null) {
            this._sourceArgs = new HashMap<String, SourceArgs>();
        }
        this._delegate = delegate;
        this._idStreamSpec = idStreamSpec;
    }

    @Override
    public void prepare(Map config2, TopologyContext context2, OutputCollector collector) {
        TimeoutItems callback = null;
        if (this._delegate instanceof TimeoutCallback) {
            callback = new TimeoutItems();
        }
        this._tracked = new TimeCacheMap<Object, TrackingInfo>(context2.maxTopologyMessageTimeout(), callback);
        this._collector = collector;
        this._delegate.prepare(config2, context2, new OutputCollector(new CoordinatedOutputCollector(collector)));
        for (String string : ((Map)Utils.get(context2.getThisTargets(), Constants.COORDINATED_STREAM_ID, new HashMap())).keySet()) {
            for (Integer task2 : context2.getComponentTasks(string)) {
                this._countOutTasks.add(task2);
            }
        }
        if (!this._sourceArgs.isEmpty()) {
            this._numSourceReports = 0;
            for (Map.Entry entry : this._sourceArgs.entrySet()) {
                if (((SourceArgs)entry.getValue()).singleCount) {
                    this._numSourceReports = this._numSourceReports + 1;
                    continue;
                }
                this._numSourceReports = this._numSourceReports + context2.getComponentTasks((String)entry.getKey()).size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFinishId(Tuple tup, TupleType type) {
        Object id = tup.getValue(0);
        boolean failed = false;
        TimeCacheMap<Object, TrackingInfo> timeCacheMap = this._tracked;
        synchronized (timeCacheMap) {
            TrackingInfo track2 = this._tracked.get(id);
            try {
                if (track2 != null) {
                    boolean delayed = false;
                    if (this._idStreamSpec == null && type == TupleType.COORD || this._idStreamSpec != null && type == TupleType.ID) {
                        track2.ackTuples.add(tup);
                        delayed = true;
                    }
                    if (track2.failed) {
                        failed = true;
                        for (Tuple t : track2.ackTuples) {
                            this._collector.fail(t);
                        }
                        this._tracked.remove(id);
                    } else if (track2.receivedId && (this._sourceArgs.isEmpty() || track2.reportCount == this._numSourceReports && track2.expectedTupleCount == track2.receivedTuples)) {
                        if (this._delegate instanceof FinishedCallback) {
                            ((FinishedCallback)((Object)this._delegate)).finishedId(id);
                        }
                        if (!this._sourceArgs.isEmpty() && type == TupleType.REGULAR) {
                            throw new IllegalStateException("Coordination condition met on a non-coordinating tuple. Should be impossible");
                        }
                        for (int task2 : this._countOutTasks) {
                            int numTuples = Utils.get(track2.taskEmittedTuples, task2, 0);
                            this._collector.emitDirect(task2, Constants.COORDINATED_STREAM_ID, tup, (List<Object>)new Values(id, numTuples));
                        }
                        for (Tuple t : track2.ackTuples) {
                            this._collector.ack(t);
                        }
                        track2.finished = true;
                        this._tracked.remove(id);
                    }
                    if (!delayed && type != TupleType.REGULAR) {
                        if (track2.failed) {
                            this._collector.fail(tup);
                        } else {
                            this._collector.ack(tup);
                        }
                    }
                } else if (type != TupleType.REGULAR) {
                    this._collector.fail(tup);
                }
            }
            catch (FailedException e) {
                LOG.error("Failed to finish batch", (Throwable)e);
                for (Tuple t : track2.ackTuples) {
                    this._collector.fail(t);
                }
                this._tracked.remove(id);
                failed = true;
            }
        }
        return failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Tuple tuple2) {
        TrackingInfo track2;
        Object id = tuple2.getValue(0);
        TupleType type = this.getTupleType(tuple2);
        TimeCacheMap<Object, TrackingInfo> timeCacheMap = this._tracked;
        synchronized (timeCacheMap) {
            track2 = this._tracked.get(id);
            if (track2 == null) {
                track2 = new TrackingInfo();
                if (this._idStreamSpec == null) {
                    track2.receivedId = true;
                }
                this._tracked.put(id, track2);
            }
        }
        if (type == TupleType.ID) {
            timeCacheMap = this._tracked;
            synchronized (timeCacheMap) {
                track2.receivedId = true;
            }
            this.checkFinishId(tuple2, type);
        } else if (type == TupleType.COORD) {
            int count = (Integer)tuple2.getValue(1);
            TimeCacheMap<Object, TrackingInfo> timeCacheMap2 = this._tracked;
            synchronized (timeCacheMap2) {
                ++track2.reportCount;
                track2.expectedTupleCount += count;
            }
            this.checkFinishId(tuple2, type);
        } else {
            timeCacheMap = this._tracked;
            synchronized (timeCacheMap) {
                this._delegate.execute(tuple2);
            }
        }
    }

    @Override
    public void cleanup() {
        this._delegate.cleanup();
        this._tracked.cleanup();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this._delegate.declareOutputFields(declarer);
        declarer.declareStream(Constants.COORDINATED_STREAM_ID, true, new Fields("id", "count"));
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this._delegate.getComponentConfiguration();
    }

    private static Map<String, SourceArgs> singleSourceArgs(String sourceComponent, SourceArgs sourceArgs) {
        HashMap<String, SourceArgs> ret = new HashMap<String, SourceArgs>();
        ret.put(sourceComponent, sourceArgs);
        return ret;
    }

    private TupleType getTupleType(Tuple tuple2) {
        if (this._idStreamSpec != null && tuple2.getSourceGlobalStreamid().equals(this._idStreamSpec._id)) {
            return TupleType.ID;
        }
        if (!this._sourceArgs.isEmpty() && tuple2.getSourceStreamId().equals(Constants.COORDINATED_STREAM_ID)) {
            return TupleType.COORD;
        }
        return TupleType.REGULAR;
    }

    static enum TupleType {
        REGULAR,
        ID,
        COORD;

    }

    private class TimeoutItems
    implements TimeCacheMap.ExpiredCallback<Object, TrackingInfo> {
        private TimeoutItems() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void expire(Object id, TrackingInfo val) {
            TimeCacheMap timeCacheMap = CoordinatedBolt.this._tracked;
            synchronized (timeCacheMap) {
                val.failed = true;
                if (!val.finished) {
                    ((TimeoutCallback)((Object)CoordinatedBolt.this._delegate)).timeoutId(id);
                }
            }
        }
    }

    public static class IdStreamSpec
    implements Serializable {
        GlobalStreamId _id;

        public GlobalStreamId getGlobalStreamId() {
            return this._id;
        }

        public static IdStreamSpec makeDetectSpec(String component, String stream) {
            return new IdStreamSpec(component, stream);
        }

        protected IdStreamSpec(String component, String stream) {
            this._id = new GlobalStreamId(component, stream);
        }
    }

    public static class TrackingInfo {
        int reportCount = 0;
        int expectedTupleCount = 0;
        int receivedTuples = 0;
        boolean failed = false;
        Map<Integer, Integer> taskEmittedTuples = new HashMap<Integer, Integer>();
        boolean receivedId = false;
        boolean finished = false;
        List<Tuple> ackTuples = new ArrayList<Tuple>();

        public String toString() {
            return "reportCount: " + this.reportCount + "\n" + "expectedTupleCount: " + this.expectedTupleCount + "\n" + "receivedTuples: " + this.receivedTuples + "\n" + "failed: " + this.failed + "\n" + this.taskEmittedTuples.toString();
        }
    }

    public class CoordinatedOutputCollector
    implements IOutputCollector {
        IOutputCollector _delegate;

        public CoordinatedOutputCollector(IOutputCollector delegate) {
            this._delegate = delegate;
        }

        @Override
        public List<Integer> emit(String stream, Collection<Tuple> anchors, List<Object> tuple2) {
            List<Integer> tasks = this._delegate.emit(stream, anchors, tuple2);
            this.updateTaskCounts(tuple2.get(0), tasks);
            return tasks;
        }

        @Override
        public void emitDirect(int task2, String stream, Collection<Tuple> anchors, List<Object> tuple2) {
            this.updateTaskCounts(tuple2.get(0), Arrays.asList(task2));
            this._delegate.emitDirect(task2, stream, anchors, tuple2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ack(Tuple tuple2) {
            Object id = tuple2.getValue(0);
            TimeCacheMap timeCacheMap = CoordinatedBolt.this._tracked;
            synchronized (timeCacheMap) {
                TrackingInfo track2 = (TrackingInfo)CoordinatedBolt.this._tracked.get(id);
                if (track2 != null) {
                    ++track2.receivedTuples;
                }
            }
            boolean failed = CoordinatedBolt.this.checkFinishId(tuple2, TupleType.REGULAR);
            if (failed) {
                this._delegate.fail(tuple2);
            } else {
                this._delegate.ack(tuple2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fail(Tuple tuple2) {
            Object id = tuple2.getValue(0);
            TimeCacheMap timeCacheMap = CoordinatedBolt.this._tracked;
            synchronized (timeCacheMap) {
                TrackingInfo track2 = (TrackingInfo)CoordinatedBolt.this._tracked.get(id);
                if (track2 != null) {
                    track2.failed = true;
                }
            }
            CoordinatedBolt.this.checkFinishId(tuple2, TupleType.REGULAR);
            this._delegate.fail(tuple2);
        }

        @Override
        public void reportError(Throwable error2) {
            this._delegate.reportError(error2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTaskCounts(Object id, List<Integer> tasks) {
            TimeCacheMap timeCacheMap = CoordinatedBolt.this._tracked;
            synchronized (timeCacheMap) {
                TrackingInfo track2 = (TrackingInfo)CoordinatedBolt.this._tracked.get(id);
                if (track2 != null) {
                    Map<Integer, Integer> taskEmittedTuples = track2.taskEmittedTuples;
                    for (Integer task2 : tasks) {
                        int newCount = Utils.get(taskEmittedTuples, task2, 0) + 1;
                        taskEmittedTuples.put(task2, newCount);
                    }
                }
            }
        }
    }

    public static class SourceArgs
    implements Serializable {
        public boolean singleCount;

        protected SourceArgs(boolean singleCount) {
            this.singleCount = singleCount;
        }

        public static SourceArgs single() {
            return new SourceArgs(true);
        }

        public static SourceArgs all() {
            return new SourceArgs(false);
        }

        public String toString() {
            return "<Single: " + this.singleCount + ">";
        }
    }

    public static interface TimeoutCallback {
        public void timeoutId(Object var1);
    }

    public static interface FinishedCallback {
        public void finishedId(Object var1);
    }
}

