/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.coordination;

import backtype.storm.coordination.BatchOutputCollectorImpl;
import backtype.storm.coordination.CoordinatedBolt;
import backtype.storm.coordination.IBatchBolt;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.FailedException;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Tuple;
import backtype.storm.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchBoltExecutor
implements IRichBolt,
CoordinatedBolt.FinishedCallback,
CoordinatedBolt.TimeoutCallback {
    public static Logger LOG = LoggerFactory.getLogger(BatchBoltExecutor.class);
    byte[] _boltSer;
    Map<Object, IBatchBolt> _openTransactions;
    Map _conf;
    TopologyContext _context;
    BatchOutputCollectorImpl _collector;

    public BatchBoltExecutor(IBatchBolt bolt2) {
        this._boltSer = Utils.javaSerialize(bolt2);
    }

    @Override
    public void prepare(Map conf, TopologyContext context2, OutputCollector collector) {
        this._conf = conf;
        this._context = context2;
        this._collector = new BatchOutputCollectorImpl(collector);
        this._openTransactions = new HashMap<Object, IBatchBolt>();
    }

    @Override
    public void execute(Tuple input) {
        Object id = input.getValue(0);
        IBatchBolt bolt2 = this.getBatchBolt(id);
        try {
            bolt2.execute(input);
            this._collector.ack(input);
        }
        catch (FailedException e) {
            LOG.error("Failed to process tuple in batch", (Throwable)e);
            this._collector.fail(input);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void finishedId(Object id) {
        IBatchBolt bolt2 = this.getBatchBolt(id);
        this._openTransactions.remove(id);
        bolt2.finishBatch();
    }

    @Override
    public void timeoutId(Object attempt) {
        this._openTransactions.remove(attempt);
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.newTransactionalBolt().declareOutputFields(declarer);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.newTransactionalBolt().getComponentConfiguration();
    }

    private IBatchBolt getBatchBolt(Object id) {
        IBatchBolt bolt2 = this._openTransactions.get(id);
        if (bolt2 == null) {
            bolt2 = this.newTransactionalBolt();
            bolt2.prepare(this._conf, this._context, this._collector, id);
            this._openTransactions.put(id, bolt2);
        }
        return bolt2;
    }

    private IBatchBolt newTransactionalBolt() {
        return Utils.javaDeserialize(this._boltSer, IBatchBolt.class);
    }
}

