/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm;

import backtype.storm.ILocalCluster;
import backtype.storm.generated.AlreadyAliveException;
import backtype.storm.generated.AuthorizationException;
import backtype.storm.generated.ClusterSummary;
import backtype.storm.generated.Credentials;
import backtype.storm.generated.InvalidTopologyException;
import backtype.storm.generated.NotAliveException;
import backtype.storm.generated.StormTopology;
import backtype.storm.generated.SubmitOptions;
import backtype.storm.generated.TopologyInitialStatus;
import backtype.storm.generated.TopologySummary;
import backtype.storm.security.auth.AuthUtils;
import backtype.storm.security.auth.IAutoCredentials;
import backtype.storm.utils.BufferFileInputStream;
import backtype.storm.utils.NimbusClient;
import backtype.storm.utils.Utils;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.storm.shade.org.apache.commons.lang.StringUtils;
import org.apache.storm.shade.org.json.simple.JSONValue;
import org.apache.thrift7.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormSubmitter {
    public static Logger LOG = LoggerFactory.getLogger(StormSubmitter.class);
    private static final int THRIFT_CHUNK_SIZE_BYTES = 307200;
    private static ILocalCluster localNimbus = null;
    public static final Pattern zkDigestPattern = Pattern.compile("\\S+:\\S+");

    public static void setLocalNimbus(ILocalCluster localNimbusHandler) {
        localNimbus = localNimbusHandler;
    }

    private static String generateZookeeperDigestSecretPayload() {
        return Utils.secureRandomLong() + ":" + Utils.secureRandomLong();
    }

    public static boolean validateZKDigestPayload(String payload) {
        if (payload != null) {
            Matcher m = zkDigestPattern.matcher(payload);
            return m.matches();
        }
        return false;
    }

    public static Map prepareZookeeperAuthentication(Map conf) {
        HashMap<String, String> toRet = new HashMap<String, String>();
        if (!conf.containsKey("storm.zookeeper.topology.auth.payload") || conf.get("storm.zookeeper.topology.auth.payload") == null || !StormSubmitter.validateZKDigestPayload((String)conf.get("storm.zookeeper.topology.auth.payload"))) {
            String secretPayload = StormSubmitter.generateZookeeperDigestSecretPayload();
            toRet.put("storm.zookeeper.topology.auth.payload", secretPayload);
            LOG.info("Generated ZooKeeper secret payload for MD5-digest: " + secretPayload);
        }
        toRet.put("storm.zookeeper.topology.auth.scheme", "digest");
        return toRet;
    }

    private static Map<String, String> populateCredentials(Map conf, Map<String, String> creds) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (IAutoCredentials autoCred : AuthUtils.GetAutoCredentials(conf)) {
            LOG.info("Running " + autoCred);
            autoCred.populateCredentials(ret);
        }
        if (creds != null) {
            ret.putAll(creds);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushCredentials(String name, Map stormConf, Map<String, String> credentials) throws AuthorizationException, NotAliveException, InvalidTopologyException {
        stormConf = new HashMap(stormConf);
        stormConf.putAll(Utils.readCommandLineOpts());
        Map conf = Utils.readStormConfig();
        conf.putAll(stormConf);
        Map<String, String> fullCreds = StormSubmitter.populateCredentials(conf, credentials);
        if (fullCreds.isEmpty()) {
            LOG.warn("No credentials were found to push to " + name);
            return;
        }
        try {
            if (localNimbus != null) {
                LOG.info("Pushing Credentials to topology " + name + " in local mode");
                localNimbus.uploadNewCredentials(name, new Credentials(fullCreds));
            } else {
                try (NimbusClient client = NimbusClient.getConfiguredClient(conf);){
                    LOG.info("Uploading new credentials to " + name);
                    client.getClient().uploadNewCredentials(name, new Credentials(fullCreds));
                }
            }
            LOG.info("Finished submitting topology: " + name);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    public static void submitTopology(String name, Map stormConf, StormTopology topology) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException {
        StormSubmitter.submitTopology(name, stormConf, topology, null, null);
    }

    public static void submitTopology(String name, Map stormConf, StormTopology topology, SubmitOptions opts) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException {
        StormSubmitter.submitTopology(name, stormConf, topology, opts, null);
    }

    public static void submitTopologyAs(String name, Map stormConf, StormTopology topology, SubmitOptions opts, ProgressListener progressListener, String asUser) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException {
        Map<String, String> fullCreds;
        Credentials tmpCreds;
        if (!Utils.isValidConf(stormConf)) {
            throw new IllegalArgumentException("Storm conf is not valid. Must be json-serializable");
        }
        stormConf = new HashMap(stormConf);
        stormConf.putAll(Utils.readCommandLineOpts());
        Map conf = Utils.readStormConfig();
        conf.putAll(stormConf);
        stormConf.putAll(StormSubmitter.prepareZookeeperAuthentication(conf));
        Map<String, String> passedCreds = new HashMap<String, String>();
        if (opts != null && (tmpCreds = opts.get_creds()) != null) {
            passedCreds = tmpCreds.get_creds();
        }
        if (!(fullCreds = StormSubmitter.populateCredentials(conf, passedCreds)).isEmpty()) {
            if (opts == null) {
                opts = new SubmitOptions(TopologyInitialStatus.ACTIVE);
            }
            opts.set_creds(new Credentials(fullCreds));
        }
        try {
            if (localNimbus != null) {
                LOG.info("Submitting topology " + name + " in local mode");
                if (opts != null) {
                    localNimbus.submitTopologyWithOpts(name, stormConf, topology, opts);
                } else {
                    localNimbus.submitTopology(name, stormConf, topology);
                }
            } else {
                String serConf = JSONValue.toJSONString(stormConf);
                NimbusClient client = NimbusClient.getConfiguredClientAs(conf, asUser);
                if (StormSubmitter.topologyNameExists(conf, name, asUser)) {
                    throw new RuntimeException("Topology with name `" + name + "` already exists on cluster");
                }
                String jar = StormSubmitter.submitJarAs(conf, System.getProperty("storm.jar"), progressListener, asUser);
                try {
                    LOG.info("Submitting topology " + name + " in distributed mode with conf " + serConf);
                    if (opts != null) {
                        client.getClient().submitTopologyWithOpts(name, jar, serConf, topology, opts);
                    } else {
                        client.getClient().submitTopology(name, jar, serConf, topology);
                    }
                }
                catch (InvalidTopologyException e) {
                    LOG.warn("Topology submission exception: " + e.get_msg());
                    throw e;
                }
                catch (AlreadyAliveException e) {
                    LOG.warn("Topology already alive exception", (Throwable)e);
                    throw e;
                }
                finally {
                    client.close();
                }
            }
            LOG.info("Finished submitting topology: " + name);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    public static void submitTopology(String name, Map stormConf, StormTopology topology, SubmitOptions opts, ProgressListener progressListener) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException {
        StormSubmitter.submitTopologyAs(name, stormConf, topology, opts, progressListener, null);
    }

    public static void submitTopologyWithProgressBar(String name, Map stormConf, StormTopology topology) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException {
        StormSubmitter.submitTopologyWithProgressBar(name, stormConf, topology, null);
    }

    public static void submitTopologyWithProgressBar(String name, Map stormConf, StormTopology topology, SubmitOptions opts) throws AlreadyAliveException, InvalidTopologyException, AuthorizationException {
        StormSubmitter.submitTopology(name, stormConf, topology, opts, new ProgressListener(){

            @Override
            public void onStart(String srcFile, String targetFile, long totalBytes) {
                System.out.printf("Start uploading file '%s' to '%s' (%d bytes)\n", srcFile, targetFile, totalBytes);
            }

            @Override
            public void onProgress(String srcFile, String targetFile, long bytesUploaded, long totalBytes) {
                int length = 50;
                int p = (int)((long)length * bytesUploaded / totalBytes);
                String progress = StringUtils.repeat("=", p);
                String todo = StringUtils.repeat(" ", length - p);
                System.out.printf("\r[%s%s] %d / %d", progress, todo, bytesUploaded, totalBytes);
            }

            @Override
            public void onCompleted(String srcFile, String targetFile, long totalBytes) {
                System.out.printf("\nFile '%s' uploaded to '%s' (%d bytes)\n", srcFile, targetFile, totalBytes);
            }
        });
    }

    private static boolean topologyNameExists(Map conf, String name, String asUser) {
        try (NimbusClient client = NimbusClient.getConfiguredClientAs(conf, asUser);){
            ClusterSummary summary = client.getClient().getClusterInfo();
            for (TopologySummary s : summary.get_topologies()) {
                if (!s.get_name().equals(name)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static String submitJar(Map conf, ProgressListener listener) {
        return StormSubmitter.submitJar(conf, System.getProperty("storm.jar"), listener);
    }

    public static String submitJar(Map conf, String localJar) {
        return StormSubmitter.submitJar(conf, localJar, null);
    }

    public static String submitJarAs(Map conf, String localJar, ProgressListener listener, String asUser) {
        if (localJar == null) {
            throw new RuntimeException("Must submit topologies using the 'storm' client script so that StormSubmitter knows which jar to upload.");
        }
        try (NimbusClient client = NimbusClient.getConfiguredClientAs(conf, asUser);){
            String uploadLocation = client.getClient().beginFileUpload();
            LOG.info("Uploading topology jar " + localJar + " to assigned location: " + uploadLocation);
            BufferFileInputStream is = new BufferFileInputStream(localJar, 307200);
            long totalSize = new File(localJar).length();
            if (listener != null) {
                listener.onStart(localJar, uploadLocation, totalSize);
            }
            long bytesUploaded = 0L;
            while (true) {
                byte[] toSubmit = is.read();
                bytesUploaded += (long)toSubmit.length;
                if (listener != null) {
                    listener.onProgress(localJar, uploadLocation, bytesUploaded, totalSize);
                }
                if (toSubmit.length == 0) break;
                client.getClient().uploadChunk(uploadLocation, ByteBuffer.wrap(toSubmit));
            }
            client.getClient().finishFileUpload(uploadLocation);
            if (listener != null) {
                listener.onCompleted(localJar, uploadLocation, totalSize);
            }
            LOG.info("Successfully uploaded topology jar to assigned location: " + uploadLocation);
            String string = uploadLocation;
            return string;
        }
    }

    public static String submitJar(Map conf, String localJar, ProgressListener listener) {
        return StormSubmitter.submitJarAs(conf, localJar, listener, null);
    }

    public static interface ProgressListener {
        public void onStart(String var1, String var2, long var3);

        public void onProgress(String var1, String var2, long var3, long var5);

        public void onCompleted(String var1, String var2, long var3);
    }
}

