/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.service.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.MediatorService;
import org.wso2.carbon.mediator.service.MediatorStore;
import org.wso2.carbon.mediator.service.builtin.CommentMediator;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public abstract class AbstractListMediator
extends AbstractMediator
implements ListMediator {
    protected List<Mediator> mediators = new ArrayList<Mediator>();

    @Override
    public List<Mediator> getList() {
        return this.mediators;
    }

    @Override
    public Mediator getChild(int pos) {
        return this.mediators.get(pos);
    }

    @Override
    public Mediator removeChild(int pos) {
        return this.mediators.remove(pos);
    }

    @Override
    public boolean removeChild(Mediator mediator) {
        return this.mediators.remove(mediator);
    }

    @Override
    public void addChild(Mediator mediator) {
        this.mediators.add(mediator);
    }

    protected void serializeChildren(OMElement parent, List<Mediator> list) {
        for (Mediator child : list) {
            child.serialize(parent);
        }
    }

    protected void addChildren(OMElement el, ListMediator m) {
        Iterator it = el.getChildren();
        while (it.hasNext()) {
            OMNode child = (OMNode)it.next();
            if (child instanceof OMElement) {
                MediatorService mediatorService = MediatorStore.getInstance().getMediatorService((OMElement)child);
                if (mediatorService == null) continue;
                Mediator med = mediatorService.getMediator();
                if (med != null) {
                    med.build((OMElement)child);
                    m.addChild(med);
                    continue;
                }
                String msg = "Unknown mediator : " + ((OMElement)child).getLocalName();
                throw new MediatorException(msg);
            }
            if (!(child instanceof OMComment)) continue;
            CommentMediator med = new CommentMediator();
            med.build((OMComment)child);
            m.addChild(med);
        }
    }
}

