/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.mediator.service.MediatorService;
import org.wso2.carbon.mediator.service.MediatorStore;

@Component(name="carbon.mediator.service", immediate=true)
public class MediatorListener {
    private static final Log log = LogFactory.getLog(MediatorListener.class);

    @Reference(name="mediator.service", service=MediatorService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="removeMediatorService")
    protected void addMediatorService(MediatorService mediatorService) {
        MediatorStore mediatorStore = MediatorStore.getInstance();
        mediatorStore.registerMediator(mediatorService.getTagLocalName(), mediatorService);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered the mediator for the tag name : " + mediatorService.getTagLocalName()));
        }
    }

    protected void removeMediatorService(MediatorService mediatorService) {
        MediatorStore mediatorStore = MediatorStore.getInstance();
        mediatorStore.unRegisterMediator(mediatorService.getTagLocalName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Un-Registered the mediator for the tag name : " + mediatorService.getTagLocalName()));
        }
    }
}

