/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.CertData;
import org.wso2.carbon.identity.application.common.model.CertificateInfo;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProviderProperty;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.ThreadLocalProvisioningServiceProvider;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class IdentityApplicationManagementUtil {
    private static final Log log = LogFactory.getLog(IdentityApplicationManagementUtil.class);
    private static ThreadLocal<ThreadLocalProvisioningServiceProvider> threadLocalProvisioningServiceProvider = new ThreadLocal();
    private static final Map<String, String> xmlSignatureAlgorithms;
    private static final Map<String, String> xmlDigestAlgorithms;
    private static final Map<String, String> xmlAssertionEncryptionAlgorithms;
    private static final Map<String, String> xmlKeyEncryptionAlgorithms;
    private static final Map<String, String> samlAuthnContextClasses;
    private static final List<String> samlAuthnContextComparisonLevels;
    private static HashMap<CertData, String> certificalteValMap;

    private IdentityApplicationManagementUtil() {
    }

    public static void resetThreadLocalProvisioningServiceProvider() {
        threadLocalProvisioningServiceProvider.remove();
    }

    public static ThreadLocalProvisioningServiceProvider getThreadLocalProvisioningServiceProvider() {
        return threadLocalProvisioningServiceProvider.get();
    }

    public static void setThreadLocalProvisioningServiceProvider(ThreadLocalProvisioningServiceProvider serviceProvider) {
        threadLocalProvisioningServiceProvider.set(serviceProvider);
    }

    public static boolean validateURI(String uriString) {
        if (uriString != null) {
            try {
                URL uRL = new URL(uriString);
            }
            catch (MalformedURLException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
                return false;
            }
        } else {
            String errorMsg = "Invalid URL: 'NULL'";
            log.debug((Object)errorMsg);
            return false;
        }
        return true;
    }

    public static void closeConnection(Connection dbConnection) {
        IdentityDatabaseUtil.closeConnection((Connection)dbConnection);
    }

    @Deprecated
    public static void rollBack(Connection dbConnection) {
        IdentityDatabaseUtil.rollBack((Connection)dbConnection);
    }

    public static ProvisioningConnectorConfig[] concatArrays(ProvisioningConnectorConfig[] o1, ProvisioningConnectorConfig[] o2) {
        ProvisioningConnectorConfig[] ret = new ProvisioningConnectorConfig[o1.length + o2.length];
        System.arraycopy(o1, 0, ret, 0, o1.length);
        System.arraycopy(o2, 0, ret, o1.length, o2.length);
        return ret;
    }

    public static Property[] concatArrays(Property[] o1, Property[] o2) {
        HashSet<Property> properties = new HashSet<Property>(Arrays.asList(IdentityApplicationManagementUtil.removeEmptyElements(o1)));
        properties.addAll(Arrays.asList(IdentityApplicationManagementUtil.removeEmptyElements(o2)));
        return properties.toArray(new Property[properties.size()]);
    }

    public static FederatedAuthenticatorConfig[] concatArrays(FederatedAuthenticatorConfig[] o1, FederatedAuthenticatorConfig[] o2) {
        FederatedAuthenticatorConfig[] ret = new FederatedAuthenticatorConfig[o1.length + o2.length];
        System.arraycopy(o1, 0, ret, 0, o1.length);
        System.arraycopy(o2, 0, ret, o1.length, o2.length);
        return ret;
    }

    public static String extractKeyStoreFileName(String filePath) {
        if (filePath != null) {
            String name = null;
            int index = filePath.lastIndexOf(47);
            name = index != -1 ? filePath.substring(index + 1) : ((index = filePath.lastIndexOf(File.separatorChar)) != -1 ? filePath.substring(filePath.lastIndexOf(File.separatorChar)) : filePath);
            return name;
        }
        String errorMsg = "Invalid file path: 'NULL'";
        log.debug((Object)errorMsg);
        throw new IllegalArgumentException(errorMsg);
    }

    public static String generateThumbPrint(String encodedCert) throws NoSuchAlgorithmException {
        if (encodedCert != null) {
            MessageDigest digestValue = null;
            digestValue = MessageDigest.getInstance("SHA-1");
            byte[] der = Base64.decode((String)encodedCert);
            digestValue.update(der);
            byte[] digestInBytes = digestValue.digest();
            String publicCertThumbprint = IdentityApplicationManagementUtil.hexify(digestInBytes);
            return publicCertThumbprint;
        }
        String errorMsg = "Invalid encoded certificate: 'NULL'";
        log.debug((Object)errorMsg);
        throw new IllegalArgumentException(errorMsg);
    }

    public static Certificate decodeCertificate(String encodedCert) throws CertificateException {
        if (encodedCert != null) {
            byte[] bytes = Base64.decode((String)encodedCert);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(bytes));
            return cert;
        }
        String errorMsg = "Invalid encoded certificate: 'NULL'";
        log.debug((Object)errorMsg);
        throw new IllegalArgumentException(errorMsg);
    }

    public static String extractCertificate(String decodedCertificate, int ordinal) {
        int numberOfCertificatesInCertificate = StringUtils.countMatches((String)decodedCertificate, (String)"-----BEGIN CERTIFICATE-----");
        String certificateVal = ordinal == numberOfCertificatesInCertificate ? decodedCertificate.substring(StringUtils.ordinalIndexOf((String)decodedCertificate, (String)"-----BEGIN CERTIFICATE-----", (int)ordinal)) : decodedCertificate.substring(StringUtils.ordinalIndexOf((String)decodedCertificate, (String)"-----BEGIN CERTIFICATE-----", (int)ordinal), StringUtils.ordinalIndexOf((String)decodedCertificate, (String)"-----BEGIN CERTIFICATE-----", (int)(ordinal + 1)));
        return certificateVal;
    }

    public static String hexify(byte[] bytes) {
        if (bytes != null) {
            char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            StringBuilder buf = new StringBuilder(bytes.length * 2);
            for (int i = 0; i < bytes.length; ++i) {
                buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
                buf.append(hexDigits[bytes[i] & 0xF]);
            }
            return buf.toString();
        }
        String errorMsg = "Invalid byte array: 'NULL'";
        log.debug((Object)errorMsg);
        throw new IllegalArgumentException(errorMsg);
    }

    public static CertData getCertData(String encodedCert) throws CertificateException {
        if (encodedCert != null) {
            return IdentityApplicationManagementUtil.createCertData(encodedCert);
        }
        String errorMsg = "Invalid encoded certificate: 'NULL'";
        log.debug((Object)errorMsg);
        throw new IllegalArgumentException(errorMsg);
    }

    public static List<CertData> getCertDataArray(CertificateInfo[] certificateInfo) throws CertificateException {
        if (ArrayUtils.isNotEmpty((Object[])certificateInfo)) {
            ArrayList<CertData> certDataList = new ArrayList<CertData>();
            HashMap<CertData, String> certDataMap = new HashMap<CertData, String>();
            int i = 0;
            for (CertificateInfo certificateInfoVal : certificateInfo) {
                String certVal = certificateInfoVal.getCertValue();
                CertData certData = IdentityApplicationManagementUtil.createCertData(certVal);
                certDataList.add(certData);
                certDataMap.put(certData, certVal);
                ++i;
            }
            IdentityApplicationManagementUtil.setCertDataMap(certDataMap);
            return certDataList;
        }
        String errorMsg = "Certificate info array is empty";
        if (log.isDebugEnabled()) {
            log.debug((Object)errorMsg);
        }
        throw new IllegalArgumentException(errorMsg);
    }

    private static CertData createCertData(String encodedCert) throws CertificateException {
        byte[] bytes = Base64.decode((String)encodedCert);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(bytes));
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        return IdentityApplicationManagementUtil.fillCertData(cert, formatter);
    }

    private static void setCertDataMap(HashMap<CertData, String> certDataMap) {
        certificalteValMap = certDataMap;
    }

    public static HashMap<CertData, String> getCertDataMap() {
        return certificalteValMap;
    }

    public static boolean exclusiveOR(boolean[] array) {
        boolean foundTrue = false;
        for (boolean temp : array) {
            if (!temp) continue;
            if (foundTrue) {
                return false;
            }
            foundTrue = true;
        }
        return foundTrue;
    }

    private static CertData fillCertData(X509Certificate cert, Format formatter) throws CertificateEncodingException {
        CertData certData = new CertData();
        certData.setSubjectDN(cert.getSubjectDN().getName());
        certData.setIssuerDN(cert.getIssuerDN().getName());
        certData.setSerialNumber(cert.getSerialNumber());
        certData.setVersion(cert.getVersion());
        certData.setNotAfter(formatter.format(cert.getNotAfter()));
        certData.setNotBefore(formatter.format(cert.getNotBefore()));
        certData.setPublicKey(Base64.encode((byte[])cert.getPublicKey().getEncoded()));
        return certData;
    }

    public static void closeResultSet(ResultSet rs) {
        IdentityDatabaseUtil.closeResultSet((ResultSet)rs);
    }

    public static void closeStatement(PreparedStatement preparedStatement) {
        IdentityDatabaseUtil.closeStatement((PreparedStatement)preparedStatement);
    }

    public static Properties readProperties(OMElement configElem) {
        Properties properties = new Properties();
        OMElement propsElem = configElem.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS("Properties"));
        if (propsElem != null) {
            Iterator propItr = propsElem.getChildrenWithLocalName("Property");
            while (propItr.hasNext()) {
                OMElement propElem = (OMElement)propItr.next();
                String propName = propElem.getAttributeValue(new QName("name")).trim();
                String propValue = propElem.getText().trim();
                properties.put(propName, propValue);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Property name : " + propName + ", Property Value : " + propValue));
            }
        }
        return properties;
    }

    public static QName getQNameWithIdentityApplicationNS(String localPart) {
        return new QName("http://wso2.org/projects/carbon/application-authentication.xml", localPart);
    }

    public static FederatedAuthenticatorConfig getFederatedAuthenticator(FederatedAuthenticatorConfig[] federatedAuthenticators, String authenticatorName) {
        if (ArrayUtils.isNotEmpty((Object[])federatedAuthenticators)) {
            for (FederatedAuthenticatorConfig authenticator : federatedAuthenticators) {
                if (authenticator == null || !authenticator.getName().equals(authenticatorName)) continue;
                return authenticator;
            }
        }
        return null;
    }

    public static ProvisioningConnectorConfig getProvisioningConnector(ProvisioningConnectorConfig[] provisioningConnectors, String connectorType) {
        for (ProvisioningConnectorConfig connector : provisioningConnectors) {
            if (!connector.getName().equals(connectorType)) continue;
            return connector;
        }
        return null;
    }

    public static Property getProperty(Property[] properties, String propertyName) {
        if (ArrayUtils.isEmpty((Object[])properties) || StringUtils.isBlank((String)propertyName)) {
            return null;
        }
        for (Property property : properties) {
            if (property == null || !propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public static IdentityProviderProperty getProperty(IdentityProviderProperty[] properties, String propertyName) {
        for (IdentityProviderProperty property : properties) {
            if (!property.getName().equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    public static String getSignedJWT(String jsonObj, ServiceProvider serviceProvider) {
        String oauthConsumerSecret = null;
        if (serviceProvider.getInboundAuthenticationConfig() != null && serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs() != null && serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs().length > 0) {
            InboundAuthenticationRequestConfig[] authReqConfigs;
            block2: for (InboundAuthenticationRequestConfig authReqConfig : authReqConfigs = serviceProvider.getInboundAuthenticationConfig().getInboundAuthenticationRequestConfigs()) {
                if (!"oauth2".equals(authReqConfig.getInboundAuthType()) || authReqConfig.getProperties() == null) continue;
                for (Property property : authReqConfig.getProperties()) {
                    if (!"oauthConsumerSecret".equalsIgnoreCase(property.getName())) continue;
                    oauthConsumerSecret = property.getValue();
                    continue block2;
                }
            }
        }
        String jwtBody = "{\"iss\":\"wso2\",\"exp\":" + new Date().getTime() + 3000 + ",\"iat\":" + new Date().getTime() + "," + jsonObj + "}";
        String jwtHeader = "{\"typ\":\"JWT\", \"alg\":\"HS256\"}";
        if (oauthConsumerSecret == null) {
            jwtHeader = "{\"typ\":\"JWT\", \"alg\":\"none\"}";
        }
        String base64EncodedHeader = Base64Utils.encode((byte[])jwtHeader.getBytes(StandardCharsets.UTF_8));
        String base64EncodedBody = Base64Utils.encode((byte[])jwtBody.getBytes(StandardCharsets.UTF_8));
        if (log.isDebugEnabled()) {
            log.debug((Object)("JWT Header :" + jwtHeader));
            log.debug((Object)("JWT Body :" + jwtBody));
        }
        String assertion = base64EncodedHeader + "." + base64EncodedBody;
        if (oauthConsumerSecret == null) {
            return assertion + ".";
        }
        try {
            String signedAssertion = IdentityApplicationManagementUtil.calculateHmacSha1(oauthConsumerSecret, assertion);
            return assertion + "." + signedAssertion;
        }
        catch (SignatureException e) {
            log.error((Object)"Error while signing the assertion", (Throwable)e);
            return assertion + ".";
        }
    }

    public static String calculateHmacSha1(String key, String value) throws SignatureException {
        String result;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(value.getBytes(StandardCharsets.UTF_8));
            result = Base64Utils.encode((byte[])rawHmac);
        }
        catch (NoSuchAlgorithmException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to create the HMAC Signature", (Throwable)e);
            }
            throw new SignatureException("Invalid algorithm provided while calculating HMAC signature.", e);
        }
        catch (InvalidKeyException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to create the HMAC Signature", (Throwable)e);
            }
            throw new SignatureException("Failed to calculate HMAC signature.", e);
        }
        return result;
    }

    public static Map<String, String> getXMLSignatureAlgorithms() {
        return xmlSignatureAlgorithms;
    }

    public static Map<String, String> getXMLDigestAlgorithms() {
        return xmlDigestAlgorithms;
    }

    public static Map<String, String> getXMLAssertionEncryptionAlgorithms() {
        return xmlAssertionEncryptionAlgorithms;
    }

    public static Map<String, String> getXMLKeyEncryptionAlgorithms() {
        return xmlKeyEncryptionAlgorithms;
    }

    public static Map<String, String> getSAMLAuthnContextClasses() {
        return samlAuthnContextClasses;
    }

    public static List<String> getSAMLAuthnContextComparisonLevels() {
        return samlAuthnContextComparisonLevels;
    }

    public static Set<String> getXMLSignatureAlgorithmNames() {
        return xmlSignatureAlgorithms.keySet();
    }

    public static Set<String> getXMLDigestAlgorithmNames() {
        return xmlDigestAlgorithms.keySet();
    }

    public static Set<String> getSAMLAuthnContextClassNames() {
        return samlAuthnContextClasses.keySet();
    }

    public static String getSigningAlgoURIByConfig() {
        if (StringUtils.isNotBlank((String)IdentityUtil.getProperty((String)"SSOService.SAMLDefaultSigningAlgorithmURI"))) {
            return IdentityUtil.getProperty((String)"SSOService.SAMLDefaultSigningAlgorithmURI").trim();
        }
        return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    }

    public static String getDigestAlgoURIByConfig() {
        if (StringUtils.isNotBlank((String)IdentityUtil.getProperty((String)"SSOService.SAMLDefaultDigestAlgorithmURI"))) {
            return IdentityUtil.getProperty((String)"SSOService.SAMLDefaultDigestAlgorithmURI").trim();
        }
        return "http://www.w3.org/2000/09/xmldsig#sha1";
    }

    public static String getAssertionEncryptionAlgorithmURIByConfig() {
        if (StringUtils.isNotBlank((String)IdentityUtil.getProperty((String)"SSOService.SAMLDefaultAssertionEncryptionAlgorithmURI"))) {
            return IdentityUtil.getProperty((String)"SSOService.SAMLDefaultAssertionEncryptionAlgorithmURI").trim();
        }
        return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    }

    public static String getKeyEncryptionAlgorithmURIByConfig() {
        if (StringUtils.isNotBlank((String)IdentityUtil.getProperty((String)"SSOService.SAMLDefaultKeyEncryptionAlgorithmURI"))) {
            return IdentityUtil.getProperty((String)"SSOService.SAMLDefaultKeyEncryptionAlgorithmURI").trim();
        }
        return "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    }

    public static List<String> getPropertyValuesForNameStartsWith(FederatedAuthenticatorConfig[] authnConfigs, String authenticatorName, String propNameStartsWith) {
        ArrayList<String> propValueSet = new ArrayList<String>();
        for (FederatedAuthenticatorConfig config : authnConfigs) {
            if (!authenticatorName.equals(config.getName())) continue;
            for (Property prop : config.getProperties()) {
                if (!prop.getName().startsWith(propNameStartsWith)) continue;
                propValueSet.add(prop.getValue());
            }
        }
        return propValueSet;
    }

    public static String getPropertyValue(Property[] properties, String propertyName) {
        Property property = IdentityApplicationManagementUtil.getProperty(properties, propertyName);
        if (property != null && StringUtils.isNotBlank((String)property.getValue())) {
            return property.getValue();
        }
        return null;
    }

    private static Property[] removeEmptyElements(Property[] properties) {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        if (ArrayUtils.isNotEmpty((Object[])properties)) {
            for (Property property : properties) {
                if (property == null || !StringUtils.isNotBlank((String)property.getName())) continue;
                propertyList.add(property);
            }
        }
        return propertyList.toArray(new Property[0]);
    }

    static {
        certificalteValMap = new HashMap();
        LinkedHashMap<String, String> xmlSignatureAlgorithmMap = new LinkedHashMap<String, String>();
        xmlSignatureAlgorithmMap.put("DSA with SHA1", "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        xmlSignatureAlgorithmMap.put("ECDSA with SHA1", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1");
        xmlSignatureAlgorithmMap.put("ECDSA with SHA256", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256");
        xmlSignatureAlgorithmMap.put("ECDSA with SHA384", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384");
        xmlSignatureAlgorithmMap.put("ECDSA with SHA512", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512");
        xmlSignatureAlgorithmMap.put("RSA with MD5", "http://www.w3.org/2001/04/xmldsig-more#rsa-md5");
        xmlSignatureAlgorithmMap.put("RSA with RIPEMD160", "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160");
        xmlSignatureAlgorithmMap.put("RSA with SHA1", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        xmlSignatureAlgorithmMap.put("RSA with SHA256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        xmlSignatureAlgorithmMap.put("RSA with SHA384", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384");
        xmlSignatureAlgorithmMap.put("RSA with SHA512", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        xmlSignatureAlgorithms = Collections.unmodifiableMap(xmlSignatureAlgorithmMap);
        LinkedHashMap<String, String> xmlDigestAlgorithmMap = new LinkedHashMap<String, String>();
        xmlDigestAlgorithmMap.put("MD5", "http://www.w3.org/2001/04/xmldsig-more#md5");
        xmlDigestAlgorithmMap.put("RIPEMD160", "http://www.w3.org/2001/04/xmlenc#ripemd160");
        xmlDigestAlgorithmMap.put("SHA1", "http://www.w3.org/2000/09/xmldsig#sha1");
        xmlDigestAlgorithmMap.put("SHA256", "http://www.w3.org/2001/04/xmlenc#sha256");
        xmlDigestAlgorithmMap.put("SHA384", "http://www.w3.org/2001/04/xmldsig-more#sha384");
        xmlDigestAlgorithmMap.put("SHA512", "http://www.w3.org/2001/04/xmlenc#sha512");
        xmlDigestAlgorithms = Collections.unmodifiableMap(xmlDigestAlgorithmMap);
        LinkedHashMap<String, String> xmlAssertionEncryptionAlgorithmMap = new LinkedHashMap<String, String>();
        xmlAssertionEncryptionAlgorithmMap.put("AES256", "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        xmlAssertionEncryptionAlgorithmMap.put("AES192", "http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        xmlAssertionEncryptionAlgorithmMap.put("AES128", "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        xmlAssertionEncryptionAlgorithmMap.put("TRIPLEDES", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        xmlAssertionEncryptionAlgorithmMap.put("AES128_GCM", "http://www.w3.org/2009/xmlenc11#aes128-gcm");
        xmlAssertionEncryptionAlgorithmMap.put("AES192_GCM", "http://www.w3.org/2009/xmlenc11#aes192-gcm");
        xmlAssertionEncryptionAlgorithmMap.put("AES256_GCM", "http://www.w3.org/2009/xmlenc11#aes256-gcm");
        xmlAssertionEncryptionAlgorithms = Collections.unmodifiableMap(xmlAssertionEncryptionAlgorithmMap);
        LinkedHashMap<String, String> xmlKeyEncryptionAlgorithmMap = new LinkedHashMap<String, String>();
        xmlKeyEncryptionAlgorithmMap.put("RSAOAEP", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        xmlKeyEncryptionAlgorithmMap.put("RSA15", "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        xmlKeyEncryptionAlgorithmMap.put("RSAOAEP11", "http://www.w3.org/2009/xmlenc11#rsa-oaep");
        xmlKeyEncryptionAlgorithms = Collections.unmodifiableMap(xmlKeyEncryptionAlgorithmMap);
        LinkedHashMap<String, String> samlAuthnContextClassMap = new LinkedHashMap<String, String>();
        samlAuthnContextClassMap.put("Internet Protocol", "urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocol");
        samlAuthnContextClassMap.put("Internet Protocol Password", "urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocolPassword");
        samlAuthnContextClassMap.put("Kerberos", "urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
        samlAuthnContextClassMap.put("Mobile One Factor Unregistered", "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileOneFactorUnregistered");
        samlAuthnContextClassMap.put("Mobile Two Factor Unregistered", "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorUnregistered");
        samlAuthnContextClassMap.put("Mobile One Factor Contract", "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileOneFactorContract");
        samlAuthnContextClassMap.put("Mobile Two Factor Contract", "urn:oasis:names:tc:SAML:2.0:ac:classes:MobileTwoFactorContract");
        samlAuthnContextClassMap.put("Password", "urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        samlAuthnContextClassMap.put("Password Protected Transport", "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        samlAuthnContextClassMap.put("Previous Session", "urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
        samlAuthnContextClassMap.put("Public Key - X.509", "urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
        samlAuthnContextClassMap.put("Public Key - PGP", "urn:oasis:names:tc:SAML:2.0:ac:classes:PGP");
        samlAuthnContextClassMap.put("Public Key - SPKI", "urn:oasis:names:tc:SAML:2.0:ac:classes:SPKI");
        samlAuthnContextClassMap.put("Public Key - XML Digital Signature", "urn:oasis:names:tc:SAML:2.0:ac:classes:XMLDSig");
        samlAuthnContextClassMap.put("Smartcard", "urn:oasis:names:tc:SAML:2.0:ac:classes:Smartcard");
        samlAuthnContextClassMap.put("Smartcard PKI", "urn:oasis:names:tc:SAML:2.0:ac:classes:SmartcardPKI");
        samlAuthnContextClassMap.put("Software PKI", "urn:oasis:names:tc:SAML:2.0:ac:classes:SoftwarePKI");
        samlAuthnContextClassMap.put("Telephony", "urn:oasis:names:tc:SAML:2.0:ac:classes:Telephony");
        samlAuthnContextClassMap.put("Telephony (Nomadic)", "urn:oasis:names:tc:SAML:2.0:ac:classes:NomadTelephony");
        samlAuthnContextClassMap.put("Telephony (Personalized)", "urn:oasis:names:tc:SAML:2.0:ac:classes:PersonalTelephony");
        samlAuthnContextClassMap.put("Telephony (Authenticated)", "urn:oasis:names:tc:SAML:2.0:ac:classes:AuthenticatedTelephony");
        samlAuthnContextClassMap.put("Secure Remote Password", "urn:oasis:names:tc:SAML:2.0:ac:classes:SecureRemotePassword");
        samlAuthnContextClassMap.put("SSL/TLS Certificate-Based Client Authentication", "urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient");
        samlAuthnContextClassMap.put("Time Sync Token", "urn:oasis:names:tc:SAML:2.0:ac:classes:TimeSyncToken");
        samlAuthnContextClassMap.put("Unspecified", "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
        samlAuthnContextClasses = Collections.unmodifiableMap(samlAuthnContextClassMap);
        ArrayList<String> samlAuthnContextComparisonLevelList = new ArrayList<String>();
        samlAuthnContextComparisonLevelList.add("Exact");
        samlAuthnContextComparisonLevelList.add("Minimum");
        samlAuthnContextComparisonLevelList.add("Maximum");
        samlAuthnContextComparisonLevelList.add("Better");
        samlAuthnContextComparisonLevels = Collections.unmodifiableList(samlAuthnContextComparisonLevelList);
    }
}

