/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.processors;

import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.cache.RandomPasswordContainerCache;
import org.wso2.carbon.identity.application.common.cache.RandomPasswordContainerCacheEntry;
import org.wso2.carbon.identity.application.common.cache.RandomPasswordContainerCacheKey;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.RandomPassword;
import org.wso2.carbon.identity.application.common.model.RandomPasswordContainer;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;

public class RandomPasswordProcessor {
    private static final Log log = LogFactory.getLog(RandomPasswordProcessor.class);
    private static volatile RandomPasswordProcessor randomPasswordProcessor = null;

    private RandomPasswordProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RandomPasswordProcessor getInstance() {
        if (randomPasswordProcessor != null) return randomPasswordProcessor;
        Class<RandomPassword> clazz = RandomPassword.class;
        synchronized (RandomPassword.class) {
            if (randomPasswordProcessor != null) return randomPasswordProcessor;
            randomPasswordProcessor = new RandomPasswordProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return randomPasswordProcessor;
        }
    }

    public Property[] removeOriginalPasswords(Property[] properties) {
        if (ArrayUtils.isEmpty((Object[])properties)) {
            return new Property[0];
        }
        properties = this.addUniqueIdProperty(properties);
        String uuid = IdentityApplicationManagementUtil.getPropertyValue(properties, "UniqueID");
        String randomPhrase = "random-password-generated!@#$%^&*(0)+_" + uuid;
        Object[] randomPasswords = this.replaceOriginalPasswordsWithRandomPasswords(randomPhrase, properties);
        if (!ArrayUtils.isEmpty((Object[])randomPasswords)) {
            this.addPasswordContainerToCache((RandomPassword[])randomPasswords, uuid);
        }
        return properties;
    }

    public Property[] removeRandomPasswords(Property[] properties, boolean withCacheClear) {
        if (ArrayUtils.isEmpty((Object[])properties)) {
            return new Property[0];
        }
        String uuid = IdentityApplicationManagementUtil.getPropertyValue(properties, "UniqueID");
        if (StringUtils.isBlank((String)uuid)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cache Key not found for Random Password Container");
            }
        } else {
            properties = this.removeUniqueIdProperty(properties);
            Object[] randomPasswords = this.getRandomPasswordContainerFromCache(uuid, withCacheClear);
            if (!ArrayUtils.isEmpty((Object[])randomPasswords)) {
                this.replaceRandomPasswordsWithOriginalPasswords(properties, (RandomPassword[])randomPasswords);
            }
        }
        return properties;
    }

    private void addPasswordContainerToCache(RandomPassword[] randomPasswords, String uuid) {
        if (randomPasswords == null && log.isDebugEnabled()) {
            log.debug((Object)"Random passwords not available for Password Container");
        }
        RandomPasswordContainer randomPasswordContainer = new RandomPasswordContainer();
        randomPasswordContainer.setRandomPasswords(randomPasswords);
        randomPasswordContainer.setUniqueID(uuid);
        RandomPasswordContainerCacheKey cacheKey = new RandomPasswordContainerCacheKey(uuid);
        RandomPasswordContainerCacheEntry cacheEntry = new RandomPasswordContainerCacheEntry(randomPasswordContainer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Random passwords to Cache with Key: " + uuid));
        }
        RandomPasswordContainerCache.getInstance().addToCache(cacheKey, cacheEntry);
    }

    private RandomPassword[] getRandomPasswordContainerFromCache(String uuid, boolean withCacheClear) {
        RandomPasswordContainerCacheKey cacheKey = new RandomPasswordContainerCacheKey(uuid);
        RandomPasswordContainerCache cache = RandomPasswordContainerCache.getInstance();
        RandomPasswordContainerCacheEntry cacheEntry = cache.getValueFromCache(cacheKey);
        if (cacheEntry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache entry not found for cache key :" + uuid));
            }
            return new RandomPassword[0];
        }
        RandomPasswordContainer randomPasswordContainer = cacheEntry.getRandomPasswordContainer();
        if (randomPasswordContainer == null || randomPasswordContainer.getRandomPasswords() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Could not find Random Passwords from Random Password Container");
            }
            return new RandomPassword[0];
        }
        if (withCacheClear) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing Cache Entry with Key: " + uuid));
            }
            cache.clearCacheEntry(cacheKey);
        }
        return randomPasswordContainer.getRandomPasswords();
    }

    private RandomPassword[] replaceOriginalPasswordsWithRandomPasswords(String randomPhrase, Property[] properties) {
        ArrayList<RandomPassword> randomPasswordArrayList = new ArrayList<RandomPassword>();
        if (properties != null) {
            for (Property property : properties) {
                if (property == null || property.getName() == null || property.getValue() == null || !property.getName().contains("password")) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found Password Property :" + property.getValue()));
                }
                RandomPassword randomPassword = new RandomPassword();
                randomPassword.setPropertyName(property.getName());
                randomPassword.setPassword(property.getValue());
                randomPassword.setRandomPhrase(randomPhrase);
                randomPasswordArrayList.add(randomPassword);
                property.setValue(randomPhrase);
            }
        }
        return randomPasswordArrayList.toArray(new RandomPassword[randomPasswordArrayList.size()]);
    }

    private void replaceRandomPasswordsWithOriginalPasswords(Property[] properties, RandomPassword[] randomPasswords) {
        if (ArrayUtils.isEmpty((Object[])properties) || ArrayUtils.isEmpty((Object[])randomPasswords)) {
            return;
        }
        for (Property property : properties) {
            if (property == null || StringUtils.isBlank((String)property.getName()) || StringUtils.isBlank((String)property.getValue()) || !property.getName().contains("password")) continue;
            for (RandomPassword randomPassword : randomPasswords) {
                if (!property.getName().equals(randomPassword.getPropertyName()) || !property.getValue().equals(randomPassword.getRandomPhrase())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User didn't changed password property: " + property.getName() + " hence replace Random Password with Original Password"));
                }
                property.setValue(randomPassword.getPassword());
            }
        }
    }

    private Property[] addUniqueIdProperty(Property[] properties) {
        if (ArrayUtils.isEmpty((Object[])properties)) {
            return new Property[0];
        }
        String uuid = UUID.randomUUID().toString();
        Property uniqueIdProperty = new Property();
        uniqueIdProperty.setName("UniqueID");
        uniqueIdProperty.setValue(uuid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding uniqueId property: " + uuid));
        }
        properties = (Property[])ArrayUtils.add((Object[])properties, (Object)uniqueIdProperty);
        return properties;
    }

    private Property[] removeUniqueIdProperty(Property[] properties) {
        if (ArrayUtils.isEmpty((Object[])properties)) {
            return new Property[0];
        }
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i] == null || !"UniqueID".equals(properties[i].getName())) continue;
            Property[] propertiesTemp = properties;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing uniqueId property: " + properties[i].getName()));
            }
            properties = (Property[])ArrayUtils.removeElement((Object[])properties, (Object)properties[i]);
            propertiesTemp[i] = null;
        }
        return properties;
    }
}

