/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class User
implements Serializable {
    private static final long serialVersionUID = 928301275168169633L;
    protected String tenantDomain;
    protected String userStoreDomain;
    protected String userName;
    protected boolean isUsernameCaseSensitive = true;

    public static User build(OMElement userOM) {
        User user = new User();
        if (userOM == null) {
            return user;
        }
        Iterator iter = userOM.getChildElements();
        while (iter.hasNext()) {
            OMElement member = (OMElement)iter.next();
            if ("TenantDomain".equals(member.getLocalName())) {
                if (member.getText() == null) continue;
                user.setTenantDomain(member.getText());
                continue;
            }
            if ("UserStoreDomain".equalsIgnoreCase(member.getLocalName())) {
                user.setUserStoreDomain(member.getText());
                continue;
            }
            if (!"UserName".equalsIgnoreCase(member.getLocalName())) continue;
            user.setUserName(member.getText());
        }
        return user;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
        this.updateCaseSensitivity();
    }

    public String getUserStoreDomain() {
        return this.userStoreDomain;
    }

    public void setUserStoreDomain(String userStoreDomain) {
        this.userStoreDomain = userStoreDomain.toUpperCase(Locale.ENGLISH);
        this.updateCaseSensitivity();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        if (!this.tenantDomain.equals(user.tenantDomain)) {
            return false;
        }
        boolean isUsernameCaseSensitive = IdentityUtil.isUserStoreCaseSensitive((String)this.userStoreDomain, (int)IdentityTenantUtil.getTenantId((String)this.tenantDomain));
        if (isUsernameCaseSensitive ? !this.userName.equals(user.userName) : !this.userName.equalsIgnoreCase(user.userName)) {
            return false;
        }
        return this.userStoreDomain.equals(user.userStoreDomain);
    }

    public static User getUserFromUserName(String username) {
        User user = new User();
        if (StringUtils.isNotBlank((String)username)) {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
            String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)username);
            String tenantAwareUsernameWithNoUserDomain = UserCoreUtil.removeDomainFromName((String)tenantAwareUsername);
            String userStoreDomain = IdentityUtil.extractDomainFromName((String)username).toUpperCase(Locale.ENGLISH);
            user.setUserName(tenantAwareUsernameWithNoUserDomain);
            if (StringUtils.isNotEmpty((String)tenantDomain)) {
                user.setTenantDomain(tenantDomain);
            } else {
                user.setTenantDomain("carbon.super");
            }
            if (StringUtils.isNotEmpty((String)userStoreDomain)) {
                user.setUserStoreDomain(userStoreDomain);
            } else {
                user.setUserStoreDomain("PRIMARY");
            }
        }
        return user;
    }

    public String toFullQualifiedUsername() {
        String username = null;
        if (StringUtils.isNotBlank((String)this.userName)) {
            username = this.userName;
            if (StringUtils.isNotBlank((String)this.tenantDomain)) {
                username = UserCoreUtil.addTenantDomainToEntry((String)username, (String)this.tenantDomain);
            }
            if (StringUtils.isNotBlank((String)this.userStoreDomain)) {
                username = IdentityUtil.addDomainToName((String)username, (String)this.userStoreDomain);
            }
        }
        return username;
    }

    protected void updateCaseSensitivity() {
        if (StringUtils.isNotEmpty((String)this.tenantDomain) && StringUtils.isNotEmpty((String)this.userStoreDomain) && IdentityTenantUtil.getRealmService() != null) {
            this.isUsernameCaseSensitive = IdentityUtil.isUserStoreCaseSensitive((String)this.userStoreDomain, (int)IdentityTenantUtil.getTenantId((String)this.tenantDomain));
        }
    }

    public int hashCode() {
        int result = this.tenantDomain.hashCode();
        result = 31 * result + this.userStoreDomain.hashCode();
        result = this.isUsernameCaseSensitive ? 31 * result + this.userName.hashCode() : 31 * result + this.userName.toLowerCase().hashCode();
        return result;
    }

    public String toString() {
        String username = null;
        if (StringUtils.isNotBlank((String)this.userName)) {
            username = this.userName;
            if (StringUtils.isNotBlank((String)this.userStoreDomain)) {
                username = UserCoreUtil.addDomainToName((String)username, (String)this.userStoreDomain);
            }
            if (StringUtils.isNotBlank((String)this.tenantDomain)) {
                username = UserCoreUtil.addTenantDomainToEntry((String)username, (String)this.tenantDomain);
            }
        }
        return username;
    }
}

