/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="SubProperty")
public class SubProperty
implements Serializable {
    private static final long serialVersionUID = 2423059979331364604L;
    @XmlElement(name="Name")
    private String name;
    @XmlElement(name="Value")
    private String value;
    @XmlElement(name="IsConfidential")
    private boolean isConfidential;
    @XmlElement(name="DefaultValue")
    private String defaultValue;
    @XmlElement(name="DisplayName")
    private String displayName;
    @XmlElement(name="Required")
    private boolean required;
    @XmlElement(name="DefaultValue")
    private String description;
    @XmlElement(name="Type")
    private String type;
    @XmlElement(name="DisplayOrder")
    private int displayOrder;
    @XmlElement(name="IsAdvanced")
    private boolean isAdvanced;
    @XmlElement(name="Regex")
    private String regex;
    @XmlElementWrapper(name="Options")
    @XmlElement(name="Option")
    private String[] options = new String[0];

    public static SubProperty build(OMElement propertyOM) {
        if (propertyOM == null) {
            return null;
        }
        SubProperty property = new SubProperty();
        Iterator iter = propertyOM.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if ("Name".equals(elementName)) {
                property.setName(element.getText());
                continue;
            }
            if ("Value".equals(elementName)) {
                property.setValue(element.getText());
                continue;
            }
            if ("IsConfidential".equals(elementName)) {
                if (element.getText() == null || element.getText().trim().length() <= 0) continue;
                property.setConfidential(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if ("defaultValue".equals(elementName)) {
                property.setDefaultValue(element.getText());
                continue;
            }
            if ("DisplayName".equals(elementName)) {
                property.setDisplayName(element.getText());
                continue;
            }
            if ("Required".equals(elementName)) {
                if (element.getText() == null || element.getText().trim().length() <= 0) continue;
                property.setRequired(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if ("Description".equals(elementName)) {
                property.setDescription(element.getText());
                continue;
            }
            if ("DisplayOrder".equals(elementName)) {
                property.setDisplayOrder(Integer.parseInt(element.getText()));
                continue;
            }
            if ("Type".equals(elementName)) {
                property.setType(element.getText());
                continue;
            }
            if ("IsAdvanced".equals(elementName)) {
                if (element.getText() == null || element.getText().trim().length() <= 0) continue;
                property.setAdvanced(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if ("Regex".equals(elementName)) {
                if (element.getText() == null || element.getText().trim().length() <= 0) continue;
                property.setRegex(element.getText());
                continue;
            }
            if (!"Options".equals(elementName)) continue;
            Iterator optionsIter = element.getChildElements();
            ArrayList<String> optionsArrList = new ArrayList<String>();
            while (optionsIter.hasNext()) {
                OMElement optionsElement = (OMElement)optionsIter.next();
                if (optionsElement.getText() == null) continue;
                optionsArrList.add(optionsElement.getText());
            }
            if (!CollectionUtils.isNotEmpty(optionsArrList)) continue;
            String[] optionsArr = optionsArrList.toArray(new String[0]);
            property.setOptions(optionsArr);
        }
        return property;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isConfidential() {
        return this.isConfidential;
    }

    public void setConfidential(boolean isConfidential) {
        this.isConfidential = isConfidential;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    public void setAdvanced(boolean isAdvanced) {
        this.isAdvanced = isAdvanced;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void setOptions(String[] options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubProperty)) {
            return false;
        }
        SubProperty property = (SubProperty)o;
        return (this.name != null ? this.name.equals(property.name) : property.name == null) && (this.value != null ? this.value.equals(property.value) : property.value == null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

