/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.databinding.annotation.IgnoreNullElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.InboundProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.LocalAndOutboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.OutboundProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.RequestPathAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProviderProperty;
import org.wso2.carbon.identity.application.common.model.User;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="ServiceProvider")
public class ServiceProvider
implements Serializable {
    private static final long serialVersionUID = 4754526832588478582L;
    private static final Log log = LogFactory.getLog(ServiceProvider.class);
    private static final String CONSENT_CONFIG_ELEM = "ConsentConfig";
    private static final String ACCESS_URL = "AccessUrl";
    private static final String IMAGE_URL = "ImageUrl";
    private static final String TEMPLATE_ID = "TemplateId";
    @XmlTransient
    private int applicationID = 0;
    @XmlElement(name="ApplicationName")
    private String applicationName;
    @XmlElement(name="Description")
    private String description;
    @XmlElement(name="Certificate")
    private String certificateContent;
    @XmlElement(name="JwksUri")
    private String jwksUri;
    @XmlTransient
    private User owner;
    @XmlElement(name="InboundAuthenticationConfig")
    private InboundAuthenticationConfig inboundAuthenticationConfig;
    @XmlElement(name="LocalAndOutBoundAuthenticationConfig")
    private LocalAndOutboundAuthenticationConfig localAndOutBoundAuthenticationConfig;
    @XmlElementWrapper(name="RequestPathAuthenticatorConfigs")
    @XmlElement(name="RequestPathAuthenticatorConfig")
    private RequestPathAuthenticatorConfig[] requestPathAuthenticatorConfigs;
    @XmlElement(name="InboundProvisioningConfig")
    private InboundProvisioningConfig inboundProvisioningConfig;
    @XmlElement(name="OutboundProvisioningConfig")
    private OutboundProvisioningConfig outboundProvisioningConfig;
    @XmlElement(name="ClaimConfig")
    private ClaimConfig claimConfig;
    @XmlElement(name="PermissionAndRoleConfig")
    private PermissionsAndRoleConfig permissionAndRoleConfig;
    @XmlElement(name="IsSaaSApp")
    private boolean saasApp;
    @XmlTransient
    private ServiceProviderProperty[] spProperties = new ServiceProviderProperty[0];
    @IgnoreNullElement
    @XmlTransient
    private String applicationResourceId;
    @IgnoreNullElement
    @XmlElement(name="ImageUrl")
    private String imageUrl;
    @IgnoreNullElement
    @XmlElement(name="AccessUrl")
    private String accessUrl;
    @XmlElement(name="IsDiscoverable")
    private boolean isDiscoverable;
    @IgnoreNullElement
    @XmlElement(name="TemplateId")
    private String templateId;

    public static ServiceProvider build(OMElement serviceProviderOM) {
        ServiceProvider serviceProvider = new ServiceProvider();
        serviceProvider.setSaasApp(true);
        Iterator iter = serviceProviderOM.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if ("ApplicationID".equals(elementName)) {
                if (element.getText() == null) continue;
                serviceProvider.setApplicationID(Integer.parseInt(element.getText()));
                continue;
            }
            if ("ApplicationName".equals(elementName)) {
                if (element.getText() != null) {
                    serviceProvider.setApplicationName(element.getText());
                    continue;
                }
                log.error((Object)"Service provider not loaded from the file. Application Name is null.");
                return null;
            }
            if ("Description".equals(elementName)) {
                serviceProvider.setDescription(element.getText());
                continue;
            }
            if (IMAGE_URL.equals(elementName)) {
                serviceProvider.setImageUrl(element.getText());
                continue;
            }
            if (ACCESS_URL.equals(elementName)) {
                serviceProvider.setAccessUrl(element.getText());
                continue;
            }
            if (TEMPLATE_ID.equals(elementName)) {
                serviceProvider.setTemplateId(element.getText());
                continue;
            }
            if ("Certificate".equals(elementName)) {
                serviceProvider.setCertificateContent(element.getText());
                continue;
            }
            if ("JwksUri".equals(elementName)) {
                serviceProvider.setJwksUri(element.getText());
                continue;
            }
            if ("IsSaaSApp".equals(elementName)) {
                if (element.getText() != null && "true".equals(element.getText())) {
                    serviceProvider.setSaasApp(true);
                    continue;
                }
                serviceProvider.setSaasApp(false);
                continue;
            }
            if ("Owner".equals(elementName)) {
                serviceProvider.setOwner(User.build(element));
                continue;
            }
            if ("InboundAuthenticationConfig".equals(elementName)) {
                serviceProvider.setInboundAuthenticationConfig(InboundAuthenticationConfig.build(element));
                continue;
            }
            if ("LocalAndOutBoundAuthenticationConfig".equals(elementName)) {
                serviceProvider.setLocalAndOutBoundAuthenticationConfig(LocalAndOutboundAuthenticationConfig.build(element));
                continue;
            }
            if ("RequestPathAuthenticatorConfigs".equals(elementName)) {
                Iterator requestPathAuthenticatorConfigsIter = element.getChildElements();
                if (requestPathAuthenticatorConfigsIter == null) continue;
                ArrayList<RequestPathAuthenticatorConfig> requestPathAuthenticatorConfigsArrList = new ArrayList<RequestPathAuthenticatorConfig>();
                while (requestPathAuthenticatorConfigsIter.hasNext()) {
                    OMElement requestPathAuthenticatorConfigsElement = (OMElement)requestPathAuthenticatorConfigsIter.next();
                    RequestPathAuthenticatorConfig reqConfig = RequestPathAuthenticatorConfig.build(requestPathAuthenticatorConfigsElement);
                    if (reqConfig == null) continue;
                    requestPathAuthenticatorConfigsArrList.add(reqConfig);
                }
                if (!CollectionUtils.isNotEmpty(requestPathAuthenticatorConfigsArrList)) continue;
                RequestPathAuthenticatorConfig[] requestPathAuthenticatorConfigsArr = requestPathAuthenticatorConfigsArrList.toArray(new RequestPathAuthenticatorConfig[0]);
                serviceProvider.setRequestPathAuthenticatorConfigs(requestPathAuthenticatorConfigsArr);
                continue;
            }
            if ("InboundProvisioningConfig".equals(elementName)) {
                serviceProvider.setInboundProvisioningConfig(InboundProvisioningConfig.build(element));
                continue;
            }
            if ("OutboundProvisioningConfig".equals(elementName)) {
                serviceProvider.setOutboundProvisioningConfig(OutboundProvisioningConfig.build(element));
                continue;
            }
            if ("ClaimConfig".equals(elementName)) {
                serviceProvider.setClaimConfig(ClaimConfig.build(element));
                continue;
            }
            if (!"PermissionAndRoleConfig".equals(elementName)) continue;
            serviceProvider.setPermissionAndRoleConfig(PermissionsAndRoleConfig.build(element));
        }
        return serviceProvider;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public void setApplicationID(int applicationID) {
        this.applicationID = applicationID;
    }

    public InboundAuthenticationConfig getInboundAuthenticationConfig() {
        return this.inboundAuthenticationConfig;
    }

    public void setInboundAuthenticationConfig(InboundAuthenticationConfig inboundAuthenticationConfig) {
        this.inboundAuthenticationConfig = inboundAuthenticationConfig;
    }

    public LocalAndOutboundAuthenticationConfig getLocalAndOutBoundAuthenticationConfig() {
        return this.localAndOutBoundAuthenticationConfig;
    }

    public void setLocalAndOutBoundAuthenticationConfig(LocalAndOutboundAuthenticationConfig localAndOutBoundAuthenticationConfig) {
        this.localAndOutBoundAuthenticationConfig = localAndOutBoundAuthenticationConfig;
    }

    public RequestPathAuthenticatorConfig[] getRequestPathAuthenticatorConfigs() {
        return this.requestPathAuthenticatorConfigs;
    }

    public void setRequestPathAuthenticatorConfigs(RequestPathAuthenticatorConfig[] requestPathAuthenticatorConfigs) {
        this.requestPathAuthenticatorConfigs = requestPathAuthenticatorConfigs;
    }

    public InboundProvisioningConfig getInboundProvisioningConfig() {
        return this.inboundProvisioningConfig;
    }

    public void setInboundProvisioningConfig(InboundProvisioningConfig inboundProvisioningConfig) {
        this.inboundProvisioningConfig = inboundProvisioningConfig;
    }

    public OutboundProvisioningConfig getOutboundProvisioningConfig() {
        return this.outboundProvisioningConfig;
    }

    public void setOutboundProvisioningConfig(OutboundProvisioningConfig outboundProvisioningConfig) {
        this.outboundProvisioningConfig = outboundProvisioningConfig;
    }

    public ClaimConfig getClaimConfig() {
        return this.claimConfig;
    }

    public void setClaimConfig(ClaimConfig claimConfig) {
        this.claimConfig = claimConfig;
    }

    public PermissionsAndRoleConfig getPermissionAndRoleConfig() {
        return this.permissionAndRoleConfig;
    }

    public void setPermissionAndRoleConfig(PermissionsAndRoleConfig permissionAndRoleConfig) {
        this.permissionAndRoleConfig = permissionAndRoleConfig;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isSaasApp() {
        return this.saasApp;
    }

    public void setSaasApp(boolean saasApp) {
        this.saasApp = saasApp;
    }

    public ServiceProviderProperty[] getSpProperties() {
        return this.spProperties;
    }

    public void setSpProperties(ServiceProviderProperty[] spProperties) {
        this.spProperties = spProperties;
    }

    public String getCertificateContent() {
        return this.certificateContent;
    }

    public void setCertificateContent(String certificateContent) {
        this.certificateContent = certificateContent;
    }

    public String getApplicationResourceId() {
        return this.applicationResourceId;
    }

    public void setApplicationResourceId(String applicationResourceId) {
        this.applicationResourceId = applicationResourceId;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getAccessUrl() {
        return this.accessUrl;
    }

    public void setAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public boolean isDiscoverable() {
        return this.isDiscoverable;
    }

    public void setDiscoverable(boolean discoverable) {
        this.isDiscoverable = discoverable;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }
}

