/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;

public class SAML2SSOFederatedAuthenticatorConfig
extends FederatedAuthenticatorConfig {
    private static final long serialVersionUID = -171672098979315832L;
    private String idpEntityId;
    private boolean isLogoutEnabled;
    private boolean isSLORequestAccepted;
    private String saml2SSOUrl;
    private boolean isLogoutRequestSigned;
    private String logoutRequestUrl;
    private String spEntityId;
    private boolean isAuthnRequestSigned;
    private boolean isAuthnResponseSigned;
    private boolean isAuthnResponseEncrypted;
    private boolean isUserIdInClaims;
    private boolean isArtifactBindingEnabled;
    private boolean isArtifactResolveReqSigned;
    private boolean isArtifactResponseSigned;
    private String artifactResolveUrl;

    public SAML2SSOFederatedAuthenticatorConfig(FederatedAuthenticatorConfig federatedAuthenticatorConfig) {
        block32: for (Property property : federatedAuthenticatorConfig.getProperties()) {
            switch (property.getName()) {
                case "IdPEntityId": {
                    this.idpEntityId = property.getValue();
                    continue block32;
                }
                case "SPEntityId": {
                    this.spEntityId = property.getValue();
                    continue block32;
                }
                case "SSOUrl": {
                    this.saml2SSOUrl = property.getValue();
                    continue block32;
                }
                case "ISAuthnReqSigned": {
                    this.isAuthnRequestSigned = Boolean.parseBoolean(property.getValue());
                    continue block32;
                }
                case "IsLogoutEnabled": {
                    this.isLogoutEnabled = Boolean.parseBoolean(property.getValue());
                    continue block32;
                }
                case "IsLogoutReqSigned": {
                    this.isLogoutRequestSigned = Boolean.parseBoolean(property.getValue());
                    continue block32;
                }
                case "LogoutReqUrl": {
                    this.logoutRequestUrl = property.getValue();
                    continue block32;
                }
                case "IsSLORequestAccepted": {
                    this.isSLORequestAccepted = Boolean.parseBoolean(property.getValue());
                    continue block32;
                }
                case "IsAuthnRespSigned": {
                    this.isAuthnResponseSigned = Boolean.parseBoolean(property.getValue());
                    continue block32;
                }
                case "IsAssertionEncrypted": {
                    this.isAuthnResponseEncrypted = Boolean.parseBoolean(property.getValue());
                    continue block32;
                }
                case "ISArtifactBindingEnabled": {
                    this.isArtifactBindingEnabled = Boolean.parseBoolean(property.getValue());
                    continue block32;
                }
                case "ISArtifactResolveReqSigned": {
                    this.isArtifactResolveReqSigned = Boolean.parseBoolean(property.getValue());
                    continue block32;
                }
                case "ISArtifactResponseSigned": {
                    this.isArtifactResponseSigned = Boolean.parseBoolean(property.getValue());
                    continue block32;
                }
                case "ArtifactResolveUrl": {
                    this.artifactResolveUrl = property.getValue();
                }
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.isValidPropertyValue(IdentityApplicationManagementUtil.getProperty(this.properties, "IdPEntityId")) && this.isValidPropertyValue(IdentityApplicationManagementUtil.getProperty(this.properties, "SPEntityId")) && this.isValidPropertyValue(IdentityApplicationManagementUtil.getProperty(this.properties, "SSOUrl"));
    }

    @Override
    public String getName() {
        return "samlsso";
    }

    public String getIdpEntityId() {
        return this.idpEntityId;
    }

    public boolean isLogoutEnabled() {
        return this.isLogoutEnabled;
    }

    public boolean isSLORequestAccepted() {
        return this.isSLORequestAccepted;
    }

    public boolean isLogoutRequestSigned() {
        return this.isLogoutRequestSigned;
    }

    public String getLogoutRequestUrl() {
        return this.logoutRequestUrl;
    }

    public String getSpEntityId() {
        return this.spEntityId;
    }

    public boolean isAuthnRequestSigned() {
        return this.isAuthnRequestSigned;
    }

    public boolean isAuthnResponseSigned() {
        return this.isAuthnResponseSigned;
    }

    public boolean isUserIdInClaims() {
        return this.isUserIdInClaims;
    }

    public String getSaml2SSOUrl() {
        return this.saml2SSOUrl;
    }

    public boolean isAuthnResponseEncrypted() {
        return this.isAuthnResponseEncrypted;
    }

    public boolean isArtifactBindingEnabled() {
        return this.isArtifactBindingEnabled;
    }

    public boolean isArtifactResolveReqSigned() {
        return this.isArtifactResolveReqSigned;
    }

    public boolean isArtifactResponseSigned() {
        return this.isArtifactResponseSigned;
    }

    public String getArtifactResolveUrl() {
        return this.artifactResolveUrl;
    }
}

