/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.identity.application.common.model.LocalRole;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="RoleMapping")
public class RoleMapping
implements Serializable {
    private static final long serialVersionUID = 4838992846277456900L;
    @XmlElement(name="localRole")
    private LocalRole localRole = null;
    @XmlElement(name="remoteRole")
    private String remoteRole = null;

    public RoleMapping() {
    }

    public RoleMapping(LocalRole localRole, String remoteRole) {
        this.localRole = localRole;
        this.remoteRole = remoteRole;
    }

    public static RoleMapping build(OMElement roleMappingOM) {
        RoleMapping roleMapping = new RoleMapping();
        Iterator iter = roleMappingOM.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if ("localRole".equals(elementName)) {
                roleMapping.setLocalRole(LocalRole.build(element));
            }
            if (!"remoteRole".equals(elementName)) continue;
            roleMapping.setRemoteRole(element.getText());
        }
        return roleMapping;
    }

    public String getRemoteRole() {
        return this.remoteRole;
    }

    public void setRemoteRole(String remoteRole) {
        this.remoteRole = remoteRole;
    }

    public LocalRole getLocalRole() {
        return this.localRole;
    }

    public void setLocalRole(LocalRole localRole) {
        this.localRole = localRole;
    }
}

