/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;
import org.wso2.carbon.identity.application.common.model.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="RequestPathAuthenticatorConfig")
public class RequestPathAuthenticatorConfig
extends LocalAuthenticatorConfig {
    private static final long serialVersionUID = -753652473009612026L;

    public static RequestPathAuthenticatorConfig build(OMElement requestPathAuthenticatorConfigOM) {
        RequestPathAuthenticatorConfig requestPathAuthenticatorConfig = new RequestPathAuthenticatorConfig();
        Iterator members = requestPathAuthenticatorConfigOM.getChildElements();
        while (members.hasNext()) {
            OMElement member = (OMElement)members.next();
            if ("Name".equals(member.getLocalName())) {
                requestPathAuthenticatorConfig.setName(member.getText());
                continue;
            }
            if ("DisplayName".equals(member.getLocalName())) {
                requestPathAuthenticatorConfig.setDisplayName(member.getText());
                continue;
            }
            if ("IsEnabled".equals(member.getLocalName())) {
                requestPathAuthenticatorConfig.setEnabled(Boolean.parseBoolean(member.getText()));
                continue;
            }
            if (!"Properties".equals(member.getLocalName())) continue;
            Iterator propertiesIter = member.getChildElements();
            ArrayList<Property> propertiesArrList = new ArrayList<Property>();
            if (propertiesIter != null) {
                while (propertiesIter.hasNext()) {
                    OMElement propertiesElement = (OMElement)propertiesIter.next();
                    Property prop = Property.build(propertiesElement);
                    propertiesArrList.add(prop);
                }
            }
            if (!CollectionUtils.isNotEmpty(propertiesArrList)) continue;
            Property[] propertiesArr = propertiesArrList.toArray(new Property[0]);
            requestPathAuthenticatorConfig.setProperties(propertiesArr);
        }
        return requestPathAuthenticatorConfig;
    }
}

