/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;

public class ProvisioningConnectorConfig
implements Serializable {
    private static final long serialVersionUID = -4569973060498183209L;
    protected Property[] provisioningProperties = new Property[0];
    protected String name;
    protected boolean enabled;
    protected boolean blocking;
    protected boolean rulesEnabled;

    public static ProvisioningConnectorConfig build(OMElement provisioningConnectorConfigOM) throws IdentityApplicationManagementException {
        ProvisioningConnectorConfig provisioningConnectorConfig = new ProvisioningConnectorConfig();
        Iterator iter = provisioningConnectorConfigOM.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if ("ProvisioningProperties".equals(elementName)) {
                Iterator propertiesIter = element.getChildElements();
                ArrayList<Property> propertiesArrList = new ArrayList<Property>();
                if (propertiesIter != null) {
                    while (propertiesIter.hasNext()) {
                        OMElement propertiesElement = (OMElement)propertiesIter.next();
                        propertiesArrList.add(Property.build(propertiesElement));
                    }
                }
                if (!CollectionUtils.isNotEmpty(propertiesArrList)) continue;
                Property[] propertiesArr = propertiesArrList.toArray(new Property[0]);
                provisioningConnectorConfig.setProvisioningProperties(propertiesArr);
                continue;
            }
            if ("Name".equals(elementName)) {
                provisioningConnectorConfig.setName(element.getText());
                continue;
            }
            if ("IsEnabled".equals(elementName)) {
                provisioningConnectorConfig.setEnabled(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if ("IsBlocking".equals(elementName)) {
                provisioningConnectorConfig.setBlocking(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if (!"IsRulesEnabled".equals(elementName)) continue;
            provisioningConnectorConfig.setRulesEnabled(Boolean.parseBoolean(element.getText()));
        }
        if (StringUtils.isBlank((String)provisioningConnectorConfig.getName())) {
            throw new IdentityApplicationManagementException("No configured name found for ProvisioningConnectorConfig");
        }
        return provisioningConnectorConfig;
    }

    public Property[] getProvisioningProperties() {
        return this.provisioningProperties;
    }

    public void setProvisioningProperties(Property[] provisioningProperties) {
        this.provisioningProperties = this.provisioningProperties != null && this.provisioningProperties.length > 0 && provisioningProperties != null ? IdentityApplicationManagementUtil.concatArrays(this.provisioningProperties, provisioningProperties) : provisioningProperties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isValid() {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public boolean isRulesEnabled() {
        return this.rulesEnabled;
    }

    public void setRulesEnabled(boolean rulesEnabled) {
        this.rulesEnabled = rulesEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProvisioningConnectorConfig)) {
            return false;
        }
        ProvisioningConnectorConfig that = (ProvisioningConnectorConfig)o;
        if (!StringUtils.equals((String)this.name, (String)that.name)) {
            return false;
        }
        return Arrays.equals(this.provisioningProperties, that.provisioningProperties);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 17 + (this.name != null ? this.name.hashCode() : 0);
        hashCode = hashCode * 31 + (this.provisioningProperties != null ? Arrays.hashCode(this.provisioningProperties) : 0);
        return hashCode;
    }
}

