/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;
import org.wso2.carbon.identity.application.common.model.ApplicationPermission;
import org.wso2.carbon.identity.application.common.model.RoleMapping;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="PermissionsAndRoleConfig")
public class PermissionsAndRoleConfig
implements Serializable {
    private static final long serialVersionUID = 784509684062361809L;
    @XmlElementWrapper(name="Permissions")
    @XmlElement(name="ApplicationPermission")
    private ApplicationPermission[] permissions = new ApplicationPermission[0];
    @XmlElementWrapper(name="RoleMappings")
    @XmlElement(name="RoleMapping")
    private RoleMapping[] roleMappings = new RoleMapping[0];
    @XmlElementWrapper(name="IdpRoles")
    @XmlElement(name="IdpRole")
    private String[] idpRoles = new String[0];

    public static PermissionsAndRoleConfig build(OMElement permissionsAndRoleConfigOM) {
        PermissionsAndRoleConfig permissionsAndRoleConfig = new PermissionsAndRoleConfig();
        if (permissionsAndRoleConfigOM == null) {
            return permissionsAndRoleConfig;
        }
        Iterator iter = permissionsAndRoleConfigOM.getChildElements();
        while (iter.hasNext()) {
            ArrayList<Object> roleMappingsArrList;
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if ("Permissions".equals(elementName)) {
                Iterator permissionsIter = element.getChildElements();
                ArrayList<ApplicationPermission> permissionsArrList = new ArrayList<ApplicationPermission>();
                if (permissionsIter != null) {
                    while (permissionsIter.hasNext()) {
                        OMElement permissionsElement = (OMElement)permissionsIter.next();
                        ApplicationPermission appPermission = ApplicationPermission.build(permissionsElement);
                        if (appPermission == null) continue;
                        permissionsArrList.add(appPermission);
                    }
                }
                if (CollectionUtils.isNotEmpty(permissionsArrList)) {
                    ApplicationPermission[] permissionsArr = permissionsArrList.toArray(new ApplicationPermission[0]);
                    permissionsAndRoleConfig.setPermissions(permissionsArr);
                }
            }
            if ("RoleMappings".equals(elementName)) {
                Iterator roleMappingsIter = element.getChildElements();
                roleMappingsArrList = new ArrayList<Object>();
                if (roleMappingsIter != null) {
                    while (roleMappingsIter.hasNext()) {
                        OMElement roleMappingsElement = (OMElement)roleMappingsIter.next();
                        RoleMapping roleMapping = RoleMapping.build(roleMappingsElement);
                        if (roleMapping == null) continue;
                        roleMappingsArrList.add(roleMapping);
                    }
                }
                if (CollectionUtils.isNotEmpty(roleMappingsArrList)) {
                    RoleMapping[] roleMappingsArr = roleMappingsArrList.toArray(new RoleMapping[0]);
                    permissionsAndRoleConfig.setRoleMappings(roleMappingsArr);
                }
            }
            if (!"IdpRoles".equals(elementName)) continue;
            Iterator idpRolesIter = element.getChildElements();
            roleMappingsArrList = new ArrayList();
            while (idpRolesIter.hasNext()) {
                OMElement idpRolesElement = (OMElement)idpRolesIter.next();
                if (idpRolesElement.getText() == null) continue;
                roleMappingsArrList.add(idpRolesElement.getText());
            }
            if (!CollectionUtils.isNotEmpty(roleMappingsArrList)) continue;
            String[] idpRolesArr = roleMappingsArrList.toArray(new String[0]);
            permissionsAndRoleConfig.setIdpRoles(idpRolesArr);
        }
        return permissionsAndRoleConfig;
    }

    public ApplicationPermission[] getPermissions() {
        return this.permissions;
    }

    public void setPermissions(ApplicationPermission[] permissions) {
        this.permissions = permissions;
    }

    public RoleMapping[] getRoleMappings() {
        return this.roleMappings;
    }

    public void setRoleMappings(RoleMapping[] roleMappings) {
        this.roleMappings = roleMappings;
    }

    public String[] getIdpRoles() {
        return this.idpRoles;
    }

    public void setIdpRoles(String[] idpRoles) {
        this.idpRoles = idpRoles;
    }
}

