/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="OutboundProvisioningConfig")
public class OutboundProvisioningConfig
implements Serializable {
    private static final long serialVersionUID = 3669233357817378229L;
    @XmlElementWrapper(name="ProvisioningIdentityProviders")
    @XmlElement(name="IdentityProvider")
    private IdentityProvider[] provisioningIdentityProviders = new IdentityProvider[0];
    @XmlElementWrapper(name="ProvisionByRoleList")
    @XmlElement(name="ProvisionByRole")
    private String[] provisionByRoleList;

    public static OutboundProvisioningConfig build(OMElement outboundProvisioningConfigOM) {
        OutboundProvisioningConfig outboundProvisioningConfig = new OutboundProvisioningConfig();
        Iterator iter = outboundProvisioningConfigOM.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if ("ProvisioningIdentityProviders".equals(elementName)) {
                Iterator provisioningIdentityProvidersIter = element.getChildElements();
                ArrayList<IdentityProvider> provisioningIdentityProvidersArrList = new ArrayList<IdentityProvider>();
                if (provisioningIdentityProvidersIter != null) {
                    while (provisioningIdentityProvidersIter.hasNext()) {
                        OMElement provisioningIdentityProvidersElement = (OMElement)provisioningIdentityProvidersIter.next();
                        IdentityProvider idp = IdentityProvider.build(provisioningIdentityProvidersElement);
                        if (idp == null) continue;
                        provisioningIdentityProvidersArrList.add(idp);
                    }
                }
                if (!CollectionUtils.isNotEmpty(provisioningIdentityProvidersArrList)) continue;
                IdentityProvider[] provisioningIdentityProvidersArr = provisioningIdentityProvidersArrList.toArray(new IdentityProvider[0]);
                outboundProvisioningConfig.setProvisioningIdentityProviders(provisioningIdentityProvidersArr);
                continue;
            }
            if (!"ProvisionByRoleList".equals(elementName)) continue;
            Iterator provisionByRoleListIter = element.getChildElements();
            ArrayList<String> provisionByRoleListArrList = new ArrayList<String>();
            if (provisionByRoleListIter != null) {
                while (provisionByRoleListIter.hasNext()) {
                    OMElement provisionByRoleListElement = (OMElement)provisionByRoleListIter.next();
                    if (provisionByRoleListElement.getText() == null) continue;
                    provisionByRoleListArrList.add(provisionByRoleListElement.getText());
                }
            }
            if (!CollectionUtils.isNotEmpty(provisionByRoleListArrList)) continue;
            String[] provisionByRoleListArr = provisionByRoleListArrList.toArray(new String[0]);
            outboundProvisioningConfig.setProvisionByRoleList(provisionByRoleListArr);
        }
        return outboundProvisioningConfig;
    }

    public IdentityProvider[] getProvisioningIdentityProviders() {
        return this.provisioningIdentityProviders;
    }

    public void setProvisioningIdentityProviders(IdentityProvider[] provisioningIdentityProviders) {
        if (provisioningIdentityProviders == null) {
            return;
        }
        HashSet<IdentityProvider> propertySet = new HashSet<IdentityProvider>(Arrays.asList(provisioningIdentityProviders));
        this.provisioningIdentityProviders = propertySet.toArray(new IdentityProvider[propertySet.size()]);
    }

    public String[] getProvisionByRoleList() {
        return this.provisionByRoleList;
    }

    public void setProvisionByRoleList(String[] provisionByRoleList) {
        this.provisionByRoleList = provisionByRoleList;
    }
}

