/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="LocalRole")
public class LocalRole
implements Serializable {
    private static final long serialVersionUID = -1986741675509417413L;
    @XmlElement(name="LocalRoleName")
    private String localRoleName;
    @XmlElement(name="UserStoreId")
    private String userStoreId;

    public LocalRole() {
    }

    public LocalRole(String userStoreId, String localRoleName) {
        this.userStoreId = userStoreId;
        this.localRoleName = localRoleName;
    }

    public LocalRole(String combinedRoleName) {
        this.userStoreId = IdentityUtil.extractDomainFromName((String)combinedRoleName);
        this.localRoleName = UserCoreUtil.removeDomainFromName((String)combinedRoleName);
    }

    public static LocalRole build(OMElement localRoleOM) {
        LocalRole localRole = new LocalRole();
        Iterator iter = localRoleOM.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if ("LocalRoleName".equals(elementName)) {
                localRole.setLocalRoleName(element.getText());
                continue;
            }
            if (!"UserStoreId".equals(elementName)) continue;
            localRole.setUserStoreId(element.getText());
        }
        return localRole;
    }

    public String getLocalRoleName() {
        return this.localRoleName;
    }

    public void setLocalRoleName(String localRoleName) {
        this.localRoleName = localRoleName;
    }

    public String getUserStoreId() {
        return this.userStoreId;
    }

    public void setUserStoreId(String userStoreId) {
        this.userStoreId = userStoreId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalRole localRole1 = (LocalRole)o;
        if (!this.localRoleName.equals(localRole1.localRoleName)) {
            return false;
        }
        return !(this.userStoreId != null ? !this.userStoreId.equals(localRole1.userStoreId) : localRole1.userStoreId != null);
    }

    public int hashCode() {
        int result = this.localRoleName.hashCode();
        result = 31 * result + (this.userStoreId != null ? this.userStoreId.hashCode() : 0);
        return result;
    }
}

