/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;
import org.wso2.carbon.identity.application.common.model.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="LocalAuthenticatorConfig")
public class LocalAuthenticatorConfig
implements Serializable {
    private static final long serialVersionUID = 3363298518257599291L;
    @XmlElement(name="Name")
    protected String name;
    @XmlElement(name="DisplayName")
    protected String displayName;
    @XmlElement(name="IsEnabled")
    protected boolean enabled;
    @XmlElementWrapper(name="Properties")
    @XmlElement(name="Property")
    protected Property[] properties = new Property[0];

    public static LocalAuthenticatorConfig build(OMElement localAuthenticatorConfigOM) {
        LocalAuthenticatorConfig localAuthenticatorConfig = new LocalAuthenticatorConfig();
        if (localAuthenticatorConfigOM == null) {
            return new LocalAuthenticatorConfig();
        }
        Iterator members = localAuthenticatorConfigOM.getChildElements();
        while (members.hasNext()) {
            OMElement member = (OMElement)members.next();
            if ("Name".equals(member.getLocalName())) {
                localAuthenticatorConfig.setName(member.getText());
                continue;
            }
            if ("DisplayName".equals(member.getLocalName())) {
                localAuthenticatorConfig.setDisplayName(member.getText());
                continue;
            }
            if ("IsEnabled".equals(member.getLocalName())) {
                if (member.getText() == null || member.getText().trim().length() <= 0) continue;
                localAuthenticatorConfig.setEnabled(Boolean.parseBoolean(member.getText()));
                continue;
            }
            if (!"Properties".equals(member.getLocalName())) continue;
            Iterator propertiesIter = member.getChildElements();
            ArrayList<Property> propertiesArrList = new ArrayList<Property>();
            if (propertiesIter != null) {
                while (propertiesIter.hasNext()) {
                    OMElement propertiesElement = (OMElement)propertiesIter.next();
                    Property prop = Property.build(propertiesElement);
                    if (prop == null) continue;
                    propertiesArrList.add(prop);
                }
            }
            if (!CollectionUtils.isNotEmpty(propertiesArrList)) continue;
            Property[] propertiesArr = propertiesArrList.toArray(new Property[0]);
            localAuthenticatorConfig.setProperties(propertiesArr);
        }
        return localAuthenticatorConfig;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isValid() {
        return true;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public void setProperties(Property[] properties) {
        if (properties == null) {
            return;
        }
        HashSet<Property> propertySet = new HashSet<Property>(Arrays.asList(properties));
        this.properties = propertySet.toArray(new Property[0]);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalAuthenticatorConfig)) {
            return false;
        }
        LocalAuthenticatorConfig that = (LocalAuthenticatorConfig)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

