/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;
import org.wso2.carbon.identity.application.common.model.AuthenticationStep;
import org.wso2.carbon.identity.application.common.model.script.AuthenticationScriptConfig;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="LocalAndOutboundAuthenticationConfig")
public class LocalAndOutboundAuthenticationConfig
implements Serializable {
    private static final long serialVersionUID = 6552125621314155291L;
    private static final String USE_USERSTORE_DOMAIN_IN_USERNAME = "UseUserstoreDomainInUsername";
    private static final String USE_TENANT_DOMAIN_IN_USERNAME = "UseTenantDomainInUsername";
    private static final String USE_USERSTORE_DOMAIN_IN_ROLES = "UseUserstoreDomainInRoles";
    private static final String SKIP_CONSENT = "SkipConsent";
    private static final String SKIP_LOGOUT_CONSENT = "skipLogoutConsent";
    private static final String ENABLE_AUTHORIZATION = "EnableAuthorization";
    private static final String SUBJECT_CLAIM_URI = "subjectClaimUri";
    private static final String ALWAYS_SEND_BACK_AUTHENTICATED_LIST_OF_ID_PS = "alwaysSendBackAuthenticatedListOfIdPs";
    private static final String AUTHENTICATION_STEP_FOR_ATTRIBUTES = "AuthenticationStepForAttributes";
    private static final String AUTHENTICATION_STEP_FOR_SUBJECT = "AuthenticationStepForSubject";
    private static final String AUTHENTICATION_STEPS = "AuthenticationSteps";
    private static final String AUTHENTICATION_GRAPH = "AuthenticationGraph";
    private static final String AUTHENTICATION_SCRIPT = "AuthenticationScript";
    @XmlElementWrapper(name="AuthenticationSteps")
    @XmlElement(name="AuthenticationStep")
    private AuthenticationStep[] authenticationSteps = new AuthenticationStep[0];
    @XmlElement(name="AuthenticationType")
    private String authenticationType;
    @XmlElement(name="AuthenticationStepForSubject")
    private AuthenticationStep authenticationStepForSubject;
    @XmlElement(name="AuthenticationStepForAttributes")
    private AuthenticationStep authenticationStepForAttributes;
    @XmlElement(name="alwaysSendBackAuthenticatedListOfIdPs")
    private boolean alwaysSendBackAuthenticatedListOfIdPs;
    @XmlElement(name="subjectClaimUri")
    private String subjectClaimUri;
    @XmlElement(name="UseTenantDomainInUsername")
    private boolean useTenantDomainInLocalSubjectIdentifier = false;
    @XmlElement(name="UseUserstoreDomainInRoles")
    private boolean useUserstoreDomainInRoles = true;
    @XmlElement(name="UseUserstoreDomainInUsername")
    private boolean useUserstoreDomainInLocalSubjectIdentifier = false;
    @XmlElement(name="SkipConsent")
    private boolean skipConsent = false;
    @XmlElement(name="skipLogoutConsent")
    private boolean skipLogoutConsent = false;
    @XmlElement(name="EnableAuthorization")
    private boolean enableAuthorization = false;
    @XmlElement(name="AuthenticationScript")
    private AuthenticationScriptConfig authenticationScriptConfig;

    public static LocalAndOutboundAuthenticationConfig build(OMElement localAndOutboundAuthenticationConfigOM) {
        LocalAndOutboundAuthenticationConfig localAndOutboundAuthenticationConfig = new LocalAndOutboundAuthenticationConfig();
        if (localAndOutboundAuthenticationConfigOM == null) {
            return localAndOutboundAuthenticationConfig;
        }
        Iterator iter = localAndOutboundAuthenticationConfigOM.getChildElements();
        while (iter.hasNext()) {
            AuthenticationStep authStep;
            OMElement member = (OMElement)iter.next();
            if (AUTHENTICATION_SCRIPT.equals(member.getLocalName())) {
                localAndOutboundAuthenticationConfig.authenticationScriptConfig = AuthenticationScriptConfig.build(member);
                continue;
            }
            if (AUTHENTICATION_STEPS.equals(member.getLocalName())) {
                Iterator authenticationStepsIter = member.getChildElements();
                ArrayList<AuthenticationStep> authenticationStepsArrList = new ArrayList<AuthenticationStep>();
                if (authenticationStepsIter != null) {
                    while (authenticationStepsIter.hasNext()) {
                        OMElement authenticationStepsElement = (OMElement)authenticationStepsIter.next();
                        AuthenticationStep authStep2 = AuthenticationStep.build(authenticationStepsElement);
                        if (authStep2 == null) continue;
                        authenticationStepsArrList.add(authStep2);
                    }
                }
                if (!CollectionUtils.isNotEmpty(authenticationStepsArrList)) continue;
                AuthenticationStep[] authenticationStepsArr = authenticationStepsArrList.toArray(new AuthenticationStep[0]);
                localAndOutboundAuthenticationConfig.setAuthenticationSteps(authenticationStepsArr);
                continue;
            }
            if ("AuthenticationType".equals(member.getLocalName())) {
                localAndOutboundAuthenticationConfig.setAuthenticationType(member.getText());
                continue;
            }
            if (AUTHENTICATION_STEP_FOR_SUBJECT.equals(member.getLocalName())) {
                authStep = AuthenticationStep.build(member);
                if (authStep == null) continue;
                localAndOutboundAuthenticationConfig.setAuthenticationStepForSubject(authStep);
                continue;
            }
            if (AUTHENTICATION_STEP_FOR_ATTRIBUTES.equals(member.getLocalName())) {
                authStep = AuthenticationStep.build(member);
                if (authStep == null) continue;
                localAndOutboundAuthenticationConfig.setAuthenticationStepForAttributes(authStep);
                continue;
            }
            if (ALWAYS_SEND_BACK_AUTHENTICATED_LIST_OF_ID_PS.equals(member.getLocalName())) {
                if (member.getText() == null || !"true".equals(member.getText())) continue;
                localAndOutboundAuthenticationConfig.setAlwaysSendBackAuthenticatedListOfIdPs(true);
                continue;
            }
            if (USE_USERSTORE_DOMAIN_IN_USERNAME.equals(member.getLocalName())) {
                if (!Boolean.parseBoolean(member.getText())) continue;
                localAndOutboundAuthenticationConfig.setUseUserstoreDomainInLocalSubjectIdentifier(true);
                continue;
            }
            if (USE_TENANT_DOMAIN_IN_USERNAME.equals(member.getLocalName())) {
                if (!Boolean.parseBoolean(member.getText())) continue;
                localAndOutboundAuthenticationConfig.setUseTenantDomainInLocalSubjectIdentifier(true);
                continue;
            }
            if (ENABLE_AUTHORIZATION.equals(member.getLocalName())) {
                if (!Boolean.parseBoolean(member.getText())) continue;
                localAndOutboundAuthenticationConfig.setEnableAuthorization(true);
                continue;
            }
            if (SUBJECT_CLAIM_URI.equals(member.getLocalName())) {
                localAndOutboundAuthenticationConfig.setSubjectClaimUri(member.getText());
                continue;
            }
            if (USE_USERSTORE_DOMAIN_IN_ROLES.equals(member.getLocalName())) {
                if (!Boolean.parseBoolean(member.getText())) continue;
                localAndOutboundAuthenticationConfig.setUseUserstoreDomainInRoles(true);
                continue;
            }
            if (SKIP_CONSENT.equals(member.getLocalName())) {
                if (!Boolean.parseBoolean(member.getText())) continue;
                localAndOutboundAuthenticationConfig.setSkipConsent(true);
                continue;
            }
            if (!SKIP_LOGOUT_CONSENT.equals(member.getLocalName()) || !Boolean.parseBoolean(member.getText())) continue;
            localAndOutboundAuthenticationConfig.setSkipLogoutConsent(true);
        }
        return localAndOutboundAuthenticationConfig;
    }

    public AuthenticationStep[] getAuthenticationSteps() {
        return this.authenticationSteps;
    }

    public void setAuthenticationSteps(AuthenticationStep[] authenticationSteps) {
        this.authenticationSteps = authenticationSteps;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public AuthenticationStep getAuthenticationStepForSubject() {
        return this.authenticationStepForSubject;
    }

    public void setAuthenticationStepForSubject(AuthenticationStep authenticationStepForSubject) {
        this.authenticationStepForSubject = authenticationStepForSubject;
    }

    public AuthenticationStep getAuthenticationStepForAttributes() {
        return this.authenticationStepForAttributes;
    }

    public void setAuthenticationStepForAttributes(AuthenticationStep authenticationStepForAttributes) {
        this.authenticationStepForAttributes = authenticationStepForAttributes;
    }

    public boolean isAlwaysSendBackAuthenticatedListOfIdPs() {
        return this.alwaysSendBackAuthenticatedListOfIdPs;
    }

    public void setAlwaysSendBackAuthenticatedListOfIdPs(boolean alwaysSendBackAuthenticatedListOfIdPs) {
        this.alwaysSendBackAuthenticatedListOfIdPs = alwaysSendBackAuthenticatedListOfIdPs;
    }

    public String getSubjectClaimUri() {
        return this.subjectClaimUri;
    }

    public void setSubjectClaimUri(String subjectClaimUri) {
        this.subjectClaimUri = subjectClaimUri;
    }

    public boolean isUseTenantDomainInLocalSubjectIdentifier() {
        return this.useTenantDomainInLocalSubjectIdentifier;
    }

    public void setUseTenantDomainInLocalSubjectIdentifier(boolean useTenantDomainInLocalSubjectIdentifier) {
        this.useTenantDomainInLocalSubjectIdentifier = useTenantDomainInLocalSubjectIdentifier;
    }

    public boolean isUseUserstoreDomainInLocalSubjectIdentifier() {
        return this.useUserstoreDomainInLocalSubjectIdentifier;
    }

    public void setUseUserstoreDomainInLocalSubjectIdentifier(boolean useUserstoreDomainInLocalSubjectIdentifier) {
        this.useUserstoreDomainInLocalSubjectIdentifier = useUserstoreDomainInLocalSubjectIdentifier;
    }

    public boolean isEnableAuthorization() {
        return this.enableAuthorization;
    }

    public void setEnableAuthorization(boolean enableAuthorization) {
        this.enableAuthorization = enableAuthorization;
    }

    public AuthenticationScriptConfig getAuthenticationScriptConfig() {
        return this.authenticationScriptConfig;
    }

    public void setAuthenticationScriptConfig(AuthenticationScriptConfig authenticationScriptConfig) {
        this.authenticationScriptConfig = authenticationScriptConfig;
    }

    public boolean isUseUserstoreDomainInRoles() {
        return this.useUserstoreDomainInRoles;
    }

    public void setUseUserstoreDomainInRoles(boolean useUserstoreDomainInRoles) {
        this.useUserstoreDomainInRoles = useUserstoreDomainInRoles;
    }

    public boolean isSkipConsent() {
        return this.skipConsent;
    }

    public void setSkipConsent(boolean skipConsent) {
        this.skipConsent = skipConsent;
    }

    public boolean isSkipLogoutConsent() {
        return this.skipLogoutConsent;
    }

    public void setSkipLogoutConsent(boolean skipLogoutConsent) {
        this.skipLogoutConsent = skipLogoutConsent;
    }
}

