/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.common.model.InboundProvisioningConfig;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="JustInTimeProvisioningConfig")
public class JustInTimeProvisioningConfig
extends InboundProvisioningConfig
implements Serializable {
    private static final long serialVersionUID = 6754801699494009980L;
    @XmlElement(name="IsPasswordProvisioningEnabled")
    private boolean passwordProvisioningEnabled = false;
    @XmlElement(name="UserStoreClaimUri")
    private String userStoreClaimUri;
    @XmlElement(name="AllowModifyUserName")
    private boolean modifyUserNameAllowed = false;
    @XmlElement(name="PromptConsent")
    private boolean promptConsent = false;

    public static JustInTimeProvisioningConfig build(OMElement justInTimeProvisioningConfigOM) {
        JustInTimeProvisioningConfig justInTimeProvisioningConfig = new JustInTimeProvisioningConfig();
        if (justInTimeProvisioningConfigOM == null) {
            return justInTimeProvisioningConfig;
        }
        Iterator iter = justInTimeProvisioningConfigOM.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if ("UserStoreClaimUri".equals(elementName)) {
                justInTimeProvisioningConfig.setUserStoreClaimUri(element.getText());
                continue;
            }
            if ("ProvisioningUserStore".equals(elementName)) {
                justInTimeProvisioningConfig.setProvisioningUserStore(element.getText());
                continue;
            }
            if ("IsProvisioningEnabled".equals(elementName)) {
                if (element.getText() == null || element.getText().trim().length() <= 0) continue;
                justInTimeProvisioningConfig.setProvisioningEnabled(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if ("IsPasswordProvisioningEnabled".equals(elementName)) {
                if (!StringUtils.isNotEmpty((String)element.getText())) continue;
                justInTimeProvisioningConfig.setPasswordProvisioningEnabled(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if ("AllowModifyUserName".equals(elementName)) {
                if (!StringUtils.isNotEmpty((String)element.getText())) continue;
                justInTimeProvisioningConfig.setModifyUserNameAllowed(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if (!"PromptConsent".equals(elementName) || !StringUtils.isNotEmpty((String)element.getText())) continue;
            justInTimeProvisioningConfig.setPromptConsent(Boolean.parseBoolean(element.getText()));
        }
        return justInTimeProvisioningConfig;
    }

    public String getUserStoreClaimUri() {
        return this.userStoreClaimUri;
    }

    public void setUserStoreClaimUri(String userStoreClaimUri) {
        this.userStoreClaimUri = userStoreClaimUri;
    }

    public void setPasswordProvisioningEnabled(boolean isPasswordProvisioningEnabled) {
        this.passwordProvisioningEnabled = isPasswordProvisioningEnabled;
    }

    public boolean isPasswordProvisioningEnabled() {
        return this.passwordProvisioningEnabled;
    }

    public boolean isModifyUserNameAllowed() {
        return this.modifyUserNameAllowed;
    }

    public void setModifyUserNameAllowed(boolean isModifyUserNameAllowed) {
        this.modifyUserNameAllowed = isModifyUserNameAllowed;
    }

    public boolean isPromptConsent() {
        return this.promptConsent;
    }

    public void setPromptConsent(boolean promptConsent) {
        this.promptConsent = promptConsent;
    }
}

