/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;
import org.wso2.carbon.identity.application.common.model.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="InboundAuthenticationRequestConfig")
public class InboundAuthenticationRequestConfig
implements Serializable {
    private static final long serialVersionUID = -62766721187073002L;
    @XmlElement(name="InboundAuthKey")
    private String inboundAuthKey;
    @XmlElement(name="InboundAuthType")
    private String inboundAuthType;
    @XmlElement(name="InboundConfigType")
    private String inboundConfigType;
    @XmlElement(name="friendlyName")
    private String friendlyName;
    @XmlElement(name="inboundConfiguration")
    private String inboundConfiguration;
    @XmlElementWrapper(name="Properties")
    @XmlElement(name="Property")
    private Property[] properties = new Property[0];

    public static InboundAuthenticationRequestConfig build(OMElement inboundAuthenticationRequestConfigOM) {
        if (inboundAuthenticationRequestConfigOM == null) {
            return null;
        }
        InboundAuthenticationRequestConfig inboundAuthenticationRequestConfig = new InboundAuthenticationRequestConfig();
        Iterator members = inboundAuthenticationRequestConfigOM.getChildElements();
        while (members.hasNext()) {
            OMElement member = (OMElement)members.next();
            if ("InboundAuthKey".equalsIgnoreCase(member.getLocalName())) {
                inboundAuthenticationRequestConfig.setInboundAuthKey(member.getText());
                continue;
            }
            if ("InboundAuthType".equalsIgnoreCase(member.getLocalName())) {
                inboundAuthenticationRequestConfig.setInboundAuthType(member.getText());
                continue;
            }
            if ("InboundConfigType".equalsIgnoreCase(member.getLocalName())) {
                inboundAuthenticationRequestConfig.setInboundConfigType(member.getText());
                continue;
            }
            if ("friendlyName".equalsIgnoreCase(member.getLocalName())) {
                inboundAuthenticationRequestConfig.setFriendlyName(member.getText());
                continue;
            }
            if (!"Properties".equalsIgnoreCase(member.getLocalName())) continue;
            Iterator propertiesIter = member.getChildElements();
            ArrayList<Property> propertiesArrList = new ArrayList<Property>();
            if (propertiesIter != null) {
                while (propertiesIter.hasNext()) {
                    OMElement propertiesElement = (OMElement)propertiesIter.next();
                    Property prop = Property.build(propertiesElement);
                    if (prop == null) continue;
                    propertiesArrList.add(prop);
                }
            }
            if (!CollectionUtils.isNotEmpty(propertiesArrList)) continue;
            Property[] propertiesArr = propertiesArrList.toArray(new Property[0]);
            inboundAuthenticationRequestConfig.setProperties(propertiesArr);
        }
        return inboundAuthenticationRequestConfig;
    }

    public String getInboundAuthKey() {
        return this.inboundAuthKey;
    }

    public void setInboundAuthKey(String inboundAuthKey) {
        this.inboundAuthKey = inboundAuthKey;
    }

    public String getInboundAuthType() {
        return this.inboundAuthType;
    }

    public void setInboundAuthType(String inboundAuthType) {
        this.inboundAuthType = inboundAuthType;
    }

    public String getInboundConfigType() {
        return this.inboundConfigType;
    }

    public void setInboundConfigType(String inboundConfigType) {
        this.inboundConfigType = inboundConfigType;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public void setProperties(Property[] properties) {
        if (properties == null) {
            return;
        }
        HashSet<Property> propertySet = new HashSet<Property>(Arrays.asList(properties));
        this.properties = this.sortPropertiesByDisplayOrder(propertySet);
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    private Property[] sortPropertiesByDisplayOrder(Set<Property> propertySet) {
        ArrayList<Property> list = new ArrayList<Property>(propertySet);
        list.sort(new Comparator<Property>(){

            @Override
            public int compare(Property pro1, Property pro2) {
                return Integer.compare(pro1.getDisplayOrder(), pro2.getDisplayOrder());
            }
        });
        return list.toArray(new Property[0]);
    }

    public String getInboundConfiguration() {
        return this.inboundConfiguration;
    }

    public void setInboundConfiguration(String inboundConfiguration) {
        this.inboundConfiguration = inboundConfiguration;
    }
}

