/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.databinding.annotation.IgnoreNullElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.CertificateInfo;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProviderProperty;
import org.wso2.carbon.identity.application.common.model.JustInTimeProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="IdentityProvider")
public class IdentityProvider
implements Serializable {
    private static final long serialVersionUID = 2199048941051702943L;
    private static final Log log = LogFactory.getLog(IdentityProvider.class);
    private static final String FILE_ELEMENT_IDENTITY_PROVIDER_NAME = "IdentityProviderName";
    private static final String FILE_ELEMENT_IDENTITY_PROVIDER_DESCRIPTION = "IdentityProviderDescription";
    private static final String FILE_ELEMENT_ALIAS = "Alias";
    private static final String FILE_ELEMENT_DISPLAY_NAME = "DisplayName";
    private static final String FILE_ELEMENT_IS_PRIMARY = "IsPrimary";
    private static final String FILE_ELEMENT_IS_ENABLED = "IsEnabled";
    private static final String FILE_ELEMENT_IS_FEDERATION_HUB = "IsFederationHub";
    private static final String FILE_ELEMENT_HOME_REALM_ID = "HomeRealmId";
    private static final String FILE_ELEMENT_PROVISIONING_ROLE = "ProvisioningRole";
    private static final String FILE_ELEMENT_FEDERATED_AUTHENTICATOR_CONFIGS = "FederatedAuthenticatorConfigs";
    private static final String FILE_ELEMENT_DEFAULT_AUTHENTICATOR_CONFIG = "DefaultAuthenticatorConfig";
    private static final String FILE_ELEMENT_PROVISIONING_CONNECTOR_CONFIGS = "ProvisioningConnectorConfigs";
    private static final String FILE_ELEMENT_DEFAULT_PROVISIONING_CONNECTOR_CONFIG = "DefaultProvisioningConnectorConfig";
    private static final String FILE_ELEMENT_CLAIM_CONFIG = "ClaimConfig";
    private static final String FILE_ELEMENT_CERTIFICATE = "Certificate";
    private static final String FILE_ELEMENT_PERMISSION_AND_ROLE_CONFIG = "PermissionAndRoleConfig";
    private static final String FILE_ELEMENT_JUST_IN_TIME_PROVISIONING_CONFIG = "JustInTimeProvisioningConfig";
    private static final String FILE_ELEMENT_IMAGE_URL = "ImageUrl";
    private static final String THUMB_PRINT = "thumbPrint";
    private static final String CERT_VALUE = "certValue";
    private static final String JSON_ARRAY_IDENTIFIER = "[";
    private static final String EMPTY_JSON_ARRAY = "[]";
    @XmlTransient
    private String id;
    @XmlElement(name="IdentityProviderName")
    private String identityProviderName;
    @XmlElement(name="IdentityProviderDescription")
    private String identityProviderDescription;
    @XmlElement(name="Alias")
    private String alias;
    @XmlElement(name="IsPrimary")
    private boolean primary;
    @XmlElement(name="IsFederationHub")
    private boolean federationHub;
    @XmlElement(name="HomeRealmId")
    private String homeRealmId;
    @XmlElement(name="ProvisioningRole")
    private String provisioningRole;
    @XmlElement(name="DisplayName")
    private String displayName;
    @XmlElement(name="IsEnabled")
    private boolean enable;
    @XmlElementWrapper(name="FederatedAuthenticatorConfigs")
    @XmlElement(name="FederatedAuthenticatorConfig")
    private FederatedAuthenticatorConfig[] federatedAuthenticatorConfigs = new FederatedAuthenticatorConfig[0];
    @XmlElement(name="DefaultAuthenticatorConfig")
    private FederatedAuthenticatorConfig defaultAuthenticatorConfig;
    @XmlElementWrapper(name="ProvisioningConnectorConfigs")
    @XmlElement(name="ProvisioningConnectorConfig")
    private ProvisioningConnectorConfig[] provisioningConnectorConfigs = new ProvisioningConnectorConfig[0];
    @XmlElement(name="DefaultProvisioningConnectorConfig")
    private ProvisioningConnectorConfig defaultProvisioningConnectorConfig;
    @XmlElement(name="ClaimConfig")
    private ClaimConfig claimConfig;
    @XmlElement(name="Certificate")
    private String certificate;
    @XmlElement(name="PermissionAndRoleConfig")
    private PermissionsAndRoleConfig permissionAndRoleConfig;
    @XmlElement(name="JustInTimeProvisioningConfig")
    private JustInTimeProvisioningConfig justInTimeProvisioningConfig;
    @XmlTransient
    private IdentityProviderProperty[] idpProperties = new IdentityProviderProperty[0];
    private CertificateInfo[] certificateInfoArray = new CertificateInfo[0];
    @IgnoreNullElement
    @XmlElement(name="ImageUrl")
    private String imageUrl;
    @IgnoreNullElement
    @XmlTransient
    private String resourceId;

    public static IdentityProvider build(OMElement identityProviderOM) {
        IdentityProvider identityProvider = new IdentityProvider();
        Iterator iter = identityProviderOM.getChildElements();
        String defaultAuthenticatorConfigName = null;
        String defaultProvisioningConfigName = null;
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if (elementName.equals(FILE_ELEMENT_IDENTITY_PROVIDER_NAME)) {
                if (element.getText() != null) {
                    identityProvider.setIdentityProviderName(element.getText());
                    continue;
                }
                log.error((Object)"Identity provider not loaded from the file system. Identity provider name must be not null.");
                return null;
            }
            if (FILE_ELEMENT_IDENTITY_PROVIDER_DESCRIPTION.equals(elementName)) {
                identityProvider.setIdentityProviderDescription(element.getText());
                continue;
            }
            if (FILE_ELEMENT_ALIAS.equals(elementName)) {
                identityProvider.setAlias(element.getText());
                continue;
            }
            if (FILE_ELEMENT_DISPLAY_NAME.equals(elementName)) {
                identityProvider.setDisplayName(element.getText());
                continue;
            }
            if (FILE_ELEMENT_IS_PRIMARY.equals(elementName)) {
                if (element.getText() == null || element.getText().trim().length() <= 0) continue;
                identityProvider.setPrimary(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if (FILE_ELEMENT_IS_ENABLED.equals(elementName)) {
                if (element.getText() == null || element.getText().trim().length() <= 0) continue;
                identityProvider.setEnable(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if (FILE_ELEMENT_IS_FEDERATION_HUB.equals(elementName)) {
                if (element.getText() == null || element.getText().trim().length() <= 0) continue;
                identityProvider.setFederationHub(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if (FILE_ELEMENT_HOME_REALM_ID.equals(elementName)) {
                identityProvider.setHomeRealmId(element.getText());
                continue;
            }
            if (FILE_ELEMENT_PROVISIONING_ROLE.equals(elementName)) {
                identityProvider.setProvisioningRole(element.getText());
                continue;
            }
            if (FILE_ELEMENT_FEDERATED_AUTHENTICATOR_CONFIGS.equals(elementName)) {
                Iterator federatedAuthenticatorConfigsIter = element.getChildElements();
                if (federatedAuthenticatorConfigsIter == null) continue;
                ArrayList<FederatedAuthenticatorConfig> federatedAuthenticatorConfigsArrList = new ArrayList<FederatedAuthenticatorConfig>();
                while (federatedAuthenticatorConfigsIter.hasNext()) {
                    OMElement federatedAuthenticatorConfigsElement = (OMElement)federatedAuthenticatorConfigsIter.next();
                    FederatedAuthenticatorConfig fedAuthConfig = FederatedAuthenticatorConfig.build(federatedAuthenticatorConfigsElement);
                    if (fedAuthConfig == null) continue;
                    federatedAuthenticatorConfigsArrList.add(fedAuthConfig);
                }
                if (federatedAuthenticatorConfigsArrList.size() <= 0) continue;
                FederatedAuthenticatorConfig[] federatedAuthenticatorConfigsArr = federatedAuthenticatorConfigsArrList.toArray(new FederatedAuthenticatorConfig[0]);
                identityProvider.setFederatedAuthenticatorConfigs(federatedAuthenticatorConfigsArr);
                continue;
            }
            if (FILE_ELEMENT_DEFAULT_AUTHENTICATOR_CONFIG.equals(elementName)) {
                if (element.getText().trim().isEmpty()) {
                    FederatedAuthenticatorConfig defaultAuthenticatorConfig = FederatedAuthenticatorConfig.build(element);
                    if (defaultAuthenticatorConfig == null) continue;
                    defaultAuthenticatorConfigName = defaultAuthenticatorConfig.getName();
                    continue;
                }
                defaultAuthenticatorConfigName = element.getText();
                continue;
            }
            if (FILE_ELEMENT_PROVISIONING_CONNECTOR_CONFIGS.equals(elementName)) {
                Iterator provisioningConnectorConfigsIter = element.getChildElements();
                if (provisioningConnectorConfigsIter == null) continue;
                ArrayList<ProvisioningConnectorConfig> provisioningConnectorConfigsArrList = new ArrayList<ProvisioningConnectorConfig>();
                while (provisioningConnectorConfigsIter.hasNext()) {
                    OMElement provisioningConnectorConfigsElement = (OMElement)provisioningConnectorConfigsIter.next();
                    ProvisioningConnectorConfig proConConfig = null;
                    try {
                        proConConfig = ProvisioningConnectorConfig.build(provisioningConnectorConfigsElement);
                    }
                    catch (IdentityApplicationManagementException e) {
                        log.error((Object)("Error while building provisioningConnectorConfig for IDP " + identityProvider.getIdentityProviderName() + ". Cause : " + e.getMessage() + ". Building rest of the IDP configs"), (Throwable)e);
                    }
                    if (proConConfig == null) continue;
                    provisioningConnectorConfigsArrList.add(proConConfig);
                }
                if (!CollectionUtils.isNotEmpty(provisioningConnectorConfigsArrList)) continue;
                ProvisioningConnectorConfig[] provisioningConnectorConfigsArr = provisioningConnectorConfigsArrList.toArray(new ProvisioningConnectorConfig[0]);
                identityProvider.setProvisioningConnectorConfigs(provisioningConnectorConfigsArr);
                continue;
            }
            if (FILE_ELEMENT_DEFAULT_PROVISIONING_CONNECTOR_CONFIG.equals(elementName)) {
                if (element.getText().trim().isEmpty()) {
                    try {
                        ProvisioningConnectorConfig proConConfig = ProvisioningConnectorConfig.build(element);
                        if (proConConfig == null) continue;
                        defaultProvisioningConfigName = proConConfig.getName();
                    }
                    catch (IdentityApplicationManagementException e) {
                        log.error((Object)String.format("Error while building default provisioning connector config for IDP %s. Cause : %s Building rest of the IDP configs", identityProvider.getIdentityProviderName(), e.getMessage()));
                    }
                    continue;
                }
                defaultProvisioningConfigName = element.getText();
                continue;
            }
            if (FILE_ELEMENT_CLAIM_CONFIG.equals(elementName)) {
                identityProvider.setClaimConfig(ClaimConfig.build(element));
                continue;
            }
            if (FILE_ELEMENT_CERTIFICATE.equals(elementName)) {
                identityProvider.setCertificate(element.getText());
                continue;
            }
            if (FILE_ELEMENT_PERMISSION_AND_ROLE_CONFIG.equals(elementName)) {
                identityProvider.setPermissionAndRoleConfig(PermissionsAndRoleConfig.build(element));
                continue;
            }
            if (FILE_ELEMENT_JUST_IN_TIME_PROVISIONING_CONFIG.equals(elementName)) {
                identityProvider.setJustInTimeProvisioningConfig(JustInTimeProvisioningConfig.build(element));
                continue;
            }
            if (!FILE_ELEMENT_IMAGE_URL.equals(elementName)) continue;
            identityProvider.setImageUrl(element.getText());
        }
        FederatedAuthenticatorConfig[] federatedAuthenticatorConfigs = identityProvider.getFederatedAuthenticatorConfigs();
        boolean foundDefaultAuthenticator = false;
        for (int i = 0; i < federatedAuthenticatorConfigs.length; ++i) {
            if (!StringUtils.equals(defaultAuthenticatorConfigName, (String)federatedAuthenticatorConfigs[i].getName())) continue;
            identityProvider.setDefaultAuthenticatorConfig(federatedAuthenticatorConfigs[i]);
            foundDefaultAuthenticator = true;
            break;
        }
        if (!foundDefaultAuthenticator && federatedAuthenticatorConfigs.length > 0 || federatedAuthenticatorConfigs.length == 0 && StringUtils.isNotBlank(defaultAuthenticatorConfigName)) {
            log.warn((Object)("No matching federated authentication config found with default authentication config name :  " + defaultAuthenticatorConfigName + " in identity provider : " + identityProvider.displayName + "."));
            return null;
        }
        ProvisioningConnectorConfig[] provisioningConnectorConfigs = identityProvider.getProvisioningConnectorConfigs();
        boolean foundDefaultProvisioningConfig = false;
        for (int i = 0; i < provisioningConnectorConfigs.length; ++i) {
            if (!StringUtils.equals(defaultProvisioningConfigName, (String)provisioningConnectorConfigs[i].getName())) continue;
            identityProvider.setDefaultProvisioningConnectorConfig(provisioningConnectorConfigs[i]);
            foundDefaultProvisioningConfig = true;
            break;
        }
        if (!foundDefaultProvisioningConfig && provisioningConnectorConfigs.length > 0 || provisioningConnectorConfigs.length == 0 && StringUtils.isNotBlank(defaultProvisioningConfigName)) {
            log.warn((Object)("No matching provisioning config found with default provisioning config name :  " + defaultProvisioningConfigName + " in identity provider : " + identityProvider.displayName + "."));
            identityProvider = null;
        }
        return identityProvider;
    }

    public FederatedAuthenticatorConfig[] getFederatedAuthenticatorConfigs() {
        return this.federatedAuthenticatorConfigs;
    }

    public void setFederatedAuthenticatorConfigs(FederatedAuthenticatorConfig[] federatedAuthenticatorConfigs) {
        if (federatedAuthenticatorConfigs == null) {
            return;
        }
        HashSet<FederatedAuthenticatorConfig> propertySet = new HashSet<FederatedAuthenticatorConfig>(Arrays.asList(federatedAuthenticatorConfigs));
        this.federatedAuthenticatorConfigs = propertySet.toArray(new FederatedAuthenticatorConfig[propertySet.size()]);
    }

    public FederatedAuthenticatorConfig getDefaultAuthenticatorConfig() {
        return this.defaultAuthenticatorConfig;
    }

    public void setDefaultAuthenticatorConfig(FederatedAuthenticatorConfig defaultAuthenticatorConfig) {
        this.defaultAuthenticatorConfig = defaultAuthenticatorConfig;
    }

    public String getIdentityProviderName() {
        return this.identityProviderName;
    }

    public void setIdentityProviderName(String identityProviderName) {
        this.identityProviderName = identityProviderName;
    }

    public String getIdentityProviderDescription() {
        return this.identityProviderDescription;
    }

    public void setIdentityProviderDescription(String identityProviderDescription) {
        this.identityProviderDescription = identityProviderDescription;
    }

    public ProvisioningConnectorConfig getDefaultProvisioningConnectorConfig() {
        return this.defaultProvisioningConnectorConfig;
    }

    public void setDefaultProvisioningConnectorConfig(ProvisioningConnectorConfig defaultProvisioningConnectorConfig) {
        this.defaultProvisioningConnectorConfig = defaultProvisioningConnectorConfig;
    }

    public ProvisioningConnectorConfig[] getProvisioningConnectorConfigs() {
        return this.provisioningConnectorConfigs;
    }

    public void setProvisioningConnectorConfigs(ProvisioningConnectorConfig[] provisioningConnectorConfigs) {
        if (provisioningConnectorConfigs == null) {
            return;
        }
        HashSet<ProvisioningConnectorConfig> propertySet = new HashSet<ProvisioningConnectorConfig>(Arrays.asList(provisioningConnectorConfigs));
        this.provisioningConnectorConfigs = propertySet.toArray(new ProvisioningConnectorConfig[propertySet.size()]);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getCertificate() {
        if (StringUtils.isNotBlank((String)this.certificate) && this.certificate.startsWith(JSON_ARRAY_IDENTIFIER)) {
            this.certificate = !this.certificate.equals(EMPTY_JSON_ARRAY) ? ((JSONObject)new JSONArray(this.certificate).get(0)).getString(CERT_VALUE) : "";
        }
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.setCertificateInfoArray(certificate);
        this.certificate = certificate;
    }

    public CertificateInfo[] getCertificateInfoArray() {
        return this.certificateInfoArray;
    }

    private void setCertificateInfoArray(String certificateValue) {
        block6: {
            try {
                if (StringUtils.isNotBlank((String)certificateValue) && !certificateValue.equals(EMPTY_JSON_ARRAY)) {
                    certificateValue = certificateValue.trim();
                    try {
                        this.certificateInfoArray = this.handleJsonFormatCertificate(certificateValue);
                    }
                    catch (JSONException e) {
                        if (certificateValue.startsWith("-----BEGIN CERTIFICATE-----")) {
                            this.certificateInfoArray = this.handlePlainTextCertificate(certificateValue);
                            break block6;
                        }
                        this.certificateInfoArray = this.handleEncodedCertificate(certificateValue);
                    }
                    break block6;
                }
                this.certificateInfoArray = new CertificateInfo[0];
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"Error while generating thumbPrint. Unsupported hash algorithm. ", (Throwable)e);
            }
        }
    }

    private CertificateInfo[] handleJsonFormatCertificate(String certificateValue) throws NoSuchAlgorithmException {
        JSONArray jsonCertificateInfoArray = new JSONArray(certificateValue);
        int lengthOfJsonArray = jsonCertificateInfoArray.length();
        if (lengthOfJsonArray > 1 && log.isDebugEnabled()) {
            log.debug((Object)(lengthOfJsonArray + " certificates have been found"));
        }
        ArrayList<CertificateInfo> certificateInfos = new ArrayList<CertificateInfo>();
        for (int i = 0; i < lengthOfJsonArray; ++i) {
            JSONObject jsonCertificateInfoObject = (JSONObject)jsonCertificateInfoArray.get(i);
            String thumbPrint = jsonCertificateInfoObject.getString(THUMB_PRINT);
            CertificateInfo certificateInfo = new CertificateInfo();
            certificateInfo.setThumbPrint(thumbPrint);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handling json format certificate. ThumbPrint of the certificate is: " + thumbPrint));
            }
            certificateInfo.setCertValue(jsonCertificateInfoObject.getString(CERT_VALUE));
            certificateInfos.add(certificateInfo);
        }
        return certificateInfos.toArray(new CertificateInfo[lengthOfJsonArray]);
    }

    private CertificateInfo[] handleEncodedCertificate(String certificateValue) throws NoSuchAlgorithmException {
        String decodedCertificate;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling encoded certificates: " + certificateValue));
        }
        try {
            decodedCertificate = new String(Base64.getDecoder().decode(certificateValue), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException ex) {
            return this.createCertificateInfoForNoBeginCertificate(certificateValue);
        }
        if (StringUtils.isNotBlank((String)decodedCertificate) && !decodedCertificate.startsWith("-----BEGIN CERTIFICATE-----")) {
            return this.createCertificateInfoForNoBeginCertificate(certificateValue);
        }
        return this.createEncodedCertificateInfo(decodedCertificate, true);
    }

    private CertificateInfo[] createCertificateInfoForNoBeginCertificate(String certificateValue) throws NoSuchAlgorithmException {
        String encodedCertVal = Base64.getEncoder().encodeToString(certificateValue.getBytes(StandardCharsets.UTF_8));
        String thumbPrint = IdentityApplicationManagementUtil.generateThumbPrint(encodedCertVal);
        ArrayList<CertificateInfo> certificateInfoList = new ArrayList<CertificateInfo>();
        CertificateInfo certificateInfo = new CertificateInfo();
        certificateInfo.setThumbPrint(thumbPrint);
        certificateInfo.setCertValue(certificateValue);
        certificateInfoList.add(certificateInfo);
        return certificateInfoList.toArray(new CertificateInfo[1]);
    }

    private CertificateInfo[] handlePlainTextCertificate(String certificateValue) throws NoSuchAlgorithmException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling plain text certificate: " + certificateValue));
        }
        return this.createEncodedCertificateInfo(certificateValue, false);
    }

    private CertificateInfo[] createEncodedCertificateInfo(String decodedCertificate, boolean isEncoded) throws NoSuchAlgorithmException {
        int numberOfCertificates = StringUtils.countMatches((String)decodedCertificate, (String)"-----BEGIN CERTIFICATE-----");
        if (numberOfCertificates == 0) {
            log.error((Object)"Uploaded certificate doesn't have -----BEGIN CERTIFICATE----- and -----END CERTIFICATE-----");
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(numberOfCertificates + " certificates have been found. "));
        }
        ArrayList<CertificateInfo> certificateInfoArrayList = new ArrayList<CertificateInfo>();
        for (int ordinal = 1; ordinal <= numberOfCertificates; ++ordinal) {
            String certificateVal = isEncoded ? Base64.getEncoder().encodeToString(IdentityApplicationManagementUtil.extractCertificate(decodedCertificate, ordinal).getBytes(StandardCharsets.UTF_8)) : IdentityApplicationManagementUtil.extractCertificate(decodedCertificate, ordinal).replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
            CertificateInfo certificateInfo = new CertificateInfo();
            String thumbPrint = IdentityApplicationManagementUtil.generateThumbPrint(certificateVal);
            if (log.isDebugEnabled()) {
                log.debug((Object)("ThumbPrint of the certificate is: " + thumbPrint));
            }
            certificateInfo.setThumbPrint(thumbPrint);
            certificateInfo.setCertValue(certificateVal);
            certificateInfoArrayList.add(certificateInfo);
        }
        return certificateInfoArrayList.toArray(new CertificateInfo[numberOfCertificates]);
    }

    public ClaimConfig getClaimConfig() {
        return this.claimConfig;
    }

    public void setClaimConfig(ClaimConfig claimConfig) {
        this.claimConfig = claimConfig;
    }

    public PermissionsAndRoleConfig getPermissionAndRoleConfig() {
        return this.permissionAndRoleConfig;
    }

    public void setPermissionAndRoleConfig(PermissionsAndRoleConfig permissionAndRoleConfig) {
        this.permissionAndRoleConfig = permissionAndRoleConfig;
    }

    public String getHomeRealmId() {
        return this.homeRealmId;
    }

    public void setHomeRealmId(String homeRealmId) {
        this.homeRealmId = homeRealmId;
    }

    public JustInTimeProvisioningConfig getJustInTimeProvisioningConfig() {
        return this.justInTimeProvisioningConfig;
    }

    public void setJustInTimeProvisioningConfig(JustInTimeProvisioningConfig justInTimeProvisioningConfig) {
        this.justInTimeProvisioningConfig = justInTimeProvisioningConfig;
    }

    public boolean isFederationHub() {
        return this.federationHub;
    }

    public void setFederationHub(boolean federationHub) {
        this.federationHub = federationHub;
    }

    public String getProvisioningRole() {
        return this.provisioningRole;
    }

    public void setProvisioningRole(String provisioningRole) {
        this.provisioningRole = provisioningRole;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityProvider)) {
            return false;
        }
        IdentityProvider that = (IdentityProvider)o;
        return !(this.identityProviderName != null ? !this.identityProviderName.equals(that.identityProviderName) : that.identityProviderName != null);
    }

    public int hashCode() {
        return this.identityProviderName != null ? this.identityProviderName.hashCode() : 0;
    }

    public IdentityProviderProperty[] getIdpProperties() {
        return this.idpProperties;
    }

    public void setIdpProperties(IdentityProviderProperty[] idpProperties) {
        this.idpProperties = idpProperties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }
}

