/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.common.model.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="FederatedAuthenticatorConfig")
public class FederatedAuthenticatorConfig
implements Serializable {
    private static final long serialVersionUID = -2361107623257323257L;
    @XmlElement(name="Name")
    protected String name;
    @XmlElement(name="DisplayName")
    protected String displayName;
    @XmlElement(name="IsEnabled")
    protected boolean enabled;
    @XmlElementWrapper(name="Properties")
    @XmlElement(name="Property")
    protected Property[] properties = new Property[0];

    public static FederatedAuthenticatorConfig build(OMElement federatedAuthenticatorConfigOM) {
        if (federatedAuthenticatorConfigOM == null) {
            return null;
        }
        FederatedAuthenticatorConfig federatedAuthenticatorConfig = new FederatedAuthenticatorConfig();
        Iterator iter = federatedAuthenticatorConfigOM.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if ("Name".equals(elementName)) {
                federatedAuthenticatorConfig.setName(element.getText());
                continue;
            }
            if ("DisplayName".equals(elementName)) {
                federatedAuthenticatorConfig.setDisplayName(element.getText());
                continue;
            }
            if ("IsEnabled".equals(elementName)) {
                federatedAuthenticatorConfig.setEnabled(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if (!"Properties".equals(elementName)) continue;
            Iterator propertiesIter = element.getChildElements();
            ArrayList<Property> propertiesArrList = new ArrayList<Property>();
            if (propertiesIter != null) {
                while (propertiesIter.hasNext()) {
                    OMElement propertiesElement = (OMElement)propertiesIter.next();
                    propertiesArrList.add(Property.build(propertiesElement));
                }
            }
            if (!CollectionUtils.isNotEmpty(propertiesArrList)) continue;
            Property[] propertiesArr = propertiesArrList.toArray(new Property[propertiesArrList.size()]);
            federatedAuthenticatorConfig.setProperties(propertiesArr);
        }
        return federatedAuthenticatorConfig;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isValid() {
        return true;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public void setProperties(Property[] properties) {
        if (properties == null) {
            return;
        }
        HashSet<Property> propertySet = new HashSet<Property>(Arrays.asList(properties));
        this.properties = propertySet.toArray(new Property[propertySet.size()]);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FederatedAuthenticatorConfig)) {
            return false;
        }
        FederatedAuthenticatorConfig that = (FederatedAuthenticatorConfig)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public boolean isValidPropertyValue(Property property) {
        return property != null && StringUtils.isNotBlank((String)property.getValue());
    }
}

