/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.common.model.LocalAndOutboundAuthenticationConfig;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="DefaultAuthenticationSequence")
public class DefaultAuthenticationSequence
implements Serializable {
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="seqContent")
    private LocalAndOutboundAuthenticationConfig seqContent;
    @XmlElement(name="seqContentXml")
    private String seqContentXml;

    public static DefaultAuthenticationSequence build(OMElement defaultAuthSeqOM) {
        DefaultAuthenticationSequence authenticationSequence = new DefaultAuthenticationSequence();
        Iterator iter = defaultAuthSeqOM.getChildElements();
        while (iter.hasNext()) {
            OMElement member = (OMElement)iter.next();
            if ("name".equals(member.getLocalName())) {
                if (!StringUtils.isNotBlank((String)member.getText())) continue;
                authenticationSequence.setName(member.getText());
                continue;
            }
            if ("description".equals(member.getLocalName())) {
                if (!StringUtils.isNotBlank((String)member.getText())) continue;
                authenticationSequence.setDescription(member.getText());
                continue;
            }
            if (!"seqContent".equals(member.getLocalName()) || !StringUtils.isNotBlank((String)member.getText())) continue;
            authenticationSequence.setContentXml(member.getText());
        }
        return authenticationSequence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LocalAndOutboundAuthenticationConfig getContent() {
        return this.seqContent;
    }

    public void setContent(LocalAndOutboundAuthenticationConfig content) {
        this.seqContent = content;
    }

    public String getContentXml() {
        return this.seqContentXml;
    }

    public void setContentXml(String contentXml) {
        this.seqContentXml = contentXml;
    }
}

