/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="ConsentPurpose")
public class ConsentPurpose
implements Serializable {
    private static final long serialVersionUID = 1421773871658784071L;
    private static final Log log = LogFactory.getLog(ConsentPurpose.class);
    private static final String PURPOSE_ID_ELEM = "PurposeID";
    private static final String DISPLAY_ORDER_ELEM = "DisplayOrder";
    private static final int DEFAULT_DISPLAY_ORDER = 0;
    @XmlElement(name="PurposeID")
    private int purposeId;
    @XmlElement(name="DisplayOrder")
    private int displayOrder;

    public int getPurposeId() {
        return this.purposeId;
    }

    public void setPurposeId(int purposeId) {
        this.purposeId = purposeId;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public static ConsentPurpose build(OMElement consentPurposeOM) throws IdentityApplicationManagementException {
        ConsentPurpose consentPurpose = new ConsentPurpose();
        if (consentPurposeOM == null) {
            return consentPurpose;
        }
        Iterator children = consentPurposeOM.getChildElements();
        while (children.hasNext()) {
            OMElement member = (OMElement)children.next();
            if (PURPOSE_ID_ELEM.equals(member.getLocalName())) {
                try {
                    consentPurpose.setPurposeId(Integer.parseInt(member.getText()));
                    continue;
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("PurposeID should be an Integer. Found: " + member.getText() + " instead."));
                    throw new IdentityApplicationManagementException("Invalid purpose ID: " + member.getText(), e);
                }
            }
            if (!DISPLAY_ORDER_ELEM.equals(member.getLocalName())) continue;
            try {
                consentPurpose.setDisplayOrder(Integer.parseInt(member.getText()));
            }
            catch (NumberFormatException e) {
                log.warn((Object)("DisplayOrder should be an Integer. Found: " + member.getText() + " instead. Setting default display order: " + 0));
                consentPurpose.setDisplayOrder(0);
            }
        }
        return consentPurpose;
    }
}

