/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.identity.application.common.model.Claim;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="ClaimMapping")
public class ClaimMapping
implements Serializable {
    private static final long serialVersionUID = -5329129991600888989L;
    @XmlElement(name="LocalClaim")
    private Claim localClaim;
    @XmlElement(name="RemoteClaim")
    private Claim remoteClaim;
    @XmlElement(name="DefaultValue")
    private String defaultValue;
    @XmlElement(name="RequestClaim")
    private boolean requested;
    @XmlElement(name="MandatoryClaim")
    private boolean isMandatory;

    public static ClaimMapping build(String localClaimUri, String remoteClaimUri, String defaultValue, boolean requested) {
        ClaimMapping mapping = new ClaimMapping();
        Claim localClaim = new Claim();
        localClaim.setClaimUri(localClaimUri);
        Claim remoteClaim = new Claim();
        remoteClaim.setClaimUri(remoteClaimUri);
        mapping.setLocalClaim(localClaim);
        mapping.setRemoteClaim(remoteClaim);
        mapping.setDefaultValue(defaultValue);
        mapping.setRequested(requested);
        return mapping;
    }

    public static ClaimMapping build(String localClaimUri, String remoteClaimUri, String defaultValue, boolean requested, boolean isMandatory) {
        ClaimMapping mapping = new ClaimMapping();
        Claim localClaim = new Claim();
        localClaim.setClaimUri(localClaimUri);
        Claim remoteClaim = new Claim();
        remoteClaim.setClaimUri(remoteClaimUri);
        mapping.setLocalClaim(localClaim);
        mapping.setRemoteClaim(remoteClaim);
        mapping.setDefaultValue(defaultValue);
        mapping.setRequested(requested);
        mapping.setMandatory(isMandatory);
        return mapping;
    }

    public static ClaimMapping build(OMElement claimMappingOM) {
        ClaimMapping claimMapping = new ClaimMapping();
        Iterator iter = claimMappingOM.getChildElements();
        while (iter.hasNext()) {
            Claim claim;
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if ("LocalClaim".equals(elementName) && (claim = Claim.build(element)) != null) {
                claimMapping.setLocalClaim(claim);
            }
            if ("RemoteClaim".equals(elementName) && (claim = Claim.build(element)) != null) {
                claimMapping.setRemoteClaim(Claim.build(element));
            }
            if ("DefaultValue".equals(elementName)) {
                claimMapping.setDefaultValue(element.getText());
            }
            if ("RequestClaim".equals(elementName)) {
                claimMapping.setRequested(Boolean.parseBoolean(element.getText()));
            }
            if (!"MandatoryClaim".equals(elementName)) continue;
            claimMapping.setMandatory(Boolean.parseBoolean(element.getText()));
        }
        return claimMapping;
    }

    public Claim getLocalClaim() {
        return this.localClaim;
    }

    public void setLocalClaim(Claim localClaim) {
        this.localClaim = localClaim;
    }

    public Claim getRemoteClaim() {
        return this.remoteClaim;
    }

    public void setRemoteClaim(Claim remoteClaim) {
        this.remoteClaim = remoteClaim;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClaimMapping that = (ClaimMapping)o;
        if (this.remoteClaim != null ? !this.remoteClaim.equals(that.remoteClaim) : that.remoteClaim != null) {
            return false;
        }
        return !(this.localClaim != null ? !this.localClaim.equals(that.localClaim) : that.localClaim != null);
    }

    public int hashCode() {
        int result = this.localClaim != null ? this.localClaim.hashCode() : 0;
        result = 31 * result + (this.remoteClaim != null ? this.remoteClaim.hashCode() : 0);
        return result;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isRequested() {
        return this.requested;
    }

    public void setRequested(boolean requested) {
        this.requested = requested;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public void setMandatory(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }
}

