/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.wso2.carbon.identity.application.common.model.Claim;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="ClaimConfig")
public class ClaimConfig
implements Serializable {
    private static final long serialVersionUID = 94689128465184610L;
    @XmlElement(name="RoleClaimURI")
    private String roleClaimURI;
    @XmlElement(name="UserClaimURI")
    private String userClaimURI;
    @XmlElement(name="LocalClaimDialect")
    private boolean localClaimDialect;
    @XmlElementWrapper(name="IdpClaim")
    @XmlElement(name="Claims")
    private Claim[] idpClaims = new Claim[0];
    @XmlElementWrapper(name="ClaimMappings")
    @XmlElement(name="ClaimMapping")
    private ClaimMapping[] claimMappings = new ClaimMapping[0];
    @XmlElement(name="AlwaysSendMappedLocalSubjectId")
    private boolean alwaysSendMappedLocalSubjectId;
    @XmlElementWrapper(name="SPClaimDialects")
    @XmlElement(name="SPClaimDialect")
    private String[] spClaimDialects = null;

    public static ClaimConfig build(OMElement claimConfigOM) {
        ClaimConfig claimConfig = new ClaimConfig();
        Iterator iter = claimConfigOM.getChildElements();
        while (iter.hasNext()) {
            OMElement element = (OMElement)iter.next();
            String elementName = element.getLocalName();
            if ("RoleClaimURI".equals(elementName)) {
                claimConfig.setRoleClaimURI(element.getText());
                continue;
            }
            if ("LocalClaimDialect".equals(elementName)) {
                if (element.getText() == null) continue;
                claimConfig.setLocalClaimDialect(Boolean.parseBoolean(element.getText()));
                continue;
            }
            if ("UserClaimURI".equals(elementName)) {
                claimConfig.setUserClaimURI(element.getText());
                continue;
            }
            if ("AlwaysSendMappedLocalSubjectId".equals(elementName)) {
                if (!"true".equals(element.getText())) continue;
                claimConfig.setAlwaysSendMappedLocalSubjectId(true);
                continue;
            }
            if ("IdpClaims".equals(elementName)) {
                Iterator idpClaimsIter = element.getChildElements();
                ArrayList<Claim> idpClaimsArrList = new ArrayList<Claim>();
                if (idpClaimsIter != null) {
                    while (idpClaimsIter.hasNext()) {
                        OMElement idpClaimsElement = (OMElement)idpClaimsIter.next();
                        Claim claim = Claim.build(idpClaimsElement);
                        if (claim == null) continue;
                        idpClaimsArrList.add(claim);
                    }
                }
                if (!CollectionUtils.isNotEmpty(idpClaimsArrList)) continue;
                Claim[] idpClaimsArr = idpClaimsArrList.toArray(new Claim[0]);
                claimConfig.setIdpClaims(idpClaimsArr);
                continue;
            }
            if ("ClaimMappings".equals(elementName)) {
                Iterator claimMappingsIter = element.getChildElements();
                ArrayList<ClaimMapping> claimMappingsArrList = new ArrayList<ClaimMapping>();
                if (claimMappingsIter != null) {
                    while (claimMappingsIter.hasNext()) {
                        OMElement claimMappingsElement = (OMElement)claimMappingsIter.next();
                        ClaimMapping claimMapping = ClaimMapping.build(claimMappingsElement);
                        if (claimMapping == null) continue;
                        claimMappingsArrList.add(claimMapping);
                    }
                }
                if (!CollectionUtils.isNotEmpty(claimMappingsArrList)) continue;
                ClaimMapping[] claimMappingsArr = claimMappingsArrList.toArray(new ClaimMapping[0]);
                claimConfig.setClaimMappings(claimMappingsArr);
                continue;
            }
            if (!"SPClaimDialects".equals(elementName)) continue;
            Iterator spDialects = element.getChildElements();
            ArrayList<String> spDialectsArrList = new ArrayList<String>();
            while (spDialects.hasNext()) {
                OMElement spDialectElement = (OMElement)spDialects.next();
                if (spDialectElement.getText() == null) continue;
                spDialectsArrList.add(spDialectElement.getText());
            }
            if (!CollectionUtils.isNotEmpty(spDialectsArrList)) continue;
            String[] spDialectArr = spDialectsArrList.toArray(new String[0]);
            claimConfig.setSpClaimDialects(spDialectArr);
        }
        return claimConfig;
    }

    public String getRoleClaimURI() {
        return this.roleClaimURI;
    }

    public void setRoleClaimURI(String roleClaimURI) {
        this.roleClaimURI = roleClaimURI;
    }

    public ClaimMapping[] getClaimMappings() {
        return this.claimMappings;
    }

    public void setClaimMappings(ClaimMapping[] claimMappins) {
        this.claimMappings = claimMappins;
    }

    public String getUserClaimURI() {
        return this.userClaimURI;
    }

    public void setUserClaimURI(String userClaimURI) {
        this.userClaimURI = userClaimURI;
    }

    public Claim[] getIdpClaims() {
        return this.idpClaims;
    }

    public void setIdpClaims(Claim[] idpClaims) {
        this.idpClaims = idpClaims;
    }

    public boolean isLocalClaimDialect() {
        return this.localClaimDialect;
    }

    public void setLocalClaimDialect(boolean localClaimDialect) {
        this.localClaimDialect = localClaimDialect;
    }

    public boolean isAlwaysSendMappedLocalSubjectId() {
        return this.alwaysSendMappedLocalSubjectId;
    }

    public void setAlwaysSendMappedLocalSubjectId(boolean alwaysSendMappedLocalSubjectId) {
        this.alwaysSendMappedLocalSubjectId = alwaysSendMappedLocalSubjectId;
    }

    public String[] getSpClaimDialects() {
        return this.spClaimDialects;
    }

    public void setSpClaimDialects(String[] spClaimDialects) {
        this.spClaimDialects = this.spClaimDialects == null ? spClaimDialects : (String[])ArrayUtils.addAll((Object[])this.spClaimDialects, (Object[])spClaimDialects);
    }
}

