/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.LocalAuthenticatorConfig;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="AuthenticationStep")
public class AuthenticationStep
implements Serializable {
    private static final long serialVersionUID = 497647508006862448L;
    @XmlElement(name="StepOrder")
    private int stepOrder = 1;
    @XmlElementWrapper(name="LocalAuthenticatorConfigs")
    @XmlElement(name="LocalAuthenticatorConfig")
    private LocalAuthenticatorConfig[] localAuthenticatorConfigs = new LocalAuthenticatorConfig[0];
    @XmlElementWrapper(name="FederatedIdentityProviders")
    @XmlElement(name="FederatedIdentityProvider")
    private IdentityProvider[] federatedIdentityProviders = new IdentityProvider[0];
    @XmlElement(name="SubjectStep")
    private boolean subjectStep;
    @XmlElement(name="AttributeStep")
    private boolean attributeStep;

    public static AuthenticationStep build(OMElement authenticationStepOM) {
        AuthenticationStep authenticationStep = new AuthenticationStep();
        Iterator iter = authenticationStepOM.getChildElements();
        while (iter.hasNext()) {
            OMElement member = (OMElement)iter.next();
            if ("StepOrder".equals(member.getLocalName())) {
                authenticationStep.setStepOrder(Integer.parseInt(member.getText()));
                continue;
            }
            if ("SubjectStep".equals(member.getLocalName())) {
                if (member.getText() == null || member.getText().trim().length() <= 0) continue;
                authenticationStep.setSubjectStep(Boolean.parseBoolean(member.getText()));
                continue;
            }
            if ("AttributeStep".equals(member.getLocalName())) {
                if (member.getText() == null || member.getText().trim().length() <= 0) continue;
                authenticationStep.setAttributeStep(Boolean.parseBoolean(member.getText()));
                continue;
            }
            if ("FederatedIdentityProviders".equals(member.getLocalName())) {
                Iterator federatedIdentityProvidersIter = member.getChildElements();
                ArrayList<IdentityProvider> federatedIdentityProvidersArrList = new ArrayList<IdentityProvider>();
                if (federatedIdentityProvidersIter != null) {
                    while (federatedIdentityProvidersIter.hasNext()) {
                        OMElement federatedIdentityProvidersElement = (OMElement)federatedIdentityProvidersIter.next();
                        IdentityProvider idp = IdentityProvider.build(federatedIdentityProvidersElement);
                        if (idp == null) continue;
                        federatedIdentityProvidersArrList.add(idp);
                    }
                }
                if (!CollectionUtils.isNotEmpty(federatedIdentityProvidersArrList)) continue;
                IdentityProvider[] federatedAuthenticatorConfigsArr = federatedIdentityProvidersArrList.toArray(new IdentityProvider[0]);
                authenticationStep.setFederatedIdentityProviders(federatedAuthenticatorConfigsArr);
                continue;
            }
            if (!"LocalAuthenticatorConfigs".equals(member.getLocalName())) continue;
            Iterator localAuthenticatorConfigsIter = member.getChildElements();
            ArrayList<LocalAuthenticatorConfig> localAuthenticatorConfigsArrList = new ArrayList<LocalAuthenticatorConfig>();
            if (localAuthenticatorConfigsIter != null) {
                while (localAuthenticatorConfigsIter.hasNext()) {
                    OMElement localAuthenticatorConfigsElement = (OMElement)localAuthenticatorConfigsIter.next();
                    LocalAuthenticatorConfig localAuthConfig = LocalAuthenticatorConfig.build(localAuthenticatorConfigsElement);
                    if (localAuthConfig == null) continue;
                    localAuthenticatorConfigsArrList.add(localAuthConfig);
                }
            }
            if (!CollectionUtils.isNotEmpty(localAuthenticatorConfigsArrList)) continue;
            LocalAuthenticatorConfig[] localAuthenticatorConfigsArr = localAuthenticatorConfigsArrList.toArray(new LocalAuthenticatorConfig[0]);
            authenticationStep.setLocalAuthenticatorConfigs(localAuthenticatorConfigsArr);
        }
        return authenticationStep;
    }

    public int getStepOrder() {
        return this.stepOrder;
    }

    public void setStepOrder(int stepOrder) {
        this.stepOrder = stepOrder;
    }

    public LocalAuthenticatorConfig[] getLocalAuthenticatorConfigs() {
        return this.localAuthenticatorConfigs;
    }

    public void setLocalAuthenticatorConfigs(LocalAuthenticatorConfig[] localAuthenticatorConfigs) {
        if (localAuthenticatorConfigs == null) {
            return;
        }
        HashSet<LocalAuthenticatorConfig> propertySet = new HashSet<LocalAuthenticatorConfig>(Arrays.asList(localAuthenticatorConfigs));
        this.localAuthenticatorConfigs = propertySet.toArray(new LocalAuthenticatorConfig[propertySet.size()]);
    }

    public IdentityProvider[] getFederatedIdentityProviders() {
        return this.federatedIdentityProviders;
    }

    public void setFederatedIdentityProviders(IdentityProvider[] federatedIdentityProviders) {
        if (federatedIdentityProviders == null) {
            return;
        }
        HashSet<IdentityProvider> propertySet = new HashSet<IdentityProvider>(Arrays.asList(federatedIdentityProviders));
        this.federatedIdentityProviders = propertySet.toArray(new IdentityProvider[propertySet.size()]);
    }

    public boolean isSubjectStep() {
        return this.subjectStep;
    }

    public void setSubjectStep(boolean subjectStep) {
        this.subjectStep = subjectStep;
    }

    public boolean isAttributeStep() {
        return this.attributeStep;
    }

    public void setAttributeStep(boolean attributeStep) {
        this.attributeStep = attributeStep;
    }
}

