/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.event.CacheEntryListener;
import org.wso2.carbon.caching.impl.CacheImpl;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.common.listener.AbstractCacheListener;
import org.wso2.carbon.identity.core.model.IdentityCacheConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class BaseCache<K extends Serializable, V extends Serializable> {
    private static final String CACHE_MANAGER_NAME = "IdentityApplicationManagementCacheManager";
    private CacheBuilder<K, V> cacheBuilder;
    private String cacheName;
    private List<AbstractCacheListener> cacheListeners = new ArrayList<AbstractCacheListener>();
    private IdentityCacheConfig identityCacheConfig;

    public BaseCache(String cacheName) {
        this.cacheName = cacheName;
        this.identityCacheConfig = IdentityUtil.getIdentityCacheConfig((String)CACHE_MANAGER_NAME, (String)cacheName);
        if (this.identityCacheConfig != null && !this.identityCacheConfig.isDistributed()) {
            this.cacheName = "$__local__$." + cacheName;
        }
    }

    public BaseCache(String cacheName, boolean isTemp) {
        this.cacheName = cacheName;
        this.identityCacheConfig = IdentityUtil.getIdentityCacheConfig((String)CACHE_MANAGER_NAME, (String)cacheName);
        if (this.identityCacheConfig != null) {
            if (!this.identityCacheConfig.isDistributed()) {
                this.cacheName = "$__local__$." + cacheName;
            }
            this.identityCacheConfig.setTemporary(isTemp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<K, V> getBaseCache() {
        Cache cache;
        block10: {
            cache = null;
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantId(-1234);
                carbonContext.setTenantDomain("carbon.super");
                CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(CACHE_MANAGER_NAME);
                if (this.getCacheTimeout() > 0 && this.cacheBuilder == null) {
                    String string = this.cacheName.intern();
                    synchronized (string) {
                        if (this.cacheBuilder == null) {
                            cacheManager.removeCache(this.cacheName);
                            this.cacheBuilder = cacheManager.createCacheBuilder(this.cacheName).setExpiry(CacheConfiguration.ExpiryType.ACCESSED, new CacheConfiguration.Duration(TimeUnit.SECONDS, (long)this.getCacheTimeout())).setExpiry(CacheConfiguration.ExpiryType.MODIFIED, new CacheConfiguration.Duration(TimeUnit.SECONDS, (long)this.getCacheTimeout())).setStoreByValue(false);
                            cache = this.cacheBuilder.build();
                            for (AbstractCacheListener cacheListener : this.cacheListeners) {
                                if (!cacheListener.isEnable()) continue;
                                this.cacheBuilder.registerCacheEntryListener((CacheEntryListener)cacheListener);
                            }
                            this.setCapacity((CacheImpl)cache);
                        } else {
                            cache = cacheManager.getCache(this.cacheName);
                            this.setCapacity((CacheImpl)cache);
                        }
                        break block10;
                    }
                }
                cache = cacheManager.getCache(this.cacheName);
                this.setCapacity((CacheImpl)cache);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(K key, V entry) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            Cache<K, V> cache = this.getBaseCache();
            if (cache != null) {
                cache.put(key, entry);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getValueFromCache(K key) {
        if (!this.isEnabled()) {
            return null;
        }
        if (key == null) {
            return null;
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            Cache<K, V> cache = this.getBaseCache();
            if (cache != null && cache.get(key) != null) {
                Serializable serializable = (Serializable)cache.get(key);
                return (V)serializable;
            }
            V v = null;
            return v;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheEntry(K key) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            Cache<K, V> cache = this.getBaseCache();
            if (cache != null) {
                cache.remove(key);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void clear() {
        if (!this.isEnabled()) {
            return;
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(-1234);
            carbonContext.setTenantDomain("carbon.super");
            Cache<K, V> cache = this.getBaseCache();
            if (cache != null) {
                cache.removeAll();
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void addListener(AbstractCacheListener listener) {
        this.cacheListeners.add(listener);
    }

    public boolean isEnabled() {
        if (this.identityCacheConfig != null) {
            return this.identityCacheConfig.isEnabled();
        }
        return true;
    }

    public int getCacheTimeout() {
        if (this.identityCacheConfig != null && this.identityCacheConfig.getTimeout() > 0) {
            return this.identityCacheConfig.getTimeout();
        }
        return -1;
    }

    public int getCapacity() {
        if (this.identityCacheConfig != null && this.identityCacheConfig.getCapacity() > 0) {
            return this.identityCacheConfig.getCapacity();
        }
        return -1;
    }

    public void setCapacity(CacheImpl cache) {
        if (this.getCapacity() > 0) {
            cache.setCapacity((long)this.getCapacity());
        }
    }
}

