/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common;

import java.util.Arrays;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementClientException;

public class IdentityApplicationManagementValidationException
extends IdentityApplicationManagementClientException {
    private static final long serialVersionUID = 546145354402013968L;
    private static final String DEFAULT_ERROR_MESSAGE = "Error validating application configurations.";
    private String[] validationMsg;

    public IdentityApplicationManagementValidationException(String code, String[] validationMsg) {
        super(code, DEFAULT_ERROR_MESSAGE);
        this.validationMsg = validationMsg;
    }

    public IdentityApplicationManagementValidationException(String code, String message, String[] validationMsg) {
        super(code, message);
        this.validationMsg = validationMsg;
    }

    public IdentityApplicationManagementValidationException(String[] validationMsg) {
        super(DEFAULT_ERROR_MESSAGE);
        this.validationMsg = validationMsg;
    }

    public String[] getValidationMsg() {
        return this.validationMsg;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder(super.getMessage());
        if (this.validationMsg != null && this.validationMsg.length > 0) {
            Arrays.stream(this.validationMsg).forEach(message -> builder.append(" ").append((String)message));
        }
        return builder.toString();
    }
}

