/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.common;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.RequestPathAuthenticatorConfig;

public class ApplicationAuthenticatorService {
    private static volatile ApplicationAuthenticatorService instance;
    private List<LocalAuthenticatorConfig> localAuthenticators = new ArrayList<LocalAuthenticatorConfig>();
    private List<FederatedAuthenticatorConfig> federatedAuthenticators = new ArrayList<FederatedAuthenticatorConfig>();
    private List<RequestPathAuthenticatorConfig> requestPathAuthenticators = new ArrayList<RequestPathAuthenticatorConfig>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationAuthenticatorService getInstance() {
        if (instance != null) return instance;
        Class<ApplicationAuthenticatorService> clazz = ApplicationAuthenticatorService.class;
        synchronized (ApplicationAuthenticatorService.class) {
            if (instance != null) return instance;
            instance = new ApplicationAuthenticatorService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<LocalAuthenticatorConfig> getLocalAuthenticators() {
        return this.localAuthenticators;
    }

    public List<FederatedAuthenticatorConfig> getFederatedAuthenticators() {
        return this.federatedAuthenticators;
    }

    public List<RequestPathAuthenticatorConfig> getRequestPathAuthenticators() {
        return this.requestPathAuthenticators;
    }

    public LocalAuthenticatorConfig getLocalAuthenticatorByName(String name) {
        for (LocalAuthenticatorConfig localAuthenticator : this.localAuthenticators) {
            if (!localAuthenticator.getName().equals(name)) continue;
            return localAuthenticator;
        }
        return null;
    }

    public FederatedAuthenticatorConfig getFederatedAuthenticatorByName(String name) {
        for (FederatedAuthenticatorConfig federatedAuthenticator : this.federatedAuthenticators) {
            if (!federatedAuthenticator.getName().equals(name)) continue;
            return federatedAuthenticator;
        }
        return null;
    }

    public RequestPathAuthenticatorConfig getRequestPathAuthenticatorByName(String name) {
        for (RequestPathAuthenticatorConfig reqPathAuthenticator : this.requestPathAuthenticators) {
            if (!reqPathAuthenticator.getName().equals(name)) continue;
            return reqPathAuthenticator;
        }
        return null;
    }

    public void addLocalAuthenticator(LocalAuthenticatorConfig authenticator) {
        if (authenticator != null) {
            this.localAuthenticators.add(authenticator);
        }
    }

    public void removeLocalAuthenticator(LocalAuthenticatorConfig authenticator) {
        if (authenticator != null) {
            this.localAuthenticators.remove(authenticator);
        }
    }

    public void addFederatedAuthenticator(FederatedAuthenticatorConfig authenticator) {
        if (authenticator != null) {
            this.federatedAuthenticators.add(authenticator);
        }
    }

    public void removeFederatedAuthenticator(FederatedAuthenticatorConfig authenticator) {
        if (authenticator != null) {
            this.federatedAuthenticators.remove(authenticator);
        }
    }

    public void addRequestPathAuthenticator(RequestPathAuthenticatorConfig authenticator) {
        if (authenticator != null) {
            this.requestPathAuthenticators.add(authenticator);
        }
    }

    public void removeRequestPathAuthenticator(RequestPathAuthenticatorConfig authenticator) {
        if (authenticator != null) {
            this.requestPathAuthenticators.remove(authenticator);
        }
    }
}

