/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.application.deployer.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.Feature;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.event.application.deployer.EventProcessingAppDeployer;

@Component(name="event.processing.application.deployer", immediate=true)
public class EventProcessingAppDeployerDS {
    private static Log log = LogFactory.getLog(EventProcessingAppDeployerDS.class);
    private static Map<String, List<Feature>> requiredFeatures;
    private static ServiceRegistration appHandlerRegistration;

    public static Map<String, List<Feature>> getRequiredFeatures() {
        return requiredFeatures;
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            EventProcessingAppDeployer cepDeployer = new EventProcessingAppDeployer();
            appHandlerRegistration = ctxt.getBundleContext().registerService(AppDeploymentHandler.class.getName(), (Object)cepDeployer, null);
            URL reqFeaturesResource = ctxt.getBundleContext().getBundle().getResource("required-features.xml");
            if (reqFeaturesResource != null) {
                InputStream xmlStream = reqFeaturesResource.openStream();
                requiredFeatures = AppDeployerUtils.readRequiredFeaturs((OMElement)new StAXOMBuilder(xmlStream).getDocumentElement());
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate EventProcessing Application Deployer", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (appHandlerRegistration != null) {
            appHandlerRegistration.unregister();
        }
    }
}

