/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.application.deployer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.event.application.deployer.EventProcessingDeployer;
import org.wso2.carbon.event.application.deployer.internal.EventProcessingAppDeployerDS;

public class EventProcessingAppDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(EventProcessingAppDeployer.class);
    private Map<String, Boolean> acceptanceList = null;
    private List<Artifact> executionPlans = new ArrayList<Artifact>();
    private List<Artifact> eventStreams = new ArrayList<Artifact>();
    private List<Artifact> eventReceivers = new ArrayList<Artifact>();
    private List<Artifact> eventPublishers = new ArrayList<Artifact>();

    public void deployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) throws DeploymentException {
        List artifacts = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            if (!this.validateArtifact(artifact)) continue;
            this.addArtifact(artifact);
        }
        try {
            this.deployTypeSpecifiedArtifacts(this.eventStreams, axisConfig, "eventstreams", "json");
            this.deployTypeSpecifiedArtifacts(this.eventReceivers, axisConfig, "eventreceivers", "xml");
            this.deployTypeSpecifiedArtifacts(this.eventPublishers, axisConfig, "eventpublishers", "xml");
            this.deployTypeSpecifiedArtifacts(this.executionPlans, axisConfig, "executionplans", "siddhiql");
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.executionPlans.clear();
            this.eventStreams.clear();
            this.eventReceivers.clear();
            this.eventPublishers.clear();
        }
    }

    private void deployTypeSpecifiedArtifacts(List<Artifact> artifacts, AxisConfiguration axisConfig, String directory, String fileType) throws DeploymentException {
        for (Artifact artifact : artifacts) {
            EventProcessingDeployer deployer = (EventProcessingDeployer)AppDeployerUtils.getArtifactDeployer((AxisConfiguration)axisConfig, (String)directory, (String)fileType);
            if (deployer == null) continue;
            this.deploy(deployer, artifact);
        }
    }

    void deploy(EventProcessingDeployer deployer, Artifact artifact) throws DeploymentException {
        String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
        String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
        try {
            deployer.processDeployment(new DeploymentFileData(new File(artifactPath), (Deployer)deployer));
            artifact.setDeploymentStatus("Deployed");
        }
        catch (Exception e) {
            artifact.setDeploymentStatus("Failed");
            log.error((Object)("Deployment is failed due to " + e.getMessage()), (Throwable)e);
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    private void addArtifact(Artifact artifact) {
        if ("event/receiver".equals(artifact.getType())) {
            this.eventReceivers.add(artifact);
        } else if ("event/publisher".equals(artifact.getType())) {
            this.eventPublishers.add(artifact);
        } else if ("event/execution-plan".equals(artifact.getType())) {
            this.executionPlans.add(artifact);
        } else if ("event/stream".equals(artifact.getType())) {
            this.eventStreams.add(artifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) throws DeploymentException {
        List artifacts = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        this.executionPlans.clear();
        this.eventStreams.clear();
        this.eventReceivers.clear();
        this.eventPublishers.clear();
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            if (!this.validateArtifact(artifact)) continue;
            this.addArtifact(artifact);
        }
        try {
            this.undeployTypeSpecifiedArtifacts(this.eventStreams, axisConfig, "eventstreams", "json");
            this.undeployTypeSpecifiedArtifacts(this.eventReceivers, axisConfig, "eventreceivers", "xml");
            this.undeployTypeSpecifiedArtifacts(this.eventPublishers, axisConfig, "eventpublishers", "xml");
            this.undeployTypeSpecifiedArtifacts(this.executionPlans, axisConfig, "executionplans", "siddhiql");
        }
        finally {
            this.executionPlans.clear();
            this.eventStreams.clear();
            this.eventReceivers.clear();
            this.eventPublishers.clear();
        }
    }

    private void undeployTypeSpecifiedArtifacts(List<Artifact> artifacts, AxisConfiguration axisConfig, String directory, String fileType) throws DeploymentException {
        for (Artifact artifact : artifacts) {
            EventProcessingDeployer deployer = (EventProcessingDeployer)AppDeployerUtils.getArtifactDeployer((AxisConfiguration)axisConfig, (String)directory, (String)fileType);
            if (deployer == null || !"Deployed".equals(artifact.getDeploymentStatus())) continue;
            this.undeploy(deployer, artifact);
        }
    }

    private void undeploy(EventProcessingDeployer deployer, Artifact artifact) throws DeploymentException {
        String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
        String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
        try {
            deployer.processUndeployment(new DeploymentFileData(new File(artifactPath), (Deployer)deployer).getAbsolutePath());
            artifact.setDeploymentStatus("Pending");
        }
        catch (Exception e) {
            artifact.setDeploymentStatus("Failed");
            log.error((Object)("Undeployment is failed due to " + e.getMessage()), (Throwable)e);
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    private EventProcessingDeployer getDeployer(Artifact artifact, AxisConfiguration axisConfig) {
        Object deployer = "event/receiver".equals(artifact.getType()) ? AppDeployerUtils.getArtifactDeployer((AxisConfiguration)axisConfig, (String)"eventreceivers", (String)"xml") : ("event/publisher".equals(artifact.getType()) ? AppDeployerUtils.getArtifactDeployer((AxisConfiguration)axisConfig, (String)"eventpublishers", (String)"xml") : ("event/execution-plan".equals(artifact.getType()) ? AppDeployerUtils.getArtifactDeployer((AxisConfiguration)axisConfig, (String)"executionplans", (String)"xml") : ("event/stream".equals(artifact.getType()) ? AppDeployerUtils.getArtifactDeployer((AxisConfiguration)axisConfig, (String)"eventstreams", (String)"json") : null)));
        return (EventProcessingDeployer)deployer;
    }

    private boolean isAccepted(String serviceType) {
        if (this.acceptanceList == null) {
            this.acceptanceList = AppDeployerUtils.buildAcceptanceList(EventProcessingAppDeployerDS.getRequiredFeatures());
        }
        Boolean acceptance = this.acceptanceList.get(serviceType);
        return Boolean.TRUE.equals(acceptance);
    }

    private boolean validateArtifact(Artifact artifact) {
        if (artifact == null) {
            return false;
        }
        if (this.isAccepted(artifact.getType())) {
            List files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)("Synapse artifact types must have a single file to be deployed. But " + files.size() + " files found."));
                return false;
            }
            return true;
        }
        return false;
    }
}

