/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.keycloak.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.AccessTokenRequest;
import org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration;
import org.wso2.carbon.apimgt.api.model.OAuthAppRequest;
import org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager;
import org.wso2.carbon.apimgt.impl.kmclient.FormEncoder;
import org.wso2.carbon.apimgt.impl.recommendationmgt.AccessTokenGenerator;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.keycloak.client.BearerInterceptor;
import org.wso2.keycloak.client.model.AccessTokenInfo;
import org.wso2.keycloak.client.model.ClientInfo;
import org.wso2.keycloak.client.model.DCRClient;
import org.wso2.keycloak.client.model.IntrospectInfo;
import org.wso2.keycloak.client.model.IntrospectionClient;

public class KeycloakClient
extends AbstractKeyManager {
    private static final Log log = LogFactory.getLog(KeycloakClient.class);
    private DCRClient dcrClient;
    private IntrospectionClient introspectionClient;

    public void loadConfiguration(KeyManagerConfiguration keyManagerConfiguration) throws APIManagementException {
        this.configuration = keyManagerConfiguration;
        String clientRegistrationEndpoint = (String)this.configuration.getParameter("client_registration_endpoint");
        String clientId = (String)this.configuration.getParameter("client_id");
        String clientSecret = (String)this.configuration.getParameter("client_secret");
        BasicAuthRequestInterceptor basicAuthRequestInterceptor = new BasicAuthRequestInterceptor(clientId, clientSecret);
        String tokenEndpoint = (String)this.configuration.getParameter("token_endpoint");
        String revokeEndpoint = (String)this.configuration.getParameter("revoke_endpoint");
        Gson gson = new GsonBuilder().serializeNulls().create();
        if (!(StringUtils.isNotEmpty((String)clientId) && StringUtils.isNotEmpty((String)clientSecret) && StringUtils.isNotEmpty((String)tokenEndpoint) && StringUtils.isNotEmpty((String)revokeEndpoint))) {
            throw new APIManagementException("Error while configuring Keycloak Connector");
        }
        AccessTokenGenerator accessTokenGenerator = new AccessTokenGenerator(tokenEndpoint, revokeEndpoint, clientId, clientSecret);
        this.dcrClient = (DCRClient)Feign.builder().client((Client)new OkHttpClient()).decoder((Decoder)new GsonDecoder(gson)).encoder((Encoder)new GsonEncoder(gson)).requestInterceptor((RequestInterceptor)new BearerInterceptor(accessTokenGenerator)).target(DCRClient.class, clientRegistrationEndpoint);
        String introspectEndpoint = (String)this.configuration.getParameter("introspection_endpoint");
        this.introspectionClient = (IntrospectionClient)Feign.builder().client((Client)new OkHttpClient()).encoder((Encoder)new GsonEncoder(gson)).decoder((Decoder)new GsonDecoder(gson)).logger((Logger)new Slf4jLogger()).requestInterceptor((RequestInterceptor)basicAuthRequestInterceptor).encoder((Encoder)new FormEncoder()).target(IntrospectionClient.class, introspectEndpoint);
    }

    public OAuthApplicationInfo createApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        ClientInfo clientInfoFromOauthApplicationInfo;
        ClientInfo createdApplication;
        OAuthApplicationInfo oAuthApplicationInfo = oAuthAppRequest.getOAuthApplicationInfo();
        if (oAuthApplicationInfo != null && (createdApplication = this.dcrClient.createApplication(clientInfoFromOauthApplicationInfo = this.createClientInfoFromOauthApplicationInfo(oAuthApplicationInfo))) != null) {
            oAuthApplicationInfo = this.createOAuthAppInfoFromResponse(createdApplication);
            return oAuthApplicationInfo;
        }
        return null;
    }

    public OAuthApplicationInfo updateApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        OAuthApplicationInfo oAuthApplicationInfo = oAuthAppRequest.getOAuthApplicationInfo();
        if (oAuthApplicationInfo != null) {
            ClientInfo clientInfoFromOauthApplicationInfo;
            ClientInfo clientInfo;
            String clientId = oAuthApplicationInfo.getClientId();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Updating an OAuth client in Keycloak authorization server for the Consumer Key %s", clientId));
            }
            if ((clientInfo = this.dcrClient.updateApplication(clientId, clientInfoFromOauthApplicationInfo = this.createClientInfoFromOauthApplicationInfo(oAuthApplicationInfo))) != null) {
                oAuthApplicationInfo = this.createOAuthAppInfoFromResponse(clientInfo);
                return oAuthApplicationInfo;
            }
        }
        return null;
    }

    public void deleteApplication(String clientId) throws APIManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting an OAuth client in Keycloak authorization server for the Consumer Key: %s", clientId));
        }
        this.dcrClient.deleteApplication(clientId);
    }

    public OAuthApplicationInfo retrieveApplication(String clientId) throws APIManagementException {
        if (StringUtils.isNotEmpty((String)clientId)) {
            ClientInfo application = this.dcrClient.getApplication(clientId);
            return this.createOAuthAppInfoFromResponse(application);
        }
        return null;
    }

    public org.wso2.carbon.apimgt.api.model.AccessTokenInfo getNewApplicationAccessToken(AccessTokenRequest accessTokenRequest) throws APIManagementException {
        AccessTokenInfo retrievedAccessTokenInfo;
        String clientId = accessTokenRequest.getClientId();
        String clientSecret = accessTokenRequest.getClientSecret();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Get new client access token from authorization server for the Consumer Key %s", clientId));
        }
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        String grantType = accessTokenRequest.getGrantType();
        if (grantType == null) {
            grantType = "client_credentials";
        }
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", grantType));
        String scopeString = KeycloakClient.convertToString(accessTokenRequest.getScope());
        if (!StringUtils.isEmpty((String)scopeString)) {
            parameters.add((NameValuePair)new BasicNameValuePair("scope", scopeString));
        }
        if ((retrievedAccessTokenInfo = this.getAccessToken(clientId, clientSecret, parameters)) != null) {
            org.wso2.carbon.apimgt.api.model.AccessTokenInfo accessTokenInfo = new org.wso2.carbon.apimgt.api.model.AccessTokenInfo();
            accessTokenInfo.setConsumerKey(clientId);
            accessTokenInfo.setConsumerSecret(clientSecret);
            accessTokenInfo.setAccessToken(retrievedAccessTokenInfo.getAccessToken());
            accessTokenInfo.setScope(retrievedAccessTokenInfo.getScope().split("\\s+"));
            accessTokenInfo.setValidityPeriod(retrievedAccessTokenInfo.getExpiry());
            return accessTokenInfo;
        }
        return null;
    }

    public String getNewApplicationConsumerSecret(AccessTokenRequest accessTokenRequest) throws APIManagementException {
        return null;
    }

    public org.wso2.carbon.apimgt.api.model.AccessTokenInfo getTokenMetaData(String accessToken) throws APIManagementException {
        org.wso2.carbon.apimgt.api.model.AccessTokenInfo tokenInfo = new org.wso2.carbon.apimgt.api.model.AccessTokenInfo();
        IntrospectInfo introspectInfo = this.introspectionClient.introspect(accessToken, "requesting_party_token");
        if (introspectInfo != null) {
            tokenInfo.setAccessToken(accessToken);
            tokenInfo.setTokenValid(introspectInfo.isActive());
            tokenInfo.setIssuedTime(introspectInfo.getIssuedAt());
            tokenInfo.setValidityPeriod(introspectInfo.getExpiryTime() - introspectInfo.getIssuedAt());
            tokenInfo.setEndUserName(introspectInfo.getUsername());
            tokenInfo.setConsumerKey(introspectInfo.getConsumerKey());
            if (StringUtils.isNotEmpty((String)introspectInfo.getScope())) {
                tokenInfo.setScope(introspectInfo.getScope().split("\\s+"));
            }
            tokenInfo.addParameter("iss", (Object)introspectInfo.getIssuer());
            tokenInfo.addParameter("jti", (Object)introspectInfo.getJti());
        }
        return tokenInfo;
    }

    public AccessTokenRequest buildAccessTokenRequestFromOAuthApp(OAuthApplicationInfo oAuthApplication, AccessTokenRequest tokenRequest) throws APIManagementException {
        Object grantType;
        if (oAuthApplication == null) {
            return tokenRequest;
        }
        if (tokenRequest == null) {
            tokenRequest = new AccessTokenRequest();
        }
        String clientName = oAuthApplication.getClientName();
        if (oAuthApplication.getClientId() == null) {
            throw new APIManagementException(String.format("Consumer key is missing for the Application: %s", clientName));
        }
        if (oAuthApplication.getClientSecret() == null) {
            log.error((Object)String.format("Consumer Secret is missing for the Application: %s", clientName));
        }
        tokenRequest.setClientId(oAuthApplication.getClientId());
        tokenRequest.setClientSecret(oAuthApplication.getClientSecret());
        if (oAuthApplication.getParameter("tokenScope") != null) {
            Object[] tokenScopes = null;
            if (oAuthApplication.getParameter("tokenScope") instanceof String[]) {
                tokenScopes = (String[])oAuthApplication.getParameter("tokenScope");
            }
            if (oAuthApplication.getParameter("tokenScope") instanceof String) {
                tokenScopes = oAuthApplication.getParameter("tokenScope").toString().split(",");
            }
            tokenRequest.setScope((String[])tokenScopes);
            oAuthApplication.addParameter("tokenScope", (Object)Arrays.toString(tokenScopes));
        }
        if (oAuthApplication.getParameter("validityPeriod") != null) {
            tokenRequest.setValidityPeriod(Long.parseLong((String)oAuthApplication.getParameter("validityPeriod")));
        }
        if ((grantType = oAuthApplication.getParameter("tokenGrantType")) != null) {
            tokenRequest.setGrantType((String)grantType);
        }
        return tokenRequest;
    }

    public KeyManagerConfiguration getKeyManagerConfiguration() throws APIManagementException {
        return this.configuration;
    }

    public OAuthApplicationInfo buildFromJSON(String s) throws APIManagementException {
        return null;
    }

    public OAuthApplicationInfo mapOAuthApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        String consumerKey = oAuthAppRequest.getOAuthApplicationInfo().getClientId();
        String consumerSecret = oAuthAppRequest.getOAuthApplicationInfo().getClientSecret();
        if (StringUtils.isNotBlank((String)consumerKey)) {
            OAuthApplicationInfo clientInfo = this.retrieveApplication(consumerKey);
            if (clientInfo == null) {
                KeycloakClient.handleException("Something went wrong while getting OAuth application for given consumer key " + consumerKey);
            }
            if (StringUtils.isNotBlank((String)consumerSecret) && !consumerSecret.equals(clientInfo.getClientSecret())) {
                throw new APIManagementException("The secret key is wrong for the given consumer key " + consumerKey);
            }
            return oAuthAppRequest.getOAuthApplicationInfo();
        }
        throw new APIManagementException("Consumer credentials are blank");
    }

    public boolean registerNewResource(API api, Map map) throws APIManagementException {
        return true;
    }

    public Map getResourceByApiId(String s) throws APIManagementException {
        return null;
    }

    public boolean updateRegisteredResource(API api, Map map) throws APIManagementException {
        return true;
    }

    public void deleteRegisteredResourceByAPIId(String s) throws APIManagementException {
    }

    public void deleteMappedApplication(String s) throws APIManagementException {
    }

    public Set<String> getActiveTokensByConsumerKey(String s) throws APIManagementException {
        return Collections.emptySet();
    }

    public org.wso2.carbon.apimgt.api.model.AccessTokenInfo getAccessTokenByConsumerKey(String s) throws APIManagementException {
        return null;
    }

    public Map<String, Set<Scope>> getScopesForAPIS(String s) throws APIManagementException {
        return null;
    }

    public void registerScope(Scope scope) throws APIManagementException {
    }

    public Scope getScopeByName(String s) throws APIManagementException {
        return null;
    }

    public Map<String, Scope> getAllScopes() throws APIManagementException {
        return null;
    }

    public void attachResourceScopes(API api, Set<URITemplate> uriTemplates) throws APIManagementException {
    }

    public void updateResourceScopes(API api, Set<String> oldLocalScopeKeys, Set<Scope> newLocalScopes, Set<URITemplate> oldURITemplates, Set<URITemplate> newURITemplates) throws APIManagementException {
    }

    public void detachResourceScopes(API api, Set<URITemplate> uriTemplates) throws APIManagementException {
    }

    public void deleteScope(String s) throws APIManagementException {
    }

    public void updateScope(Scope scope) throws APIManagementException {
    }

    public boolean isScopeExists(String s) throws APIManagementException {
        return false;
    }

    public void validateScopes(Set<Scope> scopes) throws APIManagementException {
    }

    public String getType() {
        return "KeyCloak";
    }

    private OAuthApplicationInfo createOAuthAppInfoFromResponse(ClientInfo clientInfo) {
        OAuthApplicationInfo appInfo = new OAuthApplicationInfo();
        appInfo.setClientName(clientInfo.getClientName());
        appInfo.setClientId(clientInfo.getClientId());
        appInfo.setClientSecret(clientInfo.getClientSecret());
        appInfo.addParameter("client_name", (Object)clientInfo.getClientName());
        if (clientInfo.getCallBackUrls() != null) {
            appInfo.setCallBackURL(String.join((CharSequence)",", clientInfo.getCallBackUrls()));
        }
        if (clientInfo.getGrantTypes() != null) {
            appInfo.addParameter("grant_types", (Object)String.join((CharSequence)" ", clientInfo.getGrantTypes()));
        }
        String additionalProperties = new Gson().toJson((Object)clientInfo);
        appInfo.addParameter("additionalProperties", new Gson().fromJson(additionalProperties, Map.class));
        return appInfo;
    }

    private static String convertToString(String[] stringArray) {
        if (stringArray != null) {
            StringBuilder sb = new StringBuilder();
            List<String> strList = Arrays.asList(stringArray);
            for (String s : strList) {
                sb.append(s);
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        return null;
    }

    private static void handleException(String msg) throws APIManagementException {
        log.error((Object)msg);
        throw new APIManagementException(msg);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private AccessTokenInfo getAccessToken(String clientId, String clientSecret, List<NameValuePair> parameters) throws APIManagementException {
        block33: {
            try {
                Throwable throwable = null;
                try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
                    String tokenEndpoint = (String)this.configuration.getParameter("token_endpoint");
                    HttpPost httpPost = new HttpPost(tokenEndpoint);
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
                    String encodedCredentials = KeycloakClient.getEncodedCredentials(clientId, clientSecret);
                    httpPost.setHeader("Authorization", "Basic " + encodedCredentials);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Invoking HTTP request to get the accesstoken.");
                    }
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    int statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        KeycloakClient.handleException(String.format("%s %s", "Could not read http entity for response", response));
                    }
                    if (200 == statusCode) {
                        try (InputStream inputStream = entity.getContent();){
                            String content = IOUtils.toString((InputStream)inputStream);
                            AccessTokenInfo accessTokenInfo = (AccessTokenInfo)new Gson().fromJson(content, AccessTokenInfo.class);
                            return accessTokenInfo;
                        }
                    }
                    break block33;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                this.handleException("Encoding method is not supported", e);
            }
            catch (IOException e) {
                this.handleException("Error has occurred while reading or closing buffer reader", e);
            }
        }
        return null;
    }

    private static String getEncodedCredentials(String clientId, String clientSecret) throws APIManagementException {
        String encodedCredentials;
        try {
            encodedCredentials = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new APIManagementException("Encoding method is not supported", (Throwable)e);
        }
        return encodedCredentials;
    }

    public OAuthApplicationInfo updateApplicationOwner(OAuthAppRequest oAuthAppRequest, String owner) throws APIManagementException {
        return oAuthAppRequest.getOAuthApplicationInfo();
    }

    private ClientInfo createClientInfoFromOauthApplicationInfo(OAuthApplicationInfo oAuthApplicationInfo) throws APIManagementException {
        ClientInfo clientInfo = new ClientInfo();
        String userId = (String)oAuthApplicationInfo.getParameter("username");
        String userNameForSp = MultitenantUtils.getTenantAwareUsername((String)userId);
        String domain = UserCoreUtil.extractDomainFromName((String)userNameForSp);
        if (domain != null && !domain.isEmpty() && !"PRIMARY".equals(domain)) {
            userNameForSp = userNameForSp.replace(UserCoreConstants.DOMAIN_SEPARATOR, "_");
        }
        String applicationName = oAuthApplicationInfo.getClientName();
        String keyType = (String)oAuthApplicationInfo.getParameter("key_type");
        String callBackURL = oAuthApplicationInfo.getCallBackURL();
        if (keyType != null) {
            applicationName = userNameForSp.concat(applicationName).concat("_").concat(keyType);
        }
        List<Object> grantTypes = new ArrayList();
        if (oAuthApplicationInfo.getParameter("grant_types") != null) {
            grantTypes = Arrays.asList(((String)oAuthApplicationInfo.getParameter("grant_types")).split(","));
        }
        Object parameter = oAuthApplicationInfo.getParameter("additionalProperties");
        Map additionalProperties = new HashMap();
        if (parameter instanceof String) {
            additionalProperties = (Map)new Gson().fromJson((String)parameter, Map.class);
        }
        clientInfo.setClientName(applicationName);
        if (!grantTypes.isEmpty()) {
            clientInfo.setGrantTypes(grantTypes);
        }
        if (StringUtils.isNotEmpty((String)callBackURL)) {
            String[] calBackUris = callBackURL.split(",");
            clientInfo.setCallBackUrls(Arrays.asList(calBackUris));
        }
        if (additionalProperties.containsKey("subject_type")) {
            clientInfo.setSubjectType((String)additionalProperties.get("subject_type"));
        }
        if (additionalProperties.containsKey("client_id")) {
            clientInfo.setClientId((String)additionalProperties.get("client_id"));
        }
        if (additionalProperties.containsKey("client_secret")) {
            clientInfo.setClientSecret((String)additionalProperties.get("client_secret"));
        }
        if (additionalProperties.get("response_types") instanceof List) {
            clientInfo.setResponseTypes((List)additionalProperties.get("response_types"));
        }
        if (additionalProperties.containsKey("token_endpoint_auth_method")) {
            clientInfo.setTokenEndpointAuthenticationMethod((String)additionalProperties.get("token_endpoint_auth_method"));
        }
        if (additionalProperties.containsKey("tls_client_certificate_bound_access_tokens")) {
            Object clientBoundAccessToken = additionalProperties.get("tls_client_certificate_bound_access_tokens");
            if (clientBoundAccessToken instanceof Boolean) {
                clientInfo.setEnableClientCertificateBindAccessToken((Boolean)clientBoundAccessToken);
            } else if (clientBoundAccessToken instanceof String) {
                clientInfo.setEnableClientCertificateBindAccessToken(Boolean.parseBoolean((String)clientBoundAccessToken));
            }
        }
        return clientInfo;
    }
}

