/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.owasp.csrfguard.util.Streams;

public class CsrfGuardUtils {
    private static final Object NO_PARAMS;
    private static String[] CAUSE_METHOD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;
    public static final Object[] EMPTY_OBJECT_ARRAY;

    public static String httpProtocolAndDomain(String url) {
        int firstSlashAfterProtocol = url.indexOf(47, 8);
        if (firstSlashAfterProtocol < 0) {
            return url;
        }
        return url.substring(0, firstSlashAfterProtocol);
    }

    public static Object callMethod(Class theClass, Object invokeOn, String methodName) {
        return CsrfGuardUtils.callMethod(theClass, invokeOn, methodName, null, null);
    }

    public static Object callMethod(Class theClass, Object invokeOn, String methodName, Object paramTypesOrArrayOrList, Object paramsOrListOrArray) {
        return CsrfGuardUtils.callMethod(theClass, invokeOn, methodName, paramTypesOrArrayOrList, paramsOrListOrArray, true);
    }

    public static Object callMethod(Class theClass, Object invokeOn, String methodName, Object paramTypesOrArrayOrList, Object paramsOrListOrArray, boolean callOnSupers) {
        return CsrfGuardUtils.callMethod(theClass, invokeOn, methodName, paramTypesOrArrayOrList, paramsOrListOrArray, callOnSupers, false);
    }

    public static Object callMethod(Class theClass, Object invokeOn, String methodName, Object paramTypesOrArrayOrList, Object paramsOrListOrArray, boolean callOnSupers, boolean overrideSecurity) {
        try {
            Method method = null;
            Class[] paramTypesArray = (Class[])CsrfGuardUtils.toArray(paramTypesOrArrayOrList);
            try {
                method = theClass.getDeclaredMethod(methodName, paramTypesArray);
                if (overrideSecurity) {
                    method.setAccessible(true);
                }
            }
            catch (Exception e) {
                if (e instanceof NoSuchMethodException && callOnSupers && !theClass.equals(Object.class)) {
                    return CsrfGuardUtils.callMethod(theClass.getSuperclass(), invokeOn, methodName, paramTypesOrArrayOrList, paramsOrListOrArray, callOnSupers, overrideSecurity);
                }
                throw new RuntimeException("Problem calling method " + methodName + " on " + theClass.getName(), e);
            }
            return CsrfGuardUtils.invokeMethod(method, invokeOn, paramsOrListOrArray);
        }
        catch (RuntimeException re) {
            String message = "Problem calling method " + methodName + " on " + (theClass == null ? null : theClass.getName());
            if (CsrfGuardUtils.injectInException(re, message)) {
                throw re;
            }
            throw new RuntimeException(message, re);
        }
    }

    public static Class forName(String origClassName) {
        try {
            return Class.forName(origClassName);
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem loading class: " + origClassName, t);
        }
    }

    public static String getInitParameter(ServletConfig servletConfig, String name, String configFileDefaultParamValue, String defaultValue) {
        String value = servletConfig.getInitParameter(name);
        if (value == null || "".equals(value.trim())) {
            value = configFileDefaultParamValue;
        }
        if (value == null || "".equals(value.trim())) {
            value = defaultValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResourceFileContent(String resourceName, boolean errorIfNotFound) {
        InputStream is;
        block4: {
            String string;
            is = null;
            try {
                is = CsrfGuardUtils.class.getClassLoader().getResourceAsStream(resourceName);
                if (is != null) break block4;
                if (errorIfNotFound) {
                    throw new IllegalStateException("Could not find resource " + resourceName);
                }
                string = null;
            }
            catch (Throwable throwable) {
                Streams.close(is);
                throw throwable;
            }
            Streams.close(is);
            return string;
        }
        String string = CsrfGuardUtils.readInputStreamContent(is);
        Streams.close(is);
        return string;
    }

    public static String readFileContent(String fileName) {
        String string;
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileName);
            string = CsrfGuardUtils.readInputStreamContent(is);
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException(ioe);
            }
            catch (Throwable throwable) {
                Streams.close(is);
                throw throwable;
            }
        }
        Streams.close(is);
        return string;
    }

    public static String readInputStreamContent(InputStream is) {
        StringBuilder sb = new StringBuilder();
        try {
            int i;
            while ((i = is.read()) > 0) {
                sb.append((char)i);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return sb.toString();
    }

    public static boolean injectInException(Throwable t, String message) {
        String throwableFieldName = "detailMessage";
        try {
            String currentValue = t.getMessage();
            currentValue = !CsrfGuardUtils.isBlank(currentValue) ? currentValue + ",\n" + message : message;
            CsrfGuardUtils.assignField(t, throwableFieldName, currentValue);
            return true;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    public static boolean isBlank(Object input) {
        if (null == input) {
            return true;
        }
        return input instanceof String && CsrfGuardUtils.isBlank((String)input);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void assignField(Class theClass, Object invokeOn, String fieldName, Object dataToAssign, boolean callOnSupers, boolean overrideSecurity, boolean typeCast, Class<? extends Annotation> annotationWithValueOverride) {
        if (theClass == null && invokeOn != null) {
            theClass = invokeOn.getClass();
        }
        Field field = CsrfGuardUtils.field(theClass, fieldName, callOnSupers, true);
        CsrfGuardUtils.assignField(field, invokeOn, dataToAssign, overrideSecurity, typeCast, annotationWithValueOverride);
    }

    public static Object toArray(Object objectOrArrayOrCollection) {
        if (objectOrArrayOrCollection != null && objectOrArrayOrCollection.getClass().isArray()) {
            return objectOrArrayOrCollection;
        }
        int length = CsrfGuardUtils.length(objectOrArrayOrCollection);
        if (length == 0) {
            return null;
        }
        if (objectOrArrayOrCollection instanceof Collection) {
            Collection collection;
            Object first = (collection = (Collection)objectOrArrayOrCollection).iterator().next();
            return CsrfGuardUtils.toArray(collection, first == null ? Object.class : first.getClass());
        }
        Object array = Array.newInstance(objectOrArrayOrCollection.getClass(), 1);
        Array.set(array, 0, objectOrArrayOrCollection);
        return array;
    }

    public static int length(Object arrayOrCollection) {
        if (arrayOrCollection == null) {
            return 0;
        }
        if (arrayOrCollection.getClass().isArray()) {
            return Array.getLength(arrayOrCollection);
        }
        if (arrayOrCollection instanceof Collection) {
            return ((Collection)arrayOrCollection).size();
        }
        if (arrayOrCollection instanceof Map) {
            return ((Map)arrayOrCollection).size();
        }
        return 1;
    }

    public static <T> T[] toArray(Collection collection, Class<T> theClass) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.toArray((Object[])Array.newInstance(theClass, collection.size()));
    }

    public static void assignField(Object invokeOn, String fieldName, Object dataToAssign) {
        CsrfGuardUtils.assignField(null, invokeOn, fieldName, dataToAssign, true, true, true, null);
    }

    public static Object invokeMethod(Method method, Object invokeOn) {
        return CsrfGuardUtils.invokeMethod(method, invokeOn, NO_PARAMS);
    }

    public static Object invokeMethod(Method method, Object invokeOn, Object paramsOrListOrArray) {
        Object[] args = paramsOrListOrArray == NO_PARAMS ? null : (Object[])CsrfGuardUtils.toArray(paramsOrListOrArray);
        method.setAccessible(true);
        Object result = null;
        Exception e = null;
        try {
            result = method.invoke(invokeOn, args);
        }
        catch (IllegalAccessException iae) {
            e = iae;
        }
        catch (IllegalArgumentException iae) {
            e = iae;
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            e = ite;
        }
        if (e != null) {
            throw new RuntimeException("Cant execute reflection method: " + method.getName() + ", on: " + CsrfGuardUtils.className(invokeOn) + ", with args: " + CsrfGuardUtils.classNameCollection(args), e);
        }
        return result;
    }

    public static String className(Object object) {
        return object == null ? null : object.getClass().getName();
    }

    public static String classNameCollection(Object object) {
        if (object == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        Iterator iterator = CsrfGuardUtils.iterator(object);
        int length = CsrfGuardUtils.length(object);
        for (int i = 0; i < length && i < 20; ++i) {
            result.append(CsrfGuardUtils.className(CsrfGuardUtils.next(object, iterator, i)));
            if (i == length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static Iterator iterator(Object collection) {
        if (collection == null) {
            return null;
        }
        if (collection instanceof Collection && !(collection instanceof ArrayList)) {
            return ((Collection)collection).iterator();
        }
        return null;
    }

    public static Object next(Object arrayOrCollection, Iterator iterator, int index) {
        if (arrayOrCollection.getClass().isArray()) {
            return Array.get(arrayOrCollection, index);
        }
        if (arrayOrCollection instanceof ArrayList) {
            return ((ArrayList)arrayOrCollection).get(index);
        }
        if (arrayOrCollection instanceof Collection) {
            return iterator.next();
        }
        if (0 == index) {
            return arrayOrCollection;
        }
        throw new RuntimeException("Invalid class type: " + arrayOrCollection.getClass().getName());
    }

    public static void assignField(Field field, Object invokeOn, Object dataToAssign, boolean overrideSecurity, boolean typeCast, Class<? extends Annotation> annotationWithValueOverride) {
        Annotation annotation;
        if (annotationWithValueOverride != null && (annotation = field.getAnnotation(annotationWithValueOverride)) != null) {
            throw new RuntimeException("Not supported");
        }
        CsrfGuardUtils.assignField(field, invokeOn, dataToAssign, overrideSecurity, typeCast);
    }

    public static Field field(Class theClass, String fieldName, boolean callOnSupers, boolean throwExceptionIfNotFound) {
        try {
            Field field = theClass.getDeclaredField(fieldName);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (callOnSupers && !theClass.equals(Object.class)) {
                return CsrfGuardUtils.field(theClass.getSuperclass(), fieldName, callOnSupers, throwExceptionIfNotFound);
            }
            if (throwExceptionIfNotFound) {
                throw new RuntimeException("Cant find field: " + fieldName + ", in: " + theClass + ", callOnSupers: " + callOnSupers);
            }
            return null;
        }
    }

    public static void assignField(Field field, Object invokeOn, Object dataToAssign, boolean overrideSecurity, boolean typeCast) {
        try {
            Class<?> fieldType = field.getType();
            if (typeCast) {
                dataToAssign = CsrfGuardUtils.typeCast(dataToAssign, fieldType, true, true);
            }
            if (overrideSecurity) {
                field.setAccessible(true);
            }
            field.set(invokeOn, dataToAssign);
        }
        catch (Exception e) {
            throw new RuntimeException("Cant assign reflection field: " + (field == null ? null : field.getName()) + ", on: " + CsrfGuardUtils.className(invokeOn) + ", with args: " + CsrfGuardUtils.classNameCollection(dataToAssign), e);
        }
    }

    public static <T> T typeCast(Object value, Class<T> theClass) {
        return CsrfGuardUtils.typeCast(value, theClass, false, false);
    }

    public static <T> T typeCast(Object value, Class<T> theClass, boolean convertNullToDefaultPrimitive, boolean useNewInstanceHooks) {
        if (Object.class.equals(theClass)) {
            return (T)value;
        }
        if (value == null) {
            if (convertNullToDefaultPrimitive && theClass.isPrimitive()) {
                if (theClass == Boolean.TYPE) {
                    return (T)Boolean.FALSE;
                }
                if (theClass == Character.TYPE) {
                    return (T)Integer.valueOf(0);
                }
                return CsrfGuardUtils.typeCast(0, theClass, false, false);
            }
            return null;
        }
        if (theClass.isInstance(value)) {
            return (T)value;
        }
        if (theClass.isArray() && theClass.getComponentType() != null) {
            theClass = theClass.getComponentType();
        }
        Object resultValue = null;
        if (theClass.equals(String.class)) {
            resultValue = value == null ? null : value.toString();
        } else if (theClass.equals(value.getClass())) {
            resultValue = value;
        } else {
            throw new RuntimeException("Cannot convert from type: " + value.getClass() + " to type: " + theClass);
        }
        return (T)resultValue;
    }

    public static <T> T newInstance(Class<T> theClass) {
        try {
            return theClass.newInstance();
        }
        catch (Throwable e) {
            if (theClass != null && Modifier.isAbstract(theClass.getModifiers())) {
                throw new RuntimeException("Problem with class: " + theClass + ", maybe because it is abstract!", e);
            }
            throw new RuntimeException("Problem with class: " + theClass, e);
        }
    }

    public static void closeQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(InputStream input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        if (output == null) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Reader input) {
        if (input == null) {
            return;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(XMLStreamWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    public static String toStringForLog(Object object) {
        StringBuilder result = new StringBuilder();
        CsrfGuardUtils.toStringForLogHelper(object, -1, result);
        return result.toString();
    }

    public static String toStringForLog(Object object, int maxChars) {
        StringBuilder result = new StringBuilder();
        CsrfGuardUtils.toStringForLogHelper(object, -1, result);
        String resultString = result.toString();
        if (maxChars != -1) {
            return CsrfGuardUtils.abbreviate(resultString, maxChars);
        }
        return resultString;
    }

    private static void toStringForLogHelper(Object object, int maxChars, StringBuilder result) {
        try {
            if (object == null) {
                result.append("null");
            } else if (object.getClass().isArray()) {
                int length = Array.getLength(object);
                if (length == 0) {
                    result.append("Empty array");
                } else {
                    result.append("Array size: ").append(length).append(": ");
                    for (int i = 0; i < length; ++i) {
                        result.append("[").append(i).append("]: ").append(CsrfGuardUtils.toStringForLog(Array.get(object, i), maxChars)).append("\n");
                        if (maxChars == -1 || result.length() <= maxChars) continue;
                        return;
                    }
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                int collectionSize = collection.size();
                if (collectionSize == 0) {
                    result.append("Empty ").append(object.getClass().getSimpleName());
                } else {
                    result.append(object.getClass().getSimpleName()).append(" size: ").append(collectionSize).append(": ");
                    int i = 0;
                    for (Object collectionObject : collection) {
                        result.append("[").append(i).append("]: ").append(CsrfGuardUtils.toStringForLog(collectionObject, maxChars)).append("\n");
                        if (maxChars != -1 && result.length() > maxChars) {
                            return;
                        }
                        ++i;
                    }
                }
            } else {
                result.append(object.toString());
            }
        }
        catch (Exception e) {
            result.append("<<exception>> ").append(object.getClass()).append(":\n").append(CsrfGuardUtils.getFullStackTrace(e)).append("\n");
        }
    }

    public static String abbreviate(String str, int maxWidth) {
        return CsrfGuardUtils.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + (maxWidth - 3) < str.length()) {
            return "..." + CsrfGuardUtils.abbreviate(str.substring(offset), maxWidth - 3);
        }
        return "..." + str.substring(str.length() - (maxWidth - 3));
    }

    public static String getFullStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        Throwable[] ts = CsrfGuardUtils.getThrowables(throwable);
        for (int i = 0; i < ts.length; ++i) {
            ts[i].printStackTrace(pw);
            if (CsrfGuardUtils.isNestedThrowable(ts[i])) break;
        }
        return sw.getBuffer().toString();
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null) {
            list.add(throwable);
            throwable = CsrfGuardUtils.getCause(throwable);
        }
        return list.toArray(new Throwable[list.size()]);
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return true;
        }
        if (throwable instanceof InvocationTargetException) {
            return true;
        }
        if (CsrfGuardUtils.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable.getClass();
        int isize = CAUSE_METHOD_NAMES.length;
        for (int i = 0; i < isize; ++i) {
            try {
                Method method = cls.getMethod(CAUSE_METHOD_NAMES[i], null);
                if (method == null || !Throwable.class.isAssignableFrom(method.getReturnType())) continue;
                return true;
            }
            catch (NoSuchMethodException ignored) {
                continue;
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
        }
        try {
            Field field = cls.getField("detail");
            if (field != null) {
                return true;
            }
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static Throwable getCause(Throwable throwable) {
        return CsrfGuardUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    public static Throwable getCause(Throwable throwable, String[] methodNames) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = CsrfGuardUtils.getCauseUsingWellKnownTypes(throwable);
        if (cause == null) {
            String methodName;
            if (methodNames == null) {
                methodNames = CAUSE_METHOD_NAMES;
            }
            for (int i = 0; i < methodNames.length && ((methodName = methodNames[i]) == null || (cause = CsrfGuardUtils.getCauseUsingMethodName(throwable, methodName)) == null); ++i) {
            }
            if (cause == null) {
                cause = CsrfGuardUtils.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return cause;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String fieldName) {
        Field field = null;
        try {
            field = throwable.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String methodName) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException ignored) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    public static String defaultString(String str) {
        return str == null ? "" : str;
    }

    static {
        Method getCauseMethod;
        NO_PARAMS = new Object();
        CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            getCauseMethod = Throwable.class.getMethod("getCause", null);
        }
        catch (Exception e) {
            getCauseMethod = null;
        }
        THROWABLE_CAUSE_METHOD = getCauseMethod;
        EMPTY_OBJECT_ARRAY = new Object[0];
    }
}

