/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import org.owasp.csrfguard.CsrfGuardServletContextListener;
import org.owasp.csrfguard.action.IAction;
import org.owasp.csrfguard.config.ConfigurationProvider;
import org.owasp.csrfguard.log.ILogger;
import org.owasp.csrfguard.servlet.JavaScriptServlet;
import org.owasp.csrfguard.util.CsrfGuardUtils;

public final class PropertiesConfigurationProvider
implements ConfigurationProvider {
    private static final String ACTION_PREFIX = "org.owasp.csrfguard.action.";
    private static final String PROTECTED_PAGE_PREFIX = "org.owasp.csrfguard.protected.";
    private static final String UNPROTECTED_PAGE_PREFIX = "org.owasp.csrfguard.unprotected.";
    private final ILogger logger;
    private final String tokenName;
    private final int tokenLength;
    private final boolean rotate;
    private final boolean enabled;
    private final boolean tokenPerPage;
    private final boolean tokenPerPagePrecreate;
    private final boolean printConfig;
    private final SecureRandom prng;
    private final String newTokenLandingPage;
    private final boolean useNewTokenLandingPage;
    private final boolean ajax;
    private final boolean protect;
    private final String sessionKey;
    private final Set<String> protectedPages;
    private final Set<String> unprotectedPages;
    private final Set<String> protectedMethods;
    private final Set<String> unprotectedMethods;
    private final List<IAction> actions;
    private Properties propertiesCache;
    private boolean javascriptParamsInitted = false;
    private final boolean validationWhenNoSessionExists;
    private String javascriptTemplateCode;
    private String javascriptSourceFile;
    private boolean javascriptDomainStrict;
    private String javascriptCacheControl;
    private Pattern javascriptRefererPattern;
    private boolean javascriptInjectIntoForms;
    private boolean javascriptRefererMatchDomain;
    private boolean javascriptInjectIntoAttributes;
    private String javascriptXrequestedWith;
    private boolean javascriptInjectGetForms;
    private boolean javascriptInjectFormAttributes;

    public PropertiesConfigurationProvider(Properties properties) {
        try {
            IAction action;
            String directive;
            int index;
            String key;
            this.propertiesCache = properties;
            this.actions = new ArrayList<IAction>();
            this.protectedPages = new HashSet<String>();
            this.unprotectedPages = new HashSet<String>();
            this.protectedMethods = new HashSet<String>();
            this.unprotectedMethods = new HashSet<String>();
            this.logger = (ILogger)Class.forName(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.Logger", "org.owasp.csrfguard.log.ConsoleLogger")).newInstance();
            this.tokenName = PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.TokenName", "OWASP_CSRFGUARD");
            this.tokenLength = Integer.parseInt(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.TokenLength", "32"));
            this.rotate = Boolean.valueOf(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.Rotate", "false"));
            this.tokenPerPage = Boolean.valueOf(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.TokenPerPage", "false"));
            this.validationWhenNoSessionExists = Boolean.valueOf(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.ValidateWhenNoSessionExists", "true"));
            this.tokenPerPagePrecreate = Boolean.valueOf(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.TokenPerPagePrecreate", "false"));
            this.prng = SecureRandom.getInstance(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.PRNG", "SHA1PRNG"), PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.PRNG.Provider", "SUN"));
            this.newTokenLandingPage = PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.NewTokenLandingPage");
            this.printConfig = Boolean.valueOf(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.Config.Print", "false"));
            this.enabled = Boolean.valueOf(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.Enabled", "true"));
            this.useNewTokenLandingPage = this.newTokenLandingPage == null ? Boolean.valueOf(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.UseNewTokenLandingPage", "false")).booleanValue() : Boolean.valueOf(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.UseNewTokenLandingPage", "true")).booleanValue();
            this.sessionKey = PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.SessionKey", "OWASP_CSRFGUARD_KEY");
            this.ajax = Boolean.valueOf(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.Ajax", "false"));
            this.protect = Boolean.valueOf(PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.Protect", "false"));
            HashMap<String, IAction> actionsMap = new HashMap<String, IAction>();
            for (Object obj : properties.keySet()) {
                key = (String)obj;
                if (!key.startsWith(ACTION_PREFIX) || (index = (directive = key.substring(ACTION_PREFIX.length())).indexOf(46)) >= 0) continue;
                String actionClass = PropertiesConfigurationProvider.propertyString(properties, key);
                action = (IAction)Class.forName(actionClass).newInstance();
                action.setName(directive);
                actionsMap.put(action.getName(), action);
                this.actions.add(action);
            }
            for (Object obj : properties.keySet()) {
                key = (String)obj;
                if (!key.startsWith(ACTION_PREFIX) || (index = (directive = key.substring(ACTION_PREFIX.length())).indexOf(46)) < 0) continue;
                String actionName = directive.substring(0, index);
                action = (IAction)actionsMap.get(actionName);
                if (action == null) {
                    throw new IOException(String.format("action class %s has not yet been specified", actionName));
                }
                String parameterName = directive.substring(index + 1);
                String parameterValue = PropertiesConfigurationProvider.propertyString(properties, key);
                action.setParameter(parameterName, parameterValue);
            }
            if (this.actions.size() <= 0) {
                throw new IOException("failure to define at least one action");
            }
            for (Object obj : properties.keySet()) {
                String pageUri;
                key = (String)obj;
                if (key.startsWith(PROTECTED_PAGE_PREFIX) && (index = (directive = key.substring(PROTECTED_PAGE_PREFIX.length())).indexOf(46)) < 0) {
                    pageUri = PropertiesConfigurationProvider.propertyString(properties, key);
                    this.protectedPages.add(pageUri);
                }
                if (!key.startsWith(UNPROTECTED_PAGE_PREFIX) || (index = (directive = key.substring(UNPROTECTED_PAGE_PREFIX.length())).indexOf(46)) >= 0) continue;
                pageUri = PropertiesConfigurationProvider.propertyString(properties, key);
                this.unprotectedPages.add(pageUri);
            }
            String methodList = PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.ProtectedMethods");
            if (methodList != null && methodList.trim().length() != 0) {
                for (String method : methodList.split(",")) {
                    this.protectedMethods.add(method.trim());
                }
            }
            if ((methodList = PropertiesConfigurationProvider.propertyString(properties, "org.owasp.csrfguard.UnprotectedMethods")) != null && methodList.trim().length() != 0) {
                for (String method : methodList.split(",")) {
                    this.unprotectedMethods.add(method.trim());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void javascriptInitParamsIfNeeded() {
        ServletConfig servletConfig;
        if (!this.javascriptParamsInitted && (servletConfig = JavaScriptServlet.getStaticServletConfig()) != null) {
            this.javascriptCacheControl = CsrfGuardUtils.getInitParameter(servletConfig, "cache-control", PropertiesConfigurationProvider.propertyString(this.propertiesCache, "org.owasp.csrfguard.JavascriptServlet.cacheControl"), "private, maxage=28800");
            this.javascriptDomainStrict = Boolean.valueOf(CsrfGuardUtils.getInitParameter(servletConfig, "domain-strict", PropertiesConfigurationProvider.propertyString(this.propertiesCache, "org.owasp.csrfguard.JavascriptServlet.domainStrict"), "true"));
            this.javascriptInjectIntoAttributes = Boolean.valueOf(CsrfGuardUtils.getInitParameter(servletConfig, "inject-into-attributes", PropertiesConfigurationProvider.propertyString(this.propertiesCache, "org.owasp.csrfguard.JavascriptServlet.injectIntoAttributes"), "true"));
            this.javascriptInjectGetForms = Boolean.valueOf(CsrfGuardUtils.getInitParameter(servletConfig, "inject-get-forms", PropertiesConfigurationProvider.propertyString(this.propertiesCache, "org.owasp.csrfguard.JavascriptServlet.injectGetForms"), "true"));
            this.javascriptInjectFormAttributes = Boolean.valueOf(CsrfGuardUtils.getInitParameter(servletConfig, "inject-form-attributes", PropertiesConfigurationProvider.propertyString(this.propertiesCache, "org.owasp.csrfguard.JavascriptServlet.injectFormAttributes"), "true"));
            this.javascriptInjectIntoForms = Boolean.valueOf(CsrfGuardUtils.getInitParameter(servletConfig, "inject-into-forms", PropertiesConfigurationProvider.propertyString(this.propertiesCache, "org.owasp.csrfguard.JavascriptServlet.injectIntoForms"), "true"));
            this.javascriptRefererPattern = Pattern.compile(CsrfGuardUtils.getInitParameter(servletConfig, "referer-pattern", PropertiesConfigurationProvider.propertyString(this.propertiesCache, "org.owasp.csrfguard.JavascriptServlet.refererPattern"), ".*"));
            this.javascriptRefererMatchDomain = Boolean.valueOf(CsrfGuardUtils.getInitParameter(servletConfig, "referer-match-domain", PropertiesConfigurationProvider.propertyString(this.propertiesCache, "org.owasp.csrfguard.JavascriptServlet.refererMatchDomain"), "true"));
            this.javascriptSourceFile = CsrfGuardUtils.getInitParameter(servletConfig, "source-file", PropertiesConfigurationProvider.propertyString(this.propertiesCache, "org.owasp.csrfguard.JavascriptServlet.sourceFile"), null);
            this.javascriptXrequestedWith = CsrfGuardUtils.getInitParameter(servletConfig, "x-requested-with", PropertiesConfigurationProvider.propertyString(this.propertiesCache, "org.owasp.csrfguard.JavascriptServlet.xRequestedWith"), "OWASP CSRFGuard Project");
            this.javascriptTemplateCode = this.javascriptSourceFile == null ? CsrfGuardUtils.readResourceFileContent("META-INF/csrfguard.js", true) : (this.javascriptSourceFile.startsWith("META-INF/") ? CsrfGuardUtils.readResourceFileContent(this.javascriptSourceFile, true) : CsrfGuardUtils.readFileContent(servletConfig.getServletContext().getRealPath(this.javascriptSourceFile)));
            this.javascriptParamsInitted = true;
        }
    }

    public static String propertyString(Properties properties, String propertyName) {
        String value = properties.getProperty(propertyName);
        value = PropertiesConfigurationProvider.commonSubstitutions(value);
        return value;
    }

    public static String propertyString(Properties properties, String propertyName, String defaultValue) {
        String value = properties.getProperty(propertyName, defaultValue);
        value = PropertiesConfigurationProvider.commonSubstitutions(value);
        return value;
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public String getTokenName() {
        return this.tokenName;
    }

    @Override
    public int getTokenLength() {
        return this.tokenLength;
    }

    @Override
    public boolean isRotateEnabled() {
        return this.rotate;
    }

    @Override
    public boolean isValidateWhenNoSessionExists() {
        return this.validationWhenNoSessionExists;
    }

    @Override
    public boolean isTokenPerPageEnabled() {
        return this.tokenPerPage;
    }

    @Override
    public boolean isTokenPerPagePrecreateEnabled() {
        return this.tokenPerPagePrecreate;
    }

    @Override
    public SecureRandom getPrng() {
        return this.prng;
    }

    @Override
    public String getNewTokenLandingPage() {
        return this.newTokenLandingPage;
    }

    @Override
    public boolean isUseNewTokenLandingPage() {
        return this.useNewTokenLandingPage;
    }

    @Override
    public boolean isAjaxEnabled() {
        return this.ajax;
    }

    @Override
    public boolean isProtectEnabled() {
        return this.protect;
    }

    @Override
    public String getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public Set<String> getProtectedPages() {
        return this.protectedPages;
    }

    @Override
    public Set<String> getUnprotectedPages() {
        return this.unprotectedPages;
    }

    @Override
    public Set<String> getProtectedMethods() {
        return this.protectedMethods;
    }

    @Override
    public Set<String> getUnprotectedMethods() {
        return this.unprotectedMethods;
    }

    @Override
    public List<IAction> getActions() {
        return this.actions;
    }

    @Override
    public boolean isPrintConfig() {
        return this.printConfig;
    }

    @Override
    public String getJavascriptSourceFile() {
        this.javascriptInitParamsIfNeeded();
        return this.javascriptSourceFile;
    }

    @Override
    public boolean isJavascriptDomainStrict() {
        this.javascriptInitParamsIfNeeded();
        return this.javascriptDomainStrict;
    }

    @Override
    public String getJavascriptCacheControl() {
        this.javascriptInitParamsIfNeeded();
        return this.javascriptCacheControl;
    }

    @Override
    public Pattern getJavascriptRefererPattern() {
        this.javascriptInitParamsIfNeeded();
        return this.javascriptRefererPattern;
    }

    @Override
    public boolean isJavascriptRefererMatchDomain() {
        this.javascriptInitParamsIfNeeded();
        return this.javascriptRefererMatchDomain;
    }

    @Override
    public boolean isJavascriptInjectIntoForms() {
        this.javascriptInitParamsIfNeeded();
        return this.javascriptInjectIntoForms;
    }

    @Override
    public boolean isJavascriptInjectIntoAttributes() {
        this.javascriptInitParamsIfNeeded();
        return this.javascriptInjectIntoAttributes;
    }

    @Override
    public String getJavascriptXrequestedWith() {
        this.javascriptInitParamsIfNeeded();
        return this.javascriptXrequestedWith;
    }

    @Override
    public String getJavascriptTemplateCode() {
        this.javascriptInitParamsIfNeeded();
        return this.javascriptTemplateCode;
    }

    @Override
    public boolean isCacheable() {
        return this.javascriptParamsInitted;
    }

    public static String commonSubstitutions(String input) {
        if (input == null || !input.contains("%")) {
            return input;
        }
        input = input.replace("%servletContext%", CsrfGuardUtils.defaultString(CsrfGuardServletContextListener.getServletContext()));
        return input;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isJavascriptInjectGetForms() {
        this.javascriptInitParamsIfNeeded();
        return this.javascriptInjectGetForms;
    }

    @Override
    public boolean isJavascriptInjectFormAttributes() {
        this.javascriptInitParamsIfNeeded();
        return this.javascriptInjectFormAttributes;
    }
}

