/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.tenant.resource.manager.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.publisher.core.EventPublisherService;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.identity.configuration.mgt.core.ConfigurationManager;
import org.wso2.carbon.identity.tenant.resource.manager.TenantAwareAxis2ConfigurationContextObserver;
import org.wso2.carbon.identity.tenant.resource.manager.core.ResourceManager;
import org.wso2.carbon.identity.tenant.resource.manager.core.ResourceManagerImpl;
import org.wso2.carbon.identity.tenant.resource.manager.internal.TenantResourceManagerDataHolder;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

@Component(name="org.wso2.carbon.identity.tenant.resource.manager.internal.TenantResourceManagerServiceDS", immediate=true)
public class TenantResourceManagerServiceDS
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(TenantResourceManagerServiceDS.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            TenantAwareAxis2ConfigurationContextObserver tenantAwareAxis2ConfigurationContextObserver = new TenantAwareAxis2ConfigurationContextObserver();
            context.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)tenantAwareAxis2ConfigurationContextObserver, null);
            ResourceManagerImpl resourceManager = new ResourceManagerImpl();
            context.getBundleContext().registerService(ResourceManager.class.getName(), (Object)resourceManager, null);
            TenantResourceManagerDataHolder.getInstance().setResourceManager(resourceManager);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed the tenant resource manager service.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Can not create the tenant resource manager service.", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant resource manager bundle is de-activated");
        }
    }

    @Reference(name="CarbonEventPublisherService", service=EventPublisherService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonEventPublisherService")
    protected void setCarbonEventPublisherService(EventPublisherService carbonEventPublisherService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the CarbonEventPublisherService");
        }
        TenantResourceManagerDataHolder.getInstance().setCarbonEventPublisherService(carbonEventPublisherService);
    }

    protected void unsetCarbonEventPublisherService(EventPublisherService carbonEventPublisherService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un Setting the CarbonEventPublisherService Service");
        }
        TenantResourceManagerDataHolder.getInstance().setCarbonEventPublisherService(null);
    }

    @Reference(name="EventStreamService", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonEventStreamService")
    protected void setCarbonEventStreamService(EventStreamService carbonEventStreamService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the EventStreamService");
        }
        TenantResourceManagerDataHolder.getInstance().setCarbonEventStreamService(carbonEventStreamService);
    }

    protected void unsetCarbonEventStreamService(EventStreamService carbonEventStreamService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un Setting the EventStreamService");
        }
        TenantResourceManagerDataHolder.getInstance().setCarbonEventStreamService(null);
    }

    @Reference(name="ConfigurationManager", service=ConfigurationManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationManager")
    protected void setConfigurationManager(ConfigurationManager configurationManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the CarbonEventPublisherService");
        }
        TenantResourceManagerDataHolder.getInstance().setConfigurationManager(configurationManager);
    }

    protected void unsetConfigurationManager(ConfigurationManager configurationManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un Setting theCarbonEventPublisherService Service");
        }
        TenantResourceManagerDataHolder.getInstance().setConfigurationManager(null);
    }
}

