/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.tenant.resource.manager.core;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.publisher.core.EventPublisherService;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfigurationFile;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementException;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceFile;
import org.wso2.carbon.identity.tenant.resource.manager.constants.TenantResourceConstants;
import org.wso2.carbon.identity.tenant.resource.manager.core.ResourceManager;
import org.wso2.carbon.identity.tenant.resource.manager.exception.TenantResourceManagementException;
import org.wso2.carbon.identity.tenant.resource.manager.internal.TenantResourceManagerDataHolder;
import org.wso2.carbon.identity.tenant.resource.manager.util.ResourceUtils;

public class ResourceManagerImpl
implements ResourceManager {
    private static Log log = LogFactory.getLog(ResourceManagerImpl.class);

    @Override
    public void addEventPublisherConfiguration(ResourceFile resourceFile) throws TenantResourceManagementException {
        try {
            this.deployEventPublisherConfiguration(TenantResourceManagerDataHolder.getInstance().getConfigurationManager().getFileById("Publisher", resourceFile.getName(), resourceFile.getId()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Event Publisher: " + resourceFile.getName() + " deployed from the configuration store for the tenant domain: " + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain()));
            }
        }
        catch (EventPublisherConfigurationException e) {
            throw ResourceUtils.handleServerException(TenantResourceConstants.ErrorMessages.ERROR_CODE_ERROR_WHEN_DEPLOYING_EVENT_PUBLISHER_CONFIGURATION, e, resourceFile.getName());
        }
        catch (ConfigurationManagementException e) {
            throw ResourceUtils.handleServerException(TenantResourceConstants.ErrorMessages.ERROR_CODE_ERROR_WHEN_FETCHING_EVENT_PUBLISHER_FILE, e, resourceFile.getName(), PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain());
        }
    }

    private void deployEventPublisherConfiguration(InputStream publisherConfig) throws EventPublisherConfigurationException {
        EventPublisherService carbonEventPublisherService = TenantResourceManagerDataHolder.getInstance().getCarbonEventPublisherService();
        EventPublisherConfiguration eventPublisherConfiguration = carbonEventPublisherService.getEventPublisherConfiguration(publisherConfig);
        if (TenantResourceManagerDataHolder.getInstance().getCarbonEventPublisherService().getActiveEventPublisherConfiguration(eventPublisherConfiguration.getEventPublisherName()) != null) {
            this.destroyEventPublisherConfiguration(eventPublisherConfiguration);
        }
        carbonEventPublisherService.addEventPublisherConfiguration(eventPublisherConfiguration);
    }

    private void destroyEventPublisherConfiguration(EventPublisherConfiguration eventPublisherConfiguration) throws EventPublisherConfigurationException {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        EventPublisherConfigurationFile eventPublisherConfigurationFile = new EventPublisherConfigurationFile();
        eventPublisherConfigurationFile.setTenantId(tenantId);
        eventPublisherConfigurationFile.setEventPublisherName(eventPublisherConfiguration.getEventPublisherName());
        eventPublisherConfigurationFile.setFileName(eventPublisherConfiguration.getEventPublisherName());
        eventPublisherConfigurationFile.setStatus(EventPublisherConfigurationFile.Status.DEPLOYED);
        TenantResourceManagerDataHolder.getInstance().getCarbonEventPublisherService().addEventPublisherConfigurationFile(eventPublisherConfigurationFile, tenantId);
        TenantResourceManagerDataHolder.getInstance().getCarbonEventPublisherService().removeEventPublisherConfigurationFile(eventPublisherConfiguration.getEventPublisherName(), tenantId);
    }
}

