/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.tenant.resource.manager;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.stream.core.EventStreamConfiguration;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.carbon.identity.configuration.mgt.core.constant.ConfigurationConstants;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementException;
import org.wso2.carbon.identity.configuration.mgt.core.model.Resource;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceFile;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.tenant.resource.manager.constants.TenantResourceConstants;
import org.wso2.carbon.identity.tenant.resource.manager.exception.TenantResourceManagementException;
import org.wso2.carbon.identity.tenant.resource.manager.internal.TenantResourceManagerDataHolder;
import org.wso2.carbon.identity.tenant.resource.manager.util.ResourceUtils;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class TenantAwareAxis2ConfigurationContextObserver
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(TenantAwareAxis2ConfigurationContextObserver.class);

    public void creatingConfigurationContext(int tenantId) {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        log.info((Object)("Loading configuration context for tenant domain: " + tenantDomain));
        this.loadEventStreamAndPublisherConfigurations(tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEventStreamAndPublisherConfigurations(int tenantId) {
        List<EventStreamConfiguration> eventStreamConfigurationList;
        List<EventPublisherConfiguration> activeEventPublisherConfigurations;
        try {
            this.startSuperTenantFlow();
            activeEventPublisherConfigurations = this.getSuperTenantEventPublisherConfigurations();
            eventStreamConfigurationList = this.getSuperTenantEventStreamConfigurations();
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        try {
            this.startTenantFlow(tenantId);
            this.loadTenantEventStreams(eventStreamConfigurationList);
            this.loadTenantPublisherConfigurationFromConfigStore();
            if (activeEventPublisherConfigurations != null) {
                this.loadTenantPublisherConfigurationFromSuperTenantConfig(activeEventPublisherConfigurations);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void loadTenantPublisherConfigurationFromConfigStore() {
        try {
            List resourcesByTypePublisher = TenantResourceManagerDataHolder.getInstance().getConfigurationManager().getResourcesByType("Publisher").getResources();
            for (Resource resource : resourcesByTypePublisher) {
                ResourceFile tenantSpecificPublisherFile = (ResourceFile)resource.getFiles().get(0);
                if (tenantSpecificPublisherFile == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("File for publisher name: " + tenantSpecificPublisherFile.getName() + " is available in the configuration store."));
                }
                TenantResourceManagerDataHolder.getInstance().getResourceManager().addEventPublisherConfiguration(tenantSpecificPublisherFile);
            }
        }
        catch (ConfigurationManagementException e) {
            if (e.getErrorCode().equals(ConfigurationConstants.ErrorMessages.ERROR_CODE_FEATURE_NOT_ENABLED.getCode())) {
                log.warn((Object)("Configuration store is disabled. Super tenant configuration will be used for the tenant domain: " + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain()));
            } else if (e.getErrorCode().equals(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCES_DOES_NOT_EXISTS.getCode())) {
                log.warn((Object)("Configuration store does not contain any resources under resource type publisher. Super tenant configurations will be used for the tenant domain: " + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain()));
            } else if (e.getErrorCode().equals(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_TYPE_DOES_NOT_EXISTS.getCode())) {
                log.warn((Object)("Configuration store does not contain  publisher resource type. Super tenant configurations will be used for the tenant domain: " + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain()));
            } else {
                log.error((Object)ResourceUtils.populateMessageWithData(TenantResourceConstants.ErrorMessages.ERROR_CODE_ERROR_WHEN_FETCHING_TENANT_SPECIFIC_PUBLISHER_FILES, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain()), (Throwable)e);
            }
        }
        catch (TenantResourceManagementException e) {
            log.error((Object)ResourceUtils.populateMessageWithData(TenantResourceConstants.ErrorMessages.ERROR_CODE_ERROR_WHEN_ADDING_EVENT_PUBLISHER_CONFIGURATION, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain()), (Throwable)e);
        }
    }

    private List<EventPublisherConfiguration> getSuperTenantEventPublisherConfigurations() {
        List activeEventPublisherConfigurations = null;
        try {
            activeEventPublisherConfigurations = TenantResourceManagerDataHolder.getInstance().getCarbonEventPublisherService().getAllActiveEventPublisherConfigurations();
        }
        catch (EventPublisherConfigurationException e) {
            log.error((Object)ResourceUtils.populateMessageWithData(TenantResourceConstants.ErrorMessages.ERROR_CODE_ERROR_WHEN_FETCHING_SUPER_TENANT_EVENT_PUBLISHER_CONFIGURATION, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain()), (Throwable)e);
        }
        return activeEventPublisherConfigurations;
    }

    private List<EventStreamConfiguration> getSuperTenantEventStreamConfigurations() {
        List eventStreamConfigurationList = null;
        try {
            eventStreamConfigurationList = TenantResourceManagerDataHolder.getInstance().getCarbonEventStreamService().getAllEventStreamConfigurations();
        }
        catch (EventStreamConfigurationException e) {
            log.error((Object)ResourceUtils.populateMessageWithData(TenantResourceConstants.ErrorMessages.ERROR_CODE_ERROR_WHEN_FETCHING_SUPER_TENANT_EVENT_STREAM_CONFIGURATION, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain()), (Throwable)e);
        }
        return eventStreamConfigurationList;
    }

    private void startTenantFlow(int tenantId) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(IdentityTenantUtil.getTenantDomain((int)tenantId));
    }

    private void startSuperTenantFlow() {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantId(-1234);
        carbonContext.setTenantDomain("carbon.super");
    }

    private void loadTenantPublisherConfigurationFromSuperTenantConfig(List<EventPublisherConfiguration> activeEventPublisherConfigurations) {
        for (EventPublisherConfiguration eventPublisherConfiguration : activeEventPublisherConfigurations) {
            try {
                if (TenantResourceManagerDataHolder.getInstance().getCarbonEventPublisherService().getActiveEventPublisherConfiguration(eventPublisherConfiguration.getEventPublisherName()) != null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Super tenant event publisher configuration for the: " + eventPublisherConfiguration.getEventPublisherName() + " will be used for the tenant domain: " + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain()));
                }
                TenantResourceManagerDataHolder.getInstance().getCarbonEventPublisherService().addEventPublisherConfiguration(eventPublisherConfiguration);
            }
            catch (EventPublisherConfigurationException e) {
                log.error((Object)ResourceUtils.populateMessageWithData(TenantResourceConstants.ErrorMessages.ERROR_CODE_ERROR_WHEN_CREATING_TENANT_EVENT_PUBLISHER_CONFIGURATION_USING_SUPER_TENANT_CONFIG, eventPublisherConfiguration.getEventPublisherName(), PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain()), (Throwable)e);
            }
        }
    }

    private void loadTenantEventStreams(List<EventStreamConfiguration> eventStreamConfigurationList) {
        if (eventStreamConfigurationList != null) {
            for (EventStreamConfiguration eventStreamConfiguration : eventStreamConfigurationList) {
                if (TenantResourceManagerDataHolder.getInstance().getCarbonEventStreamService().getEventStreamConfiguration(eventStreamConfiguration.getStreamDefinition().getStreamId()) != null) continue;
                try {
                    TenantResourceManagerDataHolder.getInstance().getCarbonEventStreamService().addEventStreamConfig(eventStreamConfiguration);
                }
                catch (EventStreamConfigurationException e) {
                    log.error((Object)ResourceUtils.populateMessageWithData(TenantResourceConstants.ErrorMessages.ERROR_CODE_ERROR_WHEN_CREATING_TENANT_EVENT_STREAM_CONFIGURATION, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain()), (Throwable)e);
                }
            }
        }
    }
}

