/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.util;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.common.DefaultSourceValueProvider;
import org.wso2.carbon.metrics.common.MetricsConfiguration;
import org.wso2.carbon.metrics.impl.internal.LocalDatabaseCreator;
import org.wso2.carbon.metrics.impl.reporter.JDBCReporterImpl;
import org.wso2.carbon.metrics.impl.util.ReporterBuildException;
import org.wso2.carbon.metrics.impl.util.ReporterBuilder;
import org.wso2.carbon.metrics.impl.util.ReporterDisabledException;

public class JDBCReporterBuilder
implements ReporterBuilder<JDBCReporterImpl> {
    private static final Logger logger = LoggerFactory.getLogger(JDBCReporterBuilder.class);
    private static final String JDBC_REPORTING_ENABLED = "Reporting.JDBC.Enabled";
    private static final String JDBC_REPORTING_POLLING_PERIOD = "Reporting.JDBC.PollingPeriod";
    private static final String JDBC_REPORTING_SOURCE = "Reporting.JDBC.Source";
    private static final String JDBC_REPORTING_DATASOURCE_NAME = "Reporting.JDBC.DataSourceName";
    private static final String JDBC_REPORTING_SCHEDULED_CLEANUP_ENABLED = "Reporting.JDBC.ScheduledCleanup.Enabled";
    private static final String JDBC_REPORTING_SCHEDULED_CLEANUP_PERIOD = "Reporting.JDBC.ScheduledCleanup.ScheduledCleanupPeriod";
    private static final String JDBC_REPORTING_SCHEDULED_CLEANUP_DAYS_TO_KEEP = "Reporting.JDBC.ScheduledCleanup.DaysToKeep";
    private static final String DB_CHECK_SQL = "SELECT NAME FROM METRIC_GAUGE";
    private boolean enabled;
    private long jdbcReporterPollingPeriod = 60L;
    private String source;
    private String dataSourceName;
    private boolean runCleanupTask;
    private int daysToKeep = 7;
    private long jdbcScheduledCleanupPeriod = 86400L;

    @Override
    public ReporterBuilder<JDBCReporterImpl> configure(MetricsConfiguration configuration) {
        block10: {
            block8: {
                this.enabled = Boolean.parseBoolean(configuration.getProperty(JDBC_REPORTING_ENABLED, String.valueOf(this.enabled)));
                String pollingPeriod = configuration.getProperty(JDBC_REPORTING_POLLING_PERIOD, String.valueOf(this.jdbcReporterPollingPeriod));
                try {
                    this.jdbcReporterPollingPeriod = Long.parseLong(pollingPeriod);
                }
                catch (NumberFormatException e) {
                    if (!logger.isWarnEnabled()) break block8;
                    logger.warn(String.format("Error parsing the polling period for JDBC Reporting. Using %d seconds", this.jdbcReporterPollingPeriod));
                }
            }
            this.source = configuration.getProperty(JDBC_REPORTING_SOURCE, this.source);
            if (this.source == null) {
                this.source = DefaultSourceValueProvider.getValue();
            }
            this.dataSourceName = configuration.getProperty(JDBC_REPORTING_DATASOURCE_NAME, this.dataSourceName);
            this.runCleanupTask = Boolean.parseBoolean(configuration.getProperty(JDBC_REPORTING_SCHEDULED_CLEANUP_ENABLED, String.valueOf(this.runCleanupTask)));
            if (this.runCleanupTask) {
                block9: {
                    String cleanupPeriod = configuration.getProperty(JDBC_REPORTING_SCHEDULED_CLEANUP_PERIOD, String.valueOf(this.jdbcScheduledCleanupPeriod));
                    try {
                        this.jdbcScheduledCleanupPeriod = Long.parseLong(cleanupPeriod);
                    }
                    catch (NumberFormatException e) {
                        if (!logger.isWarnEnabled()) break block9;
                        logger.warn(String.format("Error parsing the period for JDBC Sceduled Cleanup. Using %d seconds", this.jdbcReporterPollingPeriod));
                    }
                }
                String daysToKeepValue = configuration.getProperty(JDBC_REPORTING_SCHEDULED_CLEANUP_DAYS_TO_KEEP, String.valueOf(this.daysToKeep));
                try {
                    this.daysToKeep = Integer.parseInt(daysToKeepValue);
                }
                catch (NumberFormatException e) {
                    if (!logger.isWarnEnabled()) break block10;
                    logger.warn(String.format("Error parsing the period for JDBC Sceduled Cleanup. Using %d seconds", this.jdbcReporterPollingPeriod));
                }
            }
        }
        return this;
    }

    public ReporterBuilder<JDBCReporterImpl> setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ReporterBuilder<JDBCReporterImpl> setJdbcReporterPollingPeriod(long jdbcReporterPollingPeriod) {
        this.jdbcReporterPollingPeriod = jdbcReporterPollingPeriod;
        return this;
    }

    public ReporterBuilder<JDBCReporterImpl> setSource(String source) {
        this.source = source;
        return this;
    }

    public ReporterBuilder<JDBCReporterImpl> setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
        return this;
    }

    public ReporterBuilder<JDBCReporterImpl> setRunCleanupTask(boolean runCleanupTask) {
        this.runCleanupTask = runCleanupTask;
        return this;
    }

    public ReporterBuilder<JDBCReporterImpl> setDaysToKeep(int daysToKeep) {
        this.daysToKeep = daysToKeep;
        return this;
    }

    public ReporterBuilder<JDBCReporterImpl> setJdbcScheduledCleanupPeriod(long jdbcScheduledCleanupPeriod) {
        this.jdbcScheduledCleanupPeriod = jdbcScheduledCleanupPeriod;
        return this;
    }

    @Override
    public JDBCReporterImpl build(MetricRegistry metricRegistry, MetricFilter metricFilter) throws ReporterDisabledException, ReporterBuildException {
        if (!this.enabled) {
            throw new ReporterDisabledException("JDBC Reporting for Metrics is not enabled");
        }
        if (this.dataSourceName == null || this.dataSourceName.trim().length() == 0) {
            throw new ReporterBuildException("Data Source Name is not specified for JDBC Reporting.");
        }
        DataSource dataSource = null;
        try {
            InitialContext ctx = new InitialContext();
            dataSource = (DataSource)ctx.lookup(this.dataSourceName);
        }
        catch (NamingException e) {
            throw new ReporterBuildException(String.format("Error when looking up the Data Source: '%s'.", this.dataSourceName), e);
        }
        try {
            JDBCReporterBuilder.setupMetricsDatabase(dataSource);
        }
        catch (Exception e) {
            throw new ReporterBuildException(String.format("Error when setting up metrics tables in Data Source: '%s'.", this.dataSourceName), e);
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Creating JDBC reporter for Metrics with source '%s', data source '%s' and %d seconds polling period", this.source, this.dataSourceName, this.jdbcReporterPollingPeriod));
        }
        return new JDBCReporterImpl(metricRegistry, metricFilter, this.source, dataSource, this.jdbcReporterPollingPeriod, this.runCleanupTask, this.daysToKeep, this.jdbcScheduledCleanupPeriod);
    }

    private static void setupMetricsDatabase(DataSource dataSource) throws Exception {
        String value = System.getProperty("setup");
        if (value != null) {
            LocalDatabaseCreator databaseCreator = new LocalDatabaseCreator(dataSource);
            if (!databaseCreator.isDatabaseStructureCreated(DB_CHECK_SQL)) {
                databaseCreator.createRegistryDatabase();
            } else if (logger.isInfoEnabled()) {
                logger.info("Metrics tables exist. Skipping the Metrics Database setup process.");
            }
        }
    }
}

