/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.reporter;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.impl.reporter.AbstractReporter;
import org.wso2.carbon.metrics.impl.reporter.ScheduledReporter;

public class ConsoleReporterImpl
extends AbstractReporter
implements ScheduledReporter {
    private static final Logger logger = LoggerFactory.getLogger(ConsoleReporterImpl.class);
    private final MetricRegistry metricRegistry;
    private final MetricFilter metricFilter;
    private final long pollingPeriod;
    private ConsoleReporter consoleReporter;

    public ConsoleReporterImpl(MetricRegistry metricRegistry, MetricFilter metricFilter, long pollingPeriod) {
        super("Console");
        this.metricRegistry = metricRegistry;
        this.metricFilter = metricFilter;
        this.pollingPeriod = pollingPeriod;
    }

    @Override
    public void report() {
        if (this.consoleReporter != null) {
            this.consoleReporter.report();
        }
    }

    @Override
    public void startReporter() {
        this.consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).filter(this.metricFilter).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        this.consoleReporter.start(this.pollingPeriod, TimeUnit.SECONDS);
    }

    @Override
    public void stopReporter() {
        try {
            this.consoleReporter.stop();
            this.consoleReporter = null;
        }
        catch (Throwable e) {
            logger.error("An error occurred when trying to stop the reporter", e);
        }
    }
}

