/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.jms.internal.util;

import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.TopicPublisher;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.output.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.jms.JMSEventAdapter;
import org.wso2.carbon.event.output.adapter.jms.internal.util.JMSConnectionFactory;
import org.wso2.carbon.event.output.adapter.jms.internal.util.JMSUtils;

public class JMSMessageSender {
    private static final Log log = LogFactory.getLog(JMSMessageSender.class);
    private boolean jmsSpec11 = true;
    private Boolean isQueue = null;
    private JMSConnectionFactory jmsConnectionFactory;

    public JMSMessageSender(JMSConnectionFactory jmsConnectionFactory) {
        this.jmsSpec11 = jmsConnectionFactory.isJmsSpec11();
        this.jmsConnectionFactory = jmsConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void send(Object message, JMSEventAdapter.PublisherDetails publisherDetails, String jmsHeaders) {
        block55: {
            JMSConnectionFactory.JMSPooledConnectionHolder pooledConnection;
            boolean sendingSuccessful;
            Session session;
            Object destination;
            Boolean rollbackOnly;
            Boolean jtaCommit;
            block52: {
                Map<String, String> messageProperties = publisherDetails.getMessageConfig();
                jtaCommit = this.getBooleanProperty(messageProperties, "JTA_COMMIT_AFTER_SEND");
                rollbackOnly = this.getBooleanProperty(messageProperties, "SET_ROLLBACK_ONLY");
                Boolean persistent = this.getBooleanProperty(messageProperties, "JMS_DELIVERY_MODE");
                Integer priority = this.getIntegerProperty(messageProperties, "JMS_PRIORITY");
                Integer timeToLive = this.getIntegerProperty(messageProperties, "JMS_TIME_TO_LIVE");
                MessageProducer producer = null;
                destination = null;
                session = null;
                sendingSuccessful = false;
                pooledConnection = null;
                pooledConnection = this.jmsConnectionFactory.getConnectionFromPool();
                producer = pooledConnection.getProducer();
                session = pooledConnection.getSession();
                Message jmsMessage = this.convertToJMSMessage(message, publisherDetails.getMessageConfig(), session);
                this.setJMSTransportHeaders(jmsMessage, jmsHeaders);
                if (rollbackOnly != null && rollbackOnly.booleanValue()) {
                    jtaCommit = Boolean.FALSE;
                }
                if (persistent != null) {
                    try {
                        producer.setDeliveryMode(2);
                    }
                    catch (JMSException e) {
                        this.handleConnectionException("Error setting JMS Producer for PERSISTENT delivery", (Exception)((Object)e));
                    }
                }
                if (priority != null) {
                    try {
                        producer.setPriority(priority.intValue());
                    }
                    catch (JMSException e) {
                        this.handleConnectionException("Error setting JMS Producer priority to : " + priority, (Exception)((Object)e));
                    }
                }
                if (timeToLive != null) {
                    try {
                        producer.setTimeToLive((long)timeToLive.intValue());
                    }
                    catch (JMSException e) {
                        this.handleConnectionException("Error setting JMS Producer TTL to : " + timeToLive, (Exception)((Object)e));
                    }
                }
                if (this.jmsSpec11 || this.isQueue == null) {
                    producer.send(jmsMessage);
                } else if (this.isQueue.booleanValue()) {
                    ((QueueSender)producer).send(jmsMessage);
                } else {
                    ((TopicPublisher)producer).publish(jmsMessage);
                }
                sendingSuccessful = true;
                if (log.isDebugEnabled()) {
                    String msgId = null;
                    try {
                        msgId = jmsMessage.getJMSMessageID();
                    }
                    catch (JMSException jmse) {
                        log.error((Object)jmse.getMessage(), (Throwable)jmse);
                    }
                    log.debug((Object)(" with JMS Message ID : " + msgId + " to destination : " + producer.getDestination()));
                }
                if (jtaCommit == null) break block52;
                try {
                    if (session.getTransacted()) {
                        if (sendingSuccessful && (rollbackOnly == null || !rollbackOnly.booleanValue())) {
                            session.commit();
                        } else {
                            session.rollback();
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                    }
                }
                catch (Exception e) {
                    this.handleConnectionException("Error committing/rolling back local (i.e. session) transaction after sending of message  to destination : " + destination, e);
                }
            }
            if (pooledConnection != null) {
                this.jmsConnectionFactory.returnPooledConnection(pooledConnection);
            }
            break block55;
            catch (JMSException e) {
                block53: {
                    this.handleConnectionException("Error sending message to destination : " + destination, (Exception)((Object)e));
                    if (jtaCommit == null) break block53;
                    try {
                        if (session.getTransacted()) {
                            if (sendingSuccessful && (rollbackOnly == null || !rollbackOnly.booleanValue())) {
                                session.commit();
                            } else {
                                session.rollback();
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                        }
                    }
                    catch (Exception e2) {
                        this.handleConnectionException("Error committing/rolling back local (i.e. session) transaction after sending of message  to destination : " + destination, e2);
                    }
                }
                if (pooledConnection != null) {
                    this.jmsConnectionFactory.returnPooledConnection(pooledConnection);
                }
            }
            catch (Exception e2) {
                block54: {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    if (jtaCommit == null) break block54;
                    {
                        catch (Throwable throwable) {
                            if (jtaCommit != null) {
                                try {
                                    if (session.getTransacted()) {
                                        if (sendingSuccessful && (rollbackOnly == null || !rollbackOnly.booleanValue())) {
                                            session.commit();
                                        } else {
                                            session.rollback();
                                        }
                                    }
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                                    }
                                }
                                catch (Exception e3) {
                                    this.handleConnectionException("Error committing/rolling back local (i.e. session) transaction after sending of message  to destination : " + destination, e3);
                                }
                            }
                            if (pooledConnection != null) {
                                this.jmsConnectionFactory.returnPooledConnection(pooledConnection);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        if (session.getTransacted()) {
                            if (sendingSuccessful && (rollbackOnly == null || !rollbackOnly.booleanValue())) {
                                session.commit();
                            } else {
                                session.rollback();
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)((sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                        }
                    }
                    catch (Exception e4) {
                        this.handleConnectionException("Error committing/rolling back local (i.e. session) transaction after sending of message  to destination : " + destination, e4);
                    }
                }
                if (pooledConnection != null) {
                    this.jmsConnectionFactory.returnPooledConnection(pooledConnection);
                }
            }
        }
    }

    private Message setJMSTransportHeaders(Message message, String headerProperty) {
        HashMap<String, String> messageConfiguration = new HashMap<String, String>();
        if (headerProperty != null && message != null) {
            String[] headers = headerProperty.split(",");
            if (headers.length > 0) {
                for (String header : headers) {
                    try {
                        String[] headerPropertyWithValue = header.split(":", 2);
                        messageConfiguration.put(headerPropertyWithValue[0], headerPropertyWithValue[1]);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Header property \" " + header + " \" is not defined in the correct format"), (Throwable)e);
                    }
                }
            }
            try {
                return JMSUtils.setTransportHeaders(messageConfiguration, message);
            }
            catch (JMSException e) {
                throw new OutputEventAdapterRuntimeException((Throwable)e);
            }
        }
        return message;
    }

    public Message convertToJMSMessage(Object messageObj, Map<String, String> messageProperties, Session session) {
        TextMessage jmsMessage = null;
        try {
            if (messageObj instanceof OMElement) {
                jmsMessage = session.createTextMessage(messageObj.toString());
            } else if (messageObj instanceof String) {
                jmsMessage = session.createTextMessage((String)messageObj);
            } else if (messageObj instanceof Map) {
                MapMessage mapMessage = session.createMapMessage();
                Map sourceMessage = (Map)messageObj;
                for (Object key : sourceMessage.keySet()) {
                    mapMessage.setObject((String)key, sourceMessage.get(key));
                }
                jmsMessage = mapMessage;
            }
        }
        catch (JMSException e) {
            this.handleException("Failed to publish to topic:" + messageProperties.get("transport.jms.Destination"), (Exception)((Object)e));
        }
        return jmsMessage;
    }

    public void close() {
        this.jmsConnectionFactory.close();
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        throw new OutputEventAdapterRuntimeException(message, (Throwable)e);
    }

    private void handleConnectionException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        throw new ConnectionUnavailableException(message, (Throwable)e);
    }

    private Boolean getBooleanProperty(Map<String, String> messageProperties, String name) {
        String o = messageProperties.get(name);
        if (o != null) {
            return Boolean.valueOf(o);
        }
        return null;
    }

    private Integer getIntegerProperty(Map<String, String> messageProperties, String name) {
        String o = messageProperties.get(name);
        if (o != null) {
            return Integer.parseInt(o);
        }
        return null;
    }
}

