/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.jms.internal.util;

import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.jms.internal.util.JMSUtils;

public class JMSConnectionFactory {
    private static final Log log = LogFactory.getLog(JMSConnectionFactory.class);
    private Hashtable<String, String> parameters = new Hashtable();
    private String name;
    private Context context = null;
    private ConnectionFactory conFactory = null;
    private Destination sharedDestination = null;
    private int maxConnections;
    private GenericObjectPool connectionPool;
    private String destinationName;

    public JMSConnectionFactory(Hashtable<String, String> parameters, String name, String destination, int maxConcurrentConnections) {
        this.parameters = parameters;
        this.name = name;
        this.destinationName = destination;
        if (maxConcurrentConnections > 0) {
            this.maxConnections = maxConcurrentConnections;
        }
        try {
            this.context = new InitialContext(parameters);
            this.conFactory = JMSUtils.lookup(this.context, ConnectionFactory.class, parameters.get("transport.jms.ConnectionFactoryJNDIName"));
            log.info((Object)("JMS ConnectionFactory : " + name + " initialized"));
        }
        catch (NamingException e) {
            throw new OutputEventAdapterRuntimeException("Cannot acquire JNDI context, JMS Connection factory : " + parameters.get("transport.jms.ConnectionFactoryJNDIName") + " or default destinationName : " + parameters.get("transport.jms.Destination") + " for JMS CF : " + name + " using : " + parameters, (Throwable)e);
        }
        this.createConnectionPool();
    }

    private void createConnectionPool() {
        GenericObjectPool.Config poolConfig = new GenericObjectPool.Config();
        poolConfig.minEvictableIdleTimeMillis = 3000L;
        poolConfig.maxWait = 3000L;
        poolConfig.maxActive = this.maxConnections;
        poolConfig.maxIdle = this.maxConnections;
        poolConfig.minIdle = 0;
        poolConfig.numTestsPerEvictionRun = Math.max(1, this.maxConnections / 10);
        poolConfig.timeBetweenEvictionRunsMillis = 5000L;
        this.connectionPool = new GenericObjectPool((PoolableObjectFactory)new PoolableJMSConnectionFactory(), poolConfig);
    }

    public void returnPooledConnection(JMSPooledConnectionHolder pooledConnection) {
        try {
            this.connectionPool.returnObject((Object)pooledConnection);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private MessageProducer createProducer(Session session, Destination destination) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating a new JMS MessageProducer from JMS CF : " + this.name));
            }
            return JMSUtils.createProducer(session, destination, this.isQueue(), this.isJmsSpec11());
        }
        catch (JMSException e) {
            this.handleException("Error creating JMS producer from JMS CF : " + this.name, (Exception)((Object)e));
            return null;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public synchronized Destination getDestination() {
        try {
            if (this.sharedDestination == null) {
                this.sharedDestination = JMSUtils.lookupDestination(this.context, this.destinationName, this.parameters.get("transport.jms.DestinationType"));
            }
            return this.sharedDestination;
        }
        catch (NamingException e) {
            this.handleException("Error looking up the JMS destinationName with name " + this.destinationName + " of type " + this.parameters.get("transport.jms.DestinationType"), e);
            return null;
        }
    }

    public String getReplyToDestination() {
        return this.parameters.get("transport.jms.ReplyDestination");
    }

    public String getReplyDestinationType() {
        return this.parameters.get("transport.jms.ReplyDestinationType") != null ? this.parameters.get("transport.jms.ReplyDestinationType") : "generic";
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new OutputEventAdapterRuntimeException(msg, (Throwable)e);
    }

    public boolean isJmsSpec11() {
        return this.parameters.get("transport.jms.JMSSpecVersion") == null || "1.1".equals(this.parameters.get("transport.jms.JMSSpecVersion"));
    }

    public Boolean isQueue() {
        if (this.parameters.get("transport.jms.ConnectionFactoryType") == null && this.parameters.get("transport.jms.DestinationType") == null) {
            return null;
        }
        if (this.parameters.get("transport.jms.ConnectionFactoryType") != null) {
            if ("queue".equalsIgnoreCase(this.parameters.get("transport.jms.ConnectionFactoryType"))) {
                return true;
            }
            if ("topic".equalsIgnoreCase(this.parameters.get("transport.jms.ConnectionFactoryType"))) {
                return false;
            }
            throw new OutputEventAdapterRuntimeException("Invalid transport.jms.ConnectionFactoryType : " + this.parameters.get("transport.jms.ConnectionFactoryType") + " for JMS CF : " + this.name);
        }
        if ("queue".equalsIgnoreCase(this.parameters.get("transport.jms.DestinationType"))) {
            return true;
        }
        if ("topic".equalsIgnoreCase(this.parameters.get("transport.jms.DestinationType"))) {
            return false;
        }
        throw new OutputEventAdapterRuntimeException("Invalid transport.jms.DestinationType : " + this.parameters.get("transport.jms.DestinationType") + " for JMS CF : " + this.name);
    }

    private boolean isSessionTransacted() {
        return this.parameters.get("transport.jms.SessionTransacted") != null && Boolean.valueOf(this.parameters.get("transport.jms.SessionTransacted")) != false;
    }

    private boolean isDurable() {
        if (this.parameters.get("transport.jms.SubscriptionDurable") != null) {
            return Boolean.valueOf(this.parameters.get("transport.jms.SubscriptionDurable"));
        }
        return false;
    }

    private String getClientId() {
        return this.parameters.get("transport.jms.DurableSubscriberClientID");
    }

    public Connection createConnection() {
        Connection connection = null;
        try {
            connection = JMSUtils.createConnection(this.conFactory, this.parameters.get("transport.jms.UserName"), this.parameters.get("transport.jms.Password"), this.isJmsSpec11(), this.isQueue(), this.isDurable(), this.getClientId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("New JMS Connection from JMS CF : " + this.name + " created"));
            }
        }
        catch (JMSException e) {
            this.handleException("Error acquiring a Connection from the JMS CF : " + this.name + " using properties : " + this.parameters, (Exception)((Object)e));
        }
        return connection;
    }

    public JMSPooledConnectionHolder getConnectionFromPool() {
        try {
            return (JMSPooledConnectionHolder)this.connectionPool.borrowObject();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized void close() {
        try {
            this.connectionPool.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException e) {
                log.warn((Object)("Error while closing the InitialContext of factory : " + this.name), (Throwable)e);
            }
        }
    }

    private class PoolableJMSConnectionFactory
    implements PoolableObjectFactory {
        int count = 0;

        private PoolableJMSConnectionFactory() {
        }

        public Object makeObject() throws Exception {
            Connection con = JMSConnectionFactory.this.createConnection();
            try {
                Session session = JMSUtils.createSession(con, JMSConnectionFactory.this.isSessionTransacted(), 1, JMSConnectionFactory.this.isJmsSpec11(), JMSConnectionFactory.this.isQueue());
                MessageProducer producer = JMSConnectionFactory.this.createProducer(session, JMSConnectionFactory.this.getDestination());
                JMSPooledConnectionHolder entry = new JMSPooledConnectionHolder();
                entry.setConnection(con);
                entry.setSession(session);
                entry.setProducer(producer);
                return entry;
            }
            catch (JMSException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public void destroyObject(Object o) throws Exception {
            JMSPooledConnectionHolder entry = (JMSPooledConnectionHolder)o;
            entry.getProducer().close();
            entry.getSession().close();
            entry.getConnection().close();
        }

        public boolean validateObject(Object o) {
            return false;
        }

        public void activateObject(Object o) throws Exception {
        }

        public void passivateObject(Object o) throws Exception {
        }
    }

    public static class JMSPooledConnectionHolder {
        private Connection connection;
        private Session session;
        private MessageProducer producer;

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        public Session getSession() {
            return this.session;
        }

        public void setSession(Session session) {
            this.session = session;
        }

        public MessageProducer getProducer() {
            return this.producer;
        }

        public void setProducer(MessageProducer producer) {
            this.producer = producer;
        }
    }
}

